/*
 * Decompiled with CFR 0.152.
 */
package com.comscore.util.unittest;

import com.comscore.PublisherConfiguration;
import com.comscore.util.log.Logger;
import com.comscore.util.setup.Setup;

public class UnitTest {
    private static native void runUnitTestNative(PublisherConfiguration var0, UnitTestOutputListener var1);

    private static native boolean isUnitTestAvailableNative();

    public static boolean isUnitTestAvailable() {
        try {
            return UnitTest.isUnitTestAvailableNative();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    public static boolean runUnitTest(PublisherConfiguration publisherConfiguration, UnitTestOutputListener unitTestOutputListener) {
        if (publisherConfiguration != null) {
            try {
                UnitTest.runUnitTestNative(publisherConfiguration, unitTestOutputListener);
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Logger.e("Error using the native library", unsatisfiedLinkError);
                return false;
            }
        }
        throw new NullPointerException("The templatePublisher can not be null.");
    }

    public static void runUnitTest(PublisherConfiguration publisherConfiguration) {
        if (publisherConfiguration != null) {
            UnitTest.runUnitTest(publisherConfiguration, null);
            return;
        }
        throw new NullPointerException("The templatePublisher can not be null.");
    }

    static {
        Setup.setUp();
    }

    public static interface UnitTestOutputListener {
        public void onLogMessage(String var1);

        public void onTestStarted();

        public void onTestFinished(boolean var1, String var2);
    }
}

