/*
 * Decompiled with CFR 0.152.
 */
package com.comscore.android.util.jni;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import com.comscore.BuildConfig;
import com.comscore.android.CommonUtils;
import com.comscore.android.HostApplicationState;
import com.comscore.android.id.CrossPublisherId;
import com.comscore.android.id.DeviceId;
import com.comscore.android.id.IdHelperAndroid;
import com.comscore.android.util.AndroidTcfDataLoader;
import com.comscore.android.util.BackgroundManager;
import com.comscore.android.util.Permissions;
import com.comscore.android.util.jni.AndroidCrashReportDecorator;
import com.comscore.android.util.update.UpdateFrom5_4_x;
import com.comscore.util.CrossPublisherIdUtil;
import com.comscore.util.TcfDataLoader;
import com.comscore.util.crashreport.CrashReportDecorator;
import com.comscore.util.jni.JniComScoreHelper;
import com.comscore.util.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AndroidJniHelper
extends JniComScoreHelper {
    public static final String KEY_PACKAGE_MANAGER = "packageManager";
    private Context b;
    private BackgroundManager c;
    private UpdateFrom5_4_x d;
    private int e = -1;
    private int f = -1;
    private AndroidTcfDataLoader g;

    private static native void setContextNative(Context var0);

    public AndroidJniHelper() {
        AndroidTcfDataLoader androidTcfDataLoader;
        AndroidTcfDataLoader androidTcfDataLoader2 = androidTcfDataLoader;
        androidTcfDataLoader = new AndroidTcfDataLoader();
        v1.g = androidTcfDataLoader2;
    }

    private int a(int n) {
        if (n != 1) {
            if (n != 2) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public void setContext(Context context) {
        if (context != null) {
            this.b = context = context.getApplicationContext();
            if (context != null) {
                AndroidJniHelper.setContextNative(context);
                return;
            }
            throw new NullPointerException("The Context provided by context.getApplicationContext() cannot be null.");
        }
        throw new NullPointerException("The Context parameter provided cannot be null.");
    }

    @Override
    protected void onCoreStarted() {
        AndroidJniHelper androidJniHelper = this;
        super.onCoreStarted();
        androidJniHelper.g.setContext(this.b);
    }

    @Override
    protected CrashReportDecorator createCrashReportDecorator() {
        return new AndroidCrashReportDecorator(this);
    }

    @Override
    public boolean subscribeToForegroundNotification() {
        Context context = this.b;
        if (context instanceof Application) {
            this.c = new BackgroundManager((Application)context);
            this.c.register();
            return true;
        }
        Logger.w("Unable to detect automatically if the application is in the foreground or in the background.");
        return false;
    }

    @Override
    public boolean unsubscribeFromForegroundNotification() {
        BackgroundManager backgroundManager = ((AndroidJniHelper)((Object)backgroundManager)).c;
        if (backgroundManager != null) {
            backgroundManager.unregister();
            return true;
        }
        return false;
    }

    @Override
    protected TcfDataLoader getTcfDataLoader() {
        return this.g;
    }

    @Override
    protected String getCrossPublisherUniqueDeviceId() {
        StringBuilder stringBuilder;
        Object object = ((AndroidJniHelper)object).b;
        if (object == null) {
            return null;
        }
        object = IdHelperAndroid.getCrossPublisherDeviceId((Context)object);
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        String string = ((CrossPublisherId)object).crossPublisherId;
        if (string == null) {
            string = "";
        }
        return stringBuilder2.append(string).append(" ").append(((CrossPublisherId)object).source).toString();
    }

    @Override
    public String getAppDataDir() {
        AndroidJniHelper androidJniHelper = androidJniHelper.b;
        if (androidJniHelper == null) {
            return null;
        }
        return androidJniHelper.getFilesDir().getAbsolutePath();
    }

    @Override
    protected int getConnectivityType() {
        AndroidJniHelper androidJniHelper = androidJniHelper.b;
        if (androidJniHelper == null) {
            return 40000;
        }
        return CommonUtils.getConnectivityType((Context)androidJniHelper);
    }

    @Override
    public String getApplicationName() {
        AndroidJniHelper androidJniHelper = androidJniHelper.b;
        if (androidJniHelper == null) {
            return null;
        }
        return CommonUtils.getApplicationName((Context)androidJniHelper);
    }

    @Override
    public String getApplicationId() {
        AndroidJniHelper androidJniHelper = androidJniHelper.b;
        if (androidJniHelper == null) {
            return null;
        }
        return androidJniHelper.getPackageName();
    }

    @Override
    public String getApplicationVersion() {
        return CommonUtils.getApplicationVersion(this.b);
    }

    @Override
    public String getOsName() {
        return "android";
    }

    @Override
    public String getOsVersion() {
        return CommonUtils.getOsVersion();
    }

    @Override
    public String getRuntimeName() {
        return "android";
    }

    @Override
    public String getRuntimeVersion() {
        return this.getOsVersion();
    }

    @Override
    public String getDeviceModel() {
        return CommonUtils.getDeviceModel();
    }

    @Override
    protected int getScreenWidth() {
        AndroidJniHelper androidJniHelper = androidJniHelper.b;
        if (androidJniHelper == null) {
            return 0;
        }
        return CommonUtils.getDisplaySize((Context)androidJniHelper).x;
    }

    @Override
    protected int getScreenHeight() {
        AndroidJniHelper androidJniHelper = androidJniHelper.b;
        if (androidJniHelper == null) {
            return 0;
        }
        return CommonUtils.getDisplaySize((Context)androidJniHelper).y;
    }

    @Override
    protected String getLanguage() {
        return CommonUtils.getLanguage();
    }

    @Override
    public String getArchitecture() {
        return CommonUtils.getDeviceArchitecture();
    }

    @Override
    protected boolean isJailBroken() {
        return CommonUtils.isDeviceRooted();
    }

    @Override
    public String getPlatformEnvironmentProperties(String string) {
        AndroidJniHelper androidJniHelper = this;
        int n = IdHelperAndroid.getCrossPublisherDeviceId((Context)androidJniHelper.b).source;
        int n2 = Permissions.check(androidJniHelper.b, "android.permission.INTERNET").booleanValue();
        int n3 = Permissions.check(androidJniHelper.b, "android.permission.ACCESS_NETWORK_STATE").booleanValue();
        int n4 = Permissions.check(androidJniHelper.b, "android.permission.ACCESS_WIFI_STATE").booleanValue();
        Object[] objectArray = new Object[7];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n;
        objectArray2[1] = string;
        int n5 = 2;
        objectArray2[n5] = n2;
        n5 = 3;
        objectArray2[n5] = n3;
        n5 = 4;
        objectArray2[n5] = n4;
        objectArray2[5] = this.isLibraryInstalledUsingMaven() ? 1 : 0;
        objectArray[6] = this.e;
        return String.format(Locale.getDefault(), "%d-%s-%d%d%d-%d-%d", objectArray);
    }

    @Override
    public String[] getDeviceIds() {
        DeviceId deviceId = IdHelperAndroid.getDeviceId(((AndroidJniHelper)((Object)string)).b);
        String string = deviceId.getId() + " " + deviceId.getCommonness() + "" + deviceId.getPersistency() + " true " + deviceId.getSource() + " " + ((AndroidJniHelper)((Object)string)).a(deviceId.getSource());
        return new String[]{string};
    }

    @Override
    protected String[] getInvalidIds() {
        return IdHelperAndroid.INVALID_ID_VALUES;
    }

    @Override
    protected int getCurrentHostApplicationState() {
        int n = HostApplicationState.getState(this.b);
        if (n == -1) {
            n = 1;
        }
        if (this.e == -1) {
            this.e = n == 0 ? 1 : 2;
        }
        return n;
    }

    public int getFirstHostState() {
        return this.e;
    }

    public boolean isLibraryInstalledUsingMaven() {
        if (this.f == -1) {
            int n = ((String)BuildConfig.class.getField("FLAVOR").get(null)).startsWith("maven") ? 1 : 0;
            try {
                this.f = n;
            }
            catch (Exception exception) {
                this.f = 0;
            }
        }
        return this.f == 1;
    }

    @Override
    protected Map<String, String> getPlatformLabels(Map<String, String> map) {
        HashMap<String, String> hashMap = null;
        if (this.b != null) {
            String string;
            HashMap<String, String> hashMap2;
            hashMap = hashMap2;
            hashMap2 = new HashMap<String, String>();
            int n = IdHelperAndroid.getCrossPublisherDeviceId((Context)this.b).source;
            hashMap.put("ns_ap_res", CommonUtils.getApplicationResolution(this.b));
            if (n == 1 && !TextUtils.isEmpty((CharSequence)map.get("ns_ak")) && !TextUtils.isEmpty((CharSequence)(string = CrossPublisherIdUtil.getMD5CrossPublisherDeviceId()))) {
                hashMap.put("ns_ap_i3", string);
            }
            if (TextUtils.isEmpty((CharSequence)map.get("ns_ap_an"))) {
                hashMap.put("ns_ap_an", this.getApplicationName());
            }
            if (TextUtils.isEmpty((CharSequence)map.get("ns_ap_ver"))) {
                hashMap.put("ns_ap_ver", this.getApplicationVersion());
            }
            if (TextUtils.isEmpty((CharSequence)map.get("ns_ap_bi"))) {
                hashMap.put("ns_ap_bi", this.getApplicationId());
            }
            hashMap.put("ns_ap_ais", this.getPackageManagerName());
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPackageManagerName() {
        String string;
        Context context = ((AndroidJniHelper)((Object)string2)).b;
        if (context == null) return "unknown";
        try {
            if (Build.VERSION.SDK_INT < 30) {
                string = context.getPackageManager().getInstallerPackageName(((AndroidJniHelper)((Object)string2)).b.getPackageName());
            }
            string = context.getPackageManager().getInstallSourceInfo(((AndroidJniHelper)((Object)string2)).b.getPackageName()).getInitiatingPackageName();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return "unknown";
        }
        String string2 = string;
        if (TextUtils.isEmpty((CharSequence)string2)) return "unknown";
        return string2;
    }

    public Context getContext() {
        return this.b;
    }

    @Override
    protected boolean libraryUpdate(String object, String string, Map<String, String> map) {
        if (!(object != null && ((String)object).length() != 0 || map.containsKey("updated_from_versions"))) {
            UpdateFrom5_4_x updateFrom5_4_x;
            Object object2 = object = updateFrom5_4_x;
            ((UpdateFrom5_4_x)object2)(this.b);
            this.d = object2;
            updateFrom5_4_x.libraryUpdate(map);
            return true;
        }
        return false;
    }

    @Override
    protected boolean libraryPostUpdate(String string, String string2, Map<String, String> map, ArrayList<String> arrayList) {
        UpdateFrom5_4_x updateFrom5_4_x = ((AndroidJniHelper)((Object)updateFrom5_4_x)).d;
        if (updateFrom5_4_x != null) {
            updateFrom5_4_x.libraryPostUpdate(map, arrayList);
            return true;
        }
        return false;
    }
}

