/*
 * Decompiled with CFR 0.152.
 */
package com.comscore;

import com.comscore.util.cpp.CppJavaBinder;
import com.comscore.util.log.Logger;
import com.comscore.util.setup.Setup;
import java.util.HashMap;
import java.util.Map;

public abstract class ClientConfiguration
extends CppJavaBinder {
    long b = 0L;
    Builder c = null;

    private static native Map<String, String> getStartLabelsNative(long var0);

    private static native void removeAllPersistentLabelsNative(long var0);

    private static native void removePersistentLabelNative(long var0, String var2);

    private static native void setPersistentLabelNative(long var0, String var2, String var3);

    private static native String getPersistentLabelNative(long var0, String var2);

    private static native Map<String, String> getPersistentLabelsNative(long var0);

    private static native boolean containsPersistentLabelNative(long var0, String var2);

    private static native boolean containsStartLabelNative(long var0, String var2);

    private static native void addPersistentLabelsNative(long var0, Map<String, String> var2);

    private static native boolean isKeepAliveMeasurementEnabledNative(long var0);

    private static native boolean isSecureTransmissionEnabledNative(long var0);

    private static native boolean isHttpRedirectCachingEnabledNative(long var0);

    private static native boolean getDefaultKeepAliveMeasurementNative();

    private static native boolean getDefaultSecureTransmissionNative();

    private static native boolean getDefaultHttpRedirectCachingEnabledNative();

    ClientConfiguration() {
    }

    ClientConfiguration(Builder builder) {
        this.c = builder.a();
    }

    long a() {
        return this.b;
    }

    public Map<String, String> getStartLabels() {
        Builder builder;
        if (!Setup.isNativeLibrarySuccessfullyLoaded() && (builder = this.c) != null) {
            return builder.startLabels;
        }
        try {
            return ClientConfiguration.getStartLabelsNative(this.b);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.printException(unsatisfiedLinkError);
            return null;
        }
    }

    public void removeAllPersistentLabels() {
        try {
            ClientConfiguration.removeAllPersistentLabelsNative(this.b);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.printException(unsatisfiedLinkError);
        }
    }

    public void removePersistentLabel(String string) {
        try {
            ClientConfiguration.removePersistentLabelNative(this.b, string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.printException(unsatisfiedLinkError);
        }
    }

    public void setPersistentLabel(String string, String string2) {
        try {
            ClientConfiguration.setPersistentLabelNative(this.b, string, string2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.printException(unsatisfiedLinkError);
        }
    }

    public String getPersistentLabel(String string) {
        Builder builder;
        if (!Setup.isNativeLibrarySuccessfullyLoaded() && (builder = this.c) != null) {
            return builder.persistentLabels.get(string);
        }
        try {
            return ClientConfiguration.getPersistentLabelNative(this.b, string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.printException(unsatisfiedLinkError);
            return null;
        }
    }

    public Map<String, String> getPersistentLabels() {
        Builder builder;
        if (!Setup.isNativeLibrarySuccessfullyLoaded() && (builder = this.c) != null) {
            return builder.persistentLabels;
        }
        try {
            return ClientConfiguration.getPersistentLabelsNative(this.b);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.printException(unsatisfiedLinkError);
            return null;
        }
    }

    public boolean containsPersistentLabel(String string) {
        Builder builder;
        if (!Setup.isNativeLibrarySuccessfullyLoaded() && (builder = this.c) != null) {
            return builder.persistentLabels.containsKey(string);
        }
        try {
            return ClientConfiguration.containsPersistentLabelNative(this.b, string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.printException(unsatisfiedLinkError);
            return false;
        }
    }

    public boolean containsStartLabel(String string) {
        Builder builder;
        if (!Setup.isNativeLibrarySuccessfullyLoaded() && (builder = this.c) != null) {
            return builder.startLabels.containsKey(string);
        }
        try {
            return ClientConfiguration.containsStartLabelNative(this.b, string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.printException(unsatisfiedLinkError);
            return false;
        }
    }

    public void addPersistentLabels(Map<String, String> map) {
        try {
            ClientConfiguration.addPersistentLabelsNative(this.b, map);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.printException(unsatisfiedLinkError);
        }
    }

    @Deprecated
    public boolean isVceEnabled() {
        return false;
    }

    public boolean isKeepAliveMeasurementEnabled() {
        Builder builder;
        if (!Setup.isNativeLibrarySuccessfullyLoaded() && (builder = this.c) != null) {
            return builder.keepAliveMeasurement;
        }
        try {
            return ClientConfiguration.isKeepAliveMeasurementEnabledNative(this.b);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.printException(unsatisfiedLinkError);
            return false;
        }
    }

    public boolean isSecureTransmissionEnabled() {
        Builder builder;
        if (!Setup.isNativeLibrarySuccessfullyLoaded() && (builder = this.c) != null) {
            return builder.secureTransmission;
        }
        try {
            return ClientConfiguration.isSecureTransmissionEnabledNative(this.b);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.printException(unsatisfiedLinkError);
            return false;
        }
    }

    public boolean isHttpRedirectCachingEnabled() {
        Builder builder;
        if (!Setup.isNativeLibrarySuccessfullyLoaded() && (builder = this.c) != null) {
            return builder.httpRedirectCaching;
        }
        try {
            return ClientConfiguration.isHttpRedirectCachingEnabledNative(this.b);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.printException(unsatisfiedLinkError);
            return false;
        }
    }

    public static abstract class Builder<T extends Builder, P extends ClientConfiguration> {
        protected Map<String, String> persistentLabels;
        protected Map<String, String> startLabels;
        protected boolean keepAliveMeasurement;
        protected boolean secureTransmission;
        protected boolean httpRedirectCaching;
        protected String clientId;

        protected Builder(Builder builder) {
            this.persistentLabels = new HashMap<String, String>(builder.persistentLabels);
            this.startLabels = new HashMap<String, String>(builder.startLabels);
            this.keepAliveMeasurement = builder.keepAliveMeasurement;
            this.secureTransmission = builder.secureTransmission;
            this.httpRedirectCaching = builder.httpRedirectCaching;
            this.clientId = builder.clientId;
        }

        protected Builder() {
            HashMap hashMap;
            HashMap hashMap2;
            try {
                ((Builder)object).keepAliveMeasurement = ClientConfiguration.getDefaultKeepAliveMeasurementNative();
                ((Builder)object).secureTransmission = ClientConfiguration.getDefaultSecureTransmissionNative();
                ((Builder)object).httpRedirectCaching = ClientConfiguration.getDefaultHttpRedirectCachingEnabledNative();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Logger.e("Error using the native library: ", unsatisfiedLinkError);
            }
            Builder builder = object;
            Object object = hashMap2;
            hashMap2 = new HashMap();
            builder.persistentLabels = object;
            object = hashMap;
            hashMap = new HashMap();
            builder.startLabels = object;
        }

        protected abstract T self();

        public abstract P build();

        abstract T a();

        protected void setClientId(String string) {
            this.clientId = string;
        }

        @Deprecated
        public T vce(boolean bl) {
            return this.self();
        }

        public T persistentLabels(Map<String, String> map) {
            Builder builder = this;
            builder.persistentLabels.clear();
            builder.persistentLabels.putAll(map);
            return builder.self();
        }

        public T startLabels(Map<String, String> map) {
            Builder builder = this;
            builder.startLabels.clear();
            builder.startLabels.putAll(map);
            return builder.self();
        }

        public T keepAliveMeasurement(boolean bl) {
            this.keepAliveMeasurement = bl;
            return this.self();
        }

        public T secureTransmission(boolean bl) {
            this.secureTransmission = bl;
            return this.self();
        }

        public T httpRedirectCaching(boolean bl) {
            this.httpRedirectCaching = bl;
            return this.self();
        }
    }
}

