/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.jenkins.zadviser.common.configuration;

import com.compuware.jenkins.zadviser.Messages;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class ZAdviserGlobalConfiguration
extends GlobalConfiguration {
    private static final Logger logger = Logger.getLogger("hudson.ZAdviserGlobalConfiguration");
    private Secret accessKey;
    private String customerId;
    private Secret encryptionKey;
    private String initialDateRange;
    protected transient boolean needsSaving = false;

    public static ZAdviserGlobalConfiguration get() {
        return (ZAdviserGlobalConfiguration)((Object)GlobalConfiguration.all().get(ZAdviserGlobalConfiguration.class));
    }

    public ZAdviserGlobalConfiguration() {
        this.load();
    }

    public boolean needsSaving() {
        return this.needsSaving;
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void jobLoaded() {
        ZAdviserGlobalConfiguration globalConfig = ZAdviserGlobalConfiguration.get();
        if (globalConfig.needsSaving()) {
            globalConfig.save();
            logger.info("Compuware global zAdviser configuration has been saved.");
        }
    }

    public boolean configure(StaplerRequest req, JSONObject json) {
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    public Secret getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(Secret accessKey) {
        this.accessKey = ZAdviserGlobalConfiguration.handleEmpty(accessKey);
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public Secret getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(Secret encryptionKey) {
        this.encryptionKey = ZAdviserGlobalConfiguration.handleEmpty(encryptionKey);
    }

    public String getInitialDateRange() {
        return this.initialDateRange;
    }

    public void setInitialDateRange(String initialDateRange) {
        this.initialDateRange = initialDateRange;
    }

    public FormValidation doCheckInitialDateRange(@QueryParameter String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            try {
                Integer.parseUnsignedInt(StringUtils.trim((String)value));
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.checkInitialDateRangeError());
            }
        }
        return FormValidation.ok();
    }

    private static Secret handleEmpty(Secret secret) {
        return secret == null || StringUtils.isBlank((CharSequence)secret.getPlainText()) ? null : secret;
    }
}

