/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.jenkins.build;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.compuware.jenkins.build.CodeCoverageBuilder;
import com.compuware.jenkins.build.RemoteSystemProperties;
import com.compuware.jenkins.common.configuration.CpwrGlobalConfiguration;
import com.compuware.jenkins.common.configuration.HostConnection;
import com.compuware.jenkins.common.utils.ArgumentUtils;
import com.compuware.jenkins.common.utils.CLIVersionUtils;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class CodeCoverageScanner {
    private CodeCoverageBuilder m_ccBuilder;

    public CodeCoverageScanner(CodeCoverageBuilder config) {
        this.m_ccBuilder = config;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        CpwrGlobalConfiguration globalConfig = CpwrGlobalConfiguration.get();
        VirtualChannel vChannel = launcher.getChannel();
        FilePath cliDirectory = new FilePath(vChannel, globalConfig.getTopazCLILocation(launcher));
        CLIVersionUtils.checkCLICompatibility((FilePath)cliDirectory, (String)"18.2.3");
        Properties remoteProperties = (Properties)vChannel.call((Callable)new RemoteSystemProperties());
        String remoteFileSeparator = remoteProperties.getProperty("file.separator");
        boolean isShell = launcher.isUnix();
        String osFile = isShell ? "CodeCoverageCLI.sh" : "CodeCoverageCLI.bat";
        String cliScriptFile = globalConfig.getTopazCLILocation(launcher) + remoteFileSeparator + osFile;
        logger.println("cliScriptFile: " + cliScriptFile);
        String cliScriptFileRemote = new FilePath(vChannel, cliScriptFile).getRemote();
        logger.println("cliScriptFileRemote: " + cliScriptFileRemote);
        HostConnection connection = globalConfig.getHostConnection(this.m_ccBuilder.getConnectionId());
        String host = ArgumentUtils.escapeForScript((String)connection.getHost());
        String port = ArgumentUtils.escapeForScript((String)connection.getPort());
        StandardUsernamePasswordCredentials credentials = globalConfig.getLoginInformation((Item)run.getParent(), this.m_ccBuilder.getCredentialsId());
        String userId = ArgumentUtils.escapeForScript((String)credentials.getUsername());
        String password = ArgumentUtils.escapeForScript((String)credentials.getPassword().getPlainText());
        String codePage = connection.getCodePage();
        String timeout = ArgumentUtils.escapeForScript((String)connection.getTimeout());
        String targetFolder = ArgumentUtils.escapeForScript((String)workspace.getRemote());
        String topazCliWorkspace = workspace.getRemote() + remoteFileSeparator + "TopazCliWkspc";
        logger.println("topazCliWorkspace: " + topazCliWorkspace);
        String analysisPropertiesPath = this.m_ccBuilder.getAnalysisPropertiesPath();
        String analysisPropertiesStr = this.m_ccBuilder.getAnalysisProperties();
        Properties analysisProperties = this.buildAnalysisProperties(analysisPropertiesPath, analysisPropertiesStr, workspace, logger);
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(cliScriptFileRemote);
        args.add(new String[]{"-host", host});
        args.add(new String[]{"-port", port});
        args.add(new String[]{"-id", userId});
        args.add("-pass");
        args.add(password, true);
        args.add(new String[]{"-code", codePage});
        args.add(new String[]{"-timeout", timeout});
        args.add(new String[]{"-targetFolder", targetFolder});
        args.add(new String[]{"-data", topazCliWorkspace});
        logger.print("Analysis properties after parsing/merging: ");
        for (Map.Entry<Object, Object> entry : analysisProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            logger.print(key + '=' + value + ' ');
            if (!StringUtils.isNotBlank((String)value)) continue;
            value = key.equals("cc.sources") ? ArgumentUtils.escapeCommaDelimitedPathsForScript((String)value) : ArgumentUtils.escapeForScript((String)value);
            key = ArgumentUtils.prefixWithDash((String)key);
            args.add(new String[]{key, value});
        }
        logger.println();
        EnvVars env = run.getEnvironment(listener);
        FilePath workDir = new FilePath(vChannel, workspace.getRemote());
        workDir.mkdirs();
        int exitValue = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)logger).pwd(workDir).join();
        if (exitValue != 0) {
            throw new AbortException("Call " + osFile + " exited with value = " + exitValue);
        }
        logger.println("Call " + osFile + " exited with value = " + exitValue);
    }

    protected Properties buildAnalysisProperties(String analysisPropertiesFilePath, String analysisPropertiesStr, FilePath workspace, PrintStream logger) {
        byte[] bytes;
        Properties analysisProperties;
        block11: {
            analysisProperties = new Properties();
            Path filePath = null;
            boolean filePathSpecified = StringUtils.isNotBlank((String)analysisPropertiesFilePath);
            if (filePathSpecified) {
                filePath = Paths.get(analysisPropertiesFilePath, new String[0]);
                if (!filePath.isAbsolute()) {
                    filePath = Paths.get(workspace.getRemote(), analysisPropertiesFilePath);
                }
            } else {
                filePath = Paths.get(workspace.getRemote(), "ccanalysis.properties");
            }
            bytes = null;
            try {
                logger.println("Analysis properties file path: " + filePath.toAbsolutePath());
                bytes = Files.readAllBytes(filePath);
            }
            catch (IOException e) {
                if (!filePathSpecified) break block11;
                logger.println("An IOException occurred while obtaining analysis properties from the file: " + e.toString());
                e.printStackTrace(logger);
            }
        }
        if (bytes != null) {
            try {
                String filePropertiesStr = new String(bytes, "UTF-8");
                logger.println("Analysis properties string from file: " + filePropertiesStr);
                Properties fileProperties = ArgumentUtils.convertStringToProperties((String)filePropertiesStr);
                analysisProperties.putAll((Map<?, ?>)fileProperties);
            }
            catch (IOException e) {
                logger.println("An IOException occurred while parsing analysis properties from the file: " + e.toString());
                e.printStackTrace(logger);
            }
        }
        if (StringUtils.isNotBlank((String)analysisPropertiesStr)) {
            try {
                logger.println("Analysis properties string from UI: " + analysisPropertiesStr);
                Properties strProperties = ArgumentUtils.convertStringToProperties((String)analysisPropertiesStr);
                analysisProperties.putAll((Map<?, ?>)strProperties);
            }
            catch (IOException e) {
                logger.println("An IOException occurred while obtaining analysis properties from the UI: " + e.toString());
                e.printStackTrace(logger);
            }
        }
        return analysisProperties;
    }
}

