/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.jenkins.strobe;

import com.compuware.jenkins.strobe.StrobeMeasurementBuilder;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class StrobeMeasurementRunner {
    private final StrobeMeasurementBuilder smBuilder;

    public StrobeMeasurementRunner(StrobeMeasurementBuilder smBuilder) {
        this.smBuilder = smBuilder;
    }

    public boolean run(Run<?, ?> build, Launcher launcher, FilePath workspaceFilePath, TaskListener listener, Secret token) throws IOException {
        String url = this.smBuilder.getCesUrl() + "/strobe/measurement";
        listener.getLogger().println("Posting to URL " + url);
        HttpPost post = new HttpPost(url);
        String DEFAULT_EMAIL = "dummy@compuware.com";
        String emailToUse = this.smBuilder.getEmailto().isEmpty() ? DEFAULT_EMAIL : StringUtils.trimToEmpty((String)this.smBuilder.getEmailto());
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"reqType\":\"" + StringUtils.trimToEmpty((String)this.smBuilder.getRequestType()) + "\",");
        json.append("\"jobName\":\"" + StringUtils.trimToEmpty((String)this.smBuilder.getJobName()) + "\",");
        json.append("\"system\":\"" + StringUtils.trimToEmpty((String)this.smBuilder.getSystem()) + "\",");
        json.append("\"tags\":\"" + StringUtils.trimToEmpty((String)this.smBuilder.getTags()) + "\",");
        json.append("\"profileName\":\"" + StringUtils.trimToEmpty((String)this.smBuilder.getProfileName()) + "\",");
        json.append("\"emailto\":\"" + emailToUse + "\",");
        json.append("\"duration\":\"" + StringUtils.trimToEmpty((String)this.smBuilder.getDuration()) + "\",");
        json.append("\"samples\":\"" + StringUtils.trimToEmpty((String)this.smBuilder.getSamples()) + "\",");
        json.append("\"limit\":\"" + StringUtils.trimToEmpty((String)this.smBuilder.getLimit()) + "\",");
        json.append("\"finalAction\":\"" + StringUtils.trimToEmpty((String)this.smBuilder.getFinalAction()) + "\",");
        json.append("\"hlq\":\"" + StringUtils.trimToEmpty((String)this.smBuilder.getHlq()) + "\",");
        json.append("\"tranid\":\"" + StringUtils.trimToEmpty((String)this.smBuilder.getTransactionId()) + "\",");
        json.append("\"initBy\":\"CI\",");
        if (this.smBuilder.getUrl() != null && !this.smBuilder.getUrl().equals("")) {
            json.append("\"apiNotificationData\":{");
            json.append("\"method\":\"" + this.smBuilder.getMethod() + "\",");
            json.append("\"returnURL\":\"" + this.smBuilder.getUrl() + "\",");
            json.append("\"httpHeaders\":[" + this.getFormattedHeaders(this.smBuilder.getHeaders()) + "],");
            json.append("\"body\":\"" + this.smBuilder.getBody().replaceAll("\"", "\\\\\"").replaceAll("\\r|\\n", "") + "\",");
            json.append("\"triggerType\":0,");
            json.append("\"events\":\"*\",");
            json.append("\"productID\":\"STROBE\",");
            json.append("\"productInstance\":\"strobe\",");
            json.append("\"resource\":\"\"");
            json.append("}");
        } else {
            listener.getLogger().println("No callback configured");
        }
        json.append("}");
        post.setEntity((HttpEntity)new StringEntity(json.toString()));
        post.addHeader("Content-Type", "application/json");
        if (token != null) {
            post.addHeader("Authorization", token.getPlainText());
        }
        int returnCode = 99999;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            String results = EntityUtils.toString((HttpEntity)response.getEntity());
            returnCode = this.getReturnCode(results);
            if (Integer.valueOf(returnCode) < 0) {
                listener.getLogger().println("Invalid results: " + results);
                boolean bl = false;
                return bl;
            }
            listener.getLogger().println("Return Code=" + returnCode);
            listener.getLogger().println("Session Request Number=" + this.getSessionRequestNumber(results));
        }
        return returnCode < 5;
    }

    private int getReturnCode(String results) {
        String returnCodeString = "returnCode\":";
        int returnCodeIndex = results.indexOf(returnCodeString);
        if (returnCodeIndex == -1) {
            return returnCodeIndex;
        }
        int commaIndex = results.indexOf(",", returnCodeIndex);
        String returnCode = results.substring(returnCodeIndex + returnCodeString.length(), commaIndex);
        return Integer.parseInt(returnCode);
    }

    private int getSessionRequestNumber(String results) {
        String sessionRequestNumberString = "@number\":";
        int sessionRequestNumberIndex = results.indexOf(sessionRequestNumberString);
        int commaIndex = results.indexOf(",", sessionRequestNumberIndex);
        String sessionRequestNumber = results.substring(sessionRequestNumberIndex + sessionRequestNumberString.length(), commaIndex);
        if (sessionRequestNumber.length() == 6) {
            sessionRequestNumber = sessionRequestNumber.substring(1, sessionRequestNumber.length() - 1);
        }
        return Integer.parseInt(sessionRequestNumber);
    }

    private String getFormattedHeaders(String headers) {
        StringBuilder headerJson = new StringBuilder("");
        if (!headers.contentEquals("")) {
            String[] headersArray;
            for (String header : headersArray = headers.split(";")) {
                String[] keyValuePair = header.split(":");
                if (!headerJson.toString().equals("")) {
                    headerJson.append(",");
                }
                headerJson.append("{");
                headerJson.append("\"name\":\"" + keyValuePair[0] + "\"");
                headerJson.append(",");
                headerJson.append("\"value\":\"" + keyValuePair[1] + "\"");
                headerJson.append("}");
            }
        }
        return headerJson.toString();
    }
}

