/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.util;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.compuware.ces.model.BasicAuthentication;
import com.compuware.ces.model.HttpHeader;
import com.compuware.ispw.model.changeset.DeployTargetLoadModule;
import com.compuware.ispw.model.changeset.LevelLoadLib;
import com.compuware.ispw.model.changeset.LifeCycleLoadModule;
import com.compuware.ispw.model.changeset.Program;
import com.compuware.ispw.model.changeset.ProgramList;
import com.compuware.ispw.model.rest.MessageResponse;
import com.compuware.ispw.model.rest.SetInfoResponse;
import com.compuware.ispw.model.rest.TaskInfo;
import com.compuware.ispw.model.ttt.rest.JaxbDeployTargetLoadModule;
import com.compuware.ispw.model.ttt.rest.JaxbLevelLoadLib;
import com.compuware.ispw.model.ttt.rest.JaxbLifeCycleLoadModule;
import com.compuware.ispw.model.ttt.rest.JaxbProgram;
import com.compuware.ispw.restapi.JsonProcessor;
import com.compuware.ispw.restapi.ResponseContentSupplier;
import com.compuware.ispw.restapi.util.ReflectUtils;
import com.compuware.jenkins.common.configuration.CpwrGlobalConfiguration;
import com.compuware.jenkins.common.configuration.HostConnection;
import hudson.AbortException;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;

public class RestApiUtils {
    private static Logger logger = Logger.getLogger(RestApiUtils.class);

    public static String join(String delimiter, String[] stringArray, boolean appendEqualSign) {
        String result = "";
        StringBuilder sb = new StringBuilder();
        if (stringArray != null) {
            for (String string : stringArray) {
                sb.append(string).append(appendEqualSign ? "=" : "").append(delimiter);
            }
        }
        if (sb.length() > 0) {
            result = sb.toString();
            result = result.substring(0, result.length() - delimiter.length());
        }
        return result;
    }

    public static ArrayList<HttpHeader> toHttpHeaders(String flat) {
        String[] nameValues;
        ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>();
        for (String nameValue : nameValues = flat.split(";")) {
            int indexOfColon;
            if (!StringUtils.isNotEmpty((CharSequence)(nameValue = StringUtils.trimToEmpty((String)nameValue))) || (indexOfColon = nameValue.indexOf(":")) == -1) continue;
            String name = StringUtils.trimToEmpty((String)nameValue.substring(0, indexOfColon));
            String value = StringUtils.trimToEmpty((String)nameValue.substring(indexOfColon + 1, nameValue.length()));
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            HttpHeader header = new HttpHeader();
            header.setName(name);
            header.setValue(value);
            headers.add(header);
        }
        return headers;
    }

    public static BasicAuthentication toBasicAuthentication(String flat) {
        BasicAuthentication auth = null;
        int indexOfColon = flat.indexOf(":");
        if (indexOfColon != -1) {
            String username = StringUtils.trimToEmpty((String)flat.substring(0, indexOfColon));
            String password = StringUtils.trimToEmpty((String)flat.substring(indexOfColon + 1, flat.length()));
            auth = new BasicAuthentication();
            auth.setUsername(username);
            auth.setPassword(password);
        }
        return auth;
    }

    public static boolean containsIgnoreCase(List<String> tokens, String anotherToken) {
        for (String token : tokens) {
            if (!token.equalsIgnoreCase(anotherToken)) continue;
            return true;
        }
        return false;
    }

    public static String fixCesTaskListResponseJson(String responseJson) {
        String fixedResponseJson = responseJson;
        if (responseJson.startsWith("{\"tasks\":{")) {
            fixedResponseJson = responseJson.replace("{\"tasks\":{", "{\"tasks\":[{");
            fixedResponseJson = fixedResponseJson.replace("}}", "}]}");
        }
        return fixedResponseJson;
    }

    public static String fixCesContainerListResponseJson(String responseJson) {
        String fixedResponseJson = responseJson;
        if (responseJson.startsWith("{\"containers\":{")) {
            fixedResponseJson = responseJson.replace("{\"containers\":{", "{\"containers\":[{");
            fixedResponseJson = fixedResponseJson.replace("}}", "}]}");
        }
        return fixedResponseJson;
    }

    public static String fixWorkListResponseJson(String responseJson) {
        String fixedResponseJson = responseJson;
        if (responseJson.startsWith("{\"workList\":{")) {
            fixedResponseJson = responseJson.replace("{\"workList\":{", "{\"workList\":[{");
            fixedResponseJson = fixedResponseJson.replace("}}", "}]}");
        }
        return fixedResponseJson;
    }

    public static ListBoxModel buildConnectionIdItems(@AncestorInPath Jenkins context, @QueryParameter String connectionId, @AncestorInPath Item project) {
        CpwrGlobalConfiguration globalConfig = CpwrGlobalConfiguration.get();
        HostConnection[] hostConnections = globalConfig.getHostConnections();
        ListBoxModel model = new ListBoxModel();
        model.add((Object)new ListBoxModel.Option("", "", false));
        for (HostConnection connection : hostConnections) {
            boolean isSelected = false;
            if (connectionId != null) {
                isSelected = connectionId.matches(connection.getConnectionId());
            }
            model.add((Object)new ListBoxModel.Option(connection.getDescription() + " [" + connection.getHostPort() + ']', connection.getConnectionId(), isSelected));
        }
        return model;
    }

    public static HostConnection getHostConnection(String connectionId) {
        CpwrGlobalConfiguration globalConfig = CpwrGlobalConfiguration.get();
        HostConnection hostConnection = globalConfig.getHostConnection(connectionId);
        return hostConnection;
    }

    public static String getCesUrl(String connectionId, PrintStream logger) throws AbortException {
        HostConnection hostConnection = RestApiUtils.getHostConnection(connectionId);
        RestApiUtils.assertNotNull(logger, hostConnection, "Unable to connect to host connection for connectionId: %s", connectionId);
        String cesUrl = StringUtils.trimToEmpty((String)hostConnection.getCesUrl());
        if (!cesUrl.toLowerCase().startsWith("http")) {
            throw new AbortException("Host connection does NOT contain a valid CES URL. Please re-configure in 'Manage Jenkins | Configure System | Compuware Configurations' section; CES URL=" + cesUrl);
        }
        try {
            URL url = new URL(cesUrl);
            String protocol = url.getProtocol();
            String host = url.getHost();
            int port = url.getPort();
            if (port <= 0) {
                if ("http".equals(protocol.toLowerCase())) {
                    port = 80;
                } else if ("https".equals(protocol.toLowerCase())) {
                    port = 443;
                }
            }
            cesUrl = protocol + "://" + host + ":" + port;
        }
        catch (MalformedURLException x) {
            throw new AbortException("Host connection does NOT contain a valid CES URL. Please re-configure in 'Manage Jenkins | Configure System | Compuware Configurations' section: " + x.getMessage() + "; CES URL=" + cesUrl);
        }
        return cesUrl;
    }

    public static String getIspwHostLabel(String connectionId) {
        HostConnection hostConnection = RestApiUtils.getHostConnection(connectionId);
        String host = StringUtils.trimToEmpty((String)hostConnection.getHost());
        String port = StringUtils.trimToEmpty((String)hostConnection.getPort());
        String cesIspwHost = host + "-" + port;
        return cesIspwHost;
    }

    public static String getCesToken(String credentialsId, Item item) {
        List creds = CredentialsMatchers.filter((List)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)StringUtils.trimToEmpty((String)credentialsId)));
        String token = "";
        if (creds != null && creds.size() > 0) {
            StringCredentials cred = (StringCredentials)creds.get(0);
            token = cred.getSecret().getPlainText();
        }
        return token;
    }

    public static ListBoxModel buildCredentialsIdItems(@AncestorInPath Jenkins context, @QueryParameter String credentialsId, @AncestorInPath Item project) {
        List creds = CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, Collections.emptyList());
        StandardListBoxModel model = new StandardListBoxModel();
        model.add((Object)new ListBoxModel.Option("", "", false));
        for (StringCredentials c : creds) {
            boolean isSelected = false;
            if (credentialsId != null) {
                isSelected = credentialsId.matches(c.getId());
            }
            String description = StringUtils.trimToEmpty((String)c.getDescription());
            model.add((Object)new ListBoxModel.Option(description, c.getId(), isSelected));
        }
        return model;
    }

    public static ListBoxModel buildIspwActionItems(@AncestorInPath Jenkins context, @QueryParameter String ispwAction, @AncestorInPath Item project) {
        Object[] publishedActions = ReflectUtils.listPublishedCommands();
        ListBoxModel model = new ListBoxModel();
        model.add((Object)new ListBoxModel.Option("", "", false));
        Arrays.sort(publishedActions);
        for (Object action : publishedActions) {
            boolean isSelected = false;
            if (ispwAction != null) {
                isSelected = ((String)action).matches(ispwAction);
            }
            model.add((Object)new ListBoxModel.Option((String)action, (String)action, isSelected));
        }
        return model;
    }

    public static String maskToken(String token) {
        if (RestApiUtils.isIspwDebugMode()) {
            return token;
        }
        StringBuffer masked = new StringBuffer(StringUtils.trimToEmpty((String)token));
        if (token.length() >= 8) {
            masked.setLength(0);
            String s1 = token.substring(0, 2);
            masked.append(s1);
            for (int i = 0; i < token.length() - 4; ++i) {
                masked.append("*");
            }
            String s2 = token.substring(token.length() - 2, token.length());
            masked.append(s2);
        }
        return masked.toString();
    }

    public static boolean logMessageIfAny(PrintStream logger, ResponseContentSupplier response, boolean isError) {
        JsonProcessor jsonProcessor;
        MessageResponse messageResp;
        String message;
        boolean anyMessage = false;
        String jsonContent = StringUtils.trimToEmpty((String)response.getContent());
        if (jsonContent.startsWith("{") && jsonContent.endsWith("}") && StringUtils.isNotBlank((CharSequence)(message = StringUtils.trimToEmpty((String)(messageResp = (jsonProcessor = new JsonProcessor()).parse(jsonContent, MessageResponse.class)).getMessage()).replaceAll("(\\s)+", " ").replaceAll("( \\.)", ".")))) {
            anyMessage = true;
            if (isError) {
                logger.println("Error - " + message);
            } else {
                logger.println("Message - " + message);
            }
        }
        return anyMessage;
    }

    public static String getSystemProperty(String key) {
        String result = System.getProperty(key);
        return StringUtils.trimToEmpty((String)result);
    }

    public static boolean isIspwDebugMode() {
        String debugMode = RestApiUtils.getSystemProperty("ispwDebugMode");
        return "true".equalsIgnoreCase(debugMode);
    }

    public static void assertNotNull(PrintStream logger, Object object, String message, Object ... args) throws AbortException {
        if (object == null) {
            throw new AbortException(String.format(message, args));
        }
        if (RestApiUtils.isIspwDebugMode()) {
            logger.println(String.format("%s=%s", object.getClass().getName(), object));
        }
    }

    public static void assertNotNull(PrintStream logger, Object object, String message) throws AbortException {
        RestApiUtils.assertNotNull(logger, object, message, "");
    }

    public static List<String> listAllParams(String contextPath) {
        ArrayList<String> queryParms = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\{(\\w+)\\}");
        Matcher matcher = pattern.matcher(contextPath);
        while (matcher.find()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                String key = matcher.group(i);
                String key2 = key.substring(1, key.length() - 1);
                queryParms.add(key2);
            }
        }
        return queryParms;
    }

    public static List<String> listQueryParams(String contextPath) {
        List<String> queryParams = new ArrayList<String>();
        int index = contextPath.indexOf("?");
        if (index != -1) {
            String s2 = contextPath.substring(index);
            queryParams = RestApiUtils.listAllParams(s2);
        }
        return queryParams;
    }

    public static String cleanContextPath(String contextPath) {
        String resultPath = contextPath;
        List<String> queryParams = RestApiUtils.listQueryParams(contextPath);
        int index = (contextPath = contextPath.replace("?&", "?")).indexOf("?");
        if (index != -1) {
            String s1 = contextPath.substring(0, index);
            String s2 = contextPath.substring(index);
            for (String queryParam : queryParams) {
                s2 = s2.replace(queryParam + "={" + queryParam + "}", "");
            }
            if ((s2 = s2.replaceAll("[&]+", "&")).endsWith("&")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
            resultPath = s1 + s2;
        }
        return resultPath;
    }

    public static ArrayList<String> getVariables(String s) {
        String regex = "\\{\\w*\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(s);
        ArrayList<String> vars = new ArrayList<String>();
        while (matcher.find()) {
            vars.add(matcher.group().replace("{", "").replace("}", ""));
        }
        return vars;
    }

    public static ProgramList convertSetInfoResp(SetInfoResponse setInfoResp) {
        List<TaskInfo> taskInfos;
        ProgramList programList = new ProgramList();
        if (setInfoResp != null && (taskInfos = setInfoResp.getTasks()) != null && !taskInfos.isEmpty()) {
            for (TaskInfo taskInfo : taskInfos) {
                List<JaxbDeployTargetLoadModule> jaxbDeployLoads;
                JaxbProgram jaxbProgram = taskInfo.getJaxbProgram();
                if (jaxbProgram == null) continue;
                Program program = new Program();
                program.setStream(jaxbProgram.getStream());
                program.setApplication(jaxbProgram.getApplication());
                program.setIsImpact(jaxbProgram.getIsImpact());
                program.setLevel(jaxbProgram.getLevel());
                program.setProgramLanguage(jaxbProgram.getProgramLanguage());
                program.setProgramName(jaxbProgram.getProgramName());
                programList.addProgram(program);
                List<JaxbLifeCycleLoadModule> jaxbLifeCycleLoads = jaxbProgram.getLifeCycleLoadModules();
                if (jaxbLifeCycleLoads != null && !jaxbLifeCycleLoads.isEmpty()) {
                    for (JaxbLifeCycleLoadModule jaxbLifeCycleLoad : jaxbLifeCycleLoads) {
                        LifeCycleLoadModule lclm = new LifeCycleLoadModule();
                        program.addLifeCycleLoadModule(lclm);
                        lclm.setComponentClass(jaxbLifeCycleLoad.getComponentClass());
                        lclm.setComponentType(jaxbLifeCycleLoad.getComponentType());
                        lclm.setLoadLibName(jaxbLifeCycleLoad.getLoadLibName());
                        lclm.setLoadModName(jaxbLifeCycleLoad.getLoadModName());
                        List<JaxbLevelLoadLib> jaxbLevelLoads = jaxbLifeCycleLoad.getLoadLibConcatenation();
                        for (JaxbLevelLoadLib jaxbLevelLoad : jaxbLevelLoads) {
                            LevelLoadLib levelLoadLib = new LevelLoadLib();
                            lclm.addLoadLibConcatenation(levelLoadLib);
                            levelLoadLib.setLevel(jaxbLevelLoad.getLevel());
                            levelLoadLib.setLoadLib(jaxbLevelLoad.getLoadLib());
                        }
                    }
                }
                if ((jaxbDeployLoads = jaxbProgram.getDeployTargetLoadModules()) == null || jaxbDeployLoads.isEmpty()) continue;
                for (JaxbDeployTargetLoadModule jaxbDeployLoad : jaxbDeployLoads) {
                    DeployTargetLoadModule dtlm = new DeployTargetLoadModule();
                    program.addDeployTargetLoadModule(dtlm);
                    dtlm.setComponentClass(jaxbDeployLoad.getComponentClass());
                    dtlm.setComponentType(jaxbDeployLoad.getComponentType());
                    dtlm.setDeployEnvironment(jaxbDeployLoad.getDeployEnvironment());
                    dtlm.setDeployType(jaxbDeployLoad.getDeployType());
                    dtlm.setLoadLibName(jaxbDeployLoad.getLoadLibName());
                    dtlm.setLoadModName(jaxbDeployLoad.getLoadModName());
                    dtlm.setSubenvironment(jaxbDeployLoad.getSubenvironment());
                    dtlm.setSystem(jaxbDeployLoad.getSystem());
                }
            }
        }
        return programList;
    }

    public static String getRuntimeConfig(String ispwRequestBody) {
        String runtimeConfig = "";
        if (StringUtils.isNotBlank((CharSequence)ispwRequestBody)) {
            String[] lines;
            for (String line : lines = ispwRequestBody.split("\n")) {
                int indexOfEqualSign;
                if ((line = StringUtils.trimToEmpty((String)line)).startsWith("#") || (indexOfEqualSign = line.indexOf("=")) == -1) continue;
                String name = StringUtils.trimToEmpty((String)line.substring(0, indexOfEqualSign));
                String value = StringUtils.trimToEmpty((String)line.substring(indexOfEqualSign + 1, line.length()));
                if (!"runtimeConfiguration".equals(name)) continue;
                runtimeConfig = value;
                break;
            }
        }
        return runtimeConfig;
    }
}

