/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.util;

import java.util.HashMap;
import java.util.Map;

public enum Operation {
    BROWSE("B"),
    CHECKOUT("C"),
    DELETE("D"),
    EDIT("S"),
    FALLBACK("F"),
    GENERATE_PARMS("GP"),
    GENERATE("G"),
    IMPLEMENT("I"),
    LOADED("TL"),
    PROMOTE("P"),
    RENAME("RE"),
    REGRESS("X"),
    TRANSFER("T"),
    UPDATE_REPLACE_VERSION("UV"),
    UNDEFINED(" ");

    private String code;
    private String description;
    private String pastTense;
    private static final Map<String, Operation> codeCache;
    private static final Map<String, Operation> descriptionCache;
    private static final Map<String, Operation> descriptionCacheUpperCase;

    private Operation(String code) {
        this.code = code;
        this.description = this.initializeDescription();
        this.pastTense = this.initializePastTenseDescription();
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPastTenseDescription() {
        return this.pastTense;
    }

    private String initializeDescription() {
        switch (this.getCode()) {
            case "B": {
                return "Browse";
            }
            case "C": {
                return "Checkout";
            }
            case "D": {
                return "Delete";
            }
            case "S": {
                return "Edit";
            }
            case "F": {
                return "Fallback";
            }
            case "FB": {
                return "Fallback";
            }
            case "GP": {
                return "Generate with Parms";
            }
            case "G": {
                return "Generate";
            }
            case "I": {
                return "Implement";
            }
            case "P": {
                return "Promote";
            }
            case "X": {
                return "Regress";
            }
            case "RE": {
                return "Rename";
            }
            case "T": {
                return "Transfer";
            }
            case "TL": {
                return "Loaded";
            }
            case "UV": {
                return "Update Replace Version";
            }
        }
        return this.getCode();
    }

    private String initializePastTenseDescription() {
        switch (this.getCode()) {
            case "B": {
                return "Browsed";
            }
            case "C": {
                return "Checked Out";
            }
            case "D": {
                return "Deleted";
            }
            case "S": {
                return "Edited";
            }
            case "F": {
                return "Fellback";
            }
            case "FB": {
                return "Fellback";
            }
            case "GP": {
                return "Generated with Parms";
            }
            case "G": {
                return "Generated";
            }
            case "I": {
                return "Implemented";
            }
            case "P": {
                return "Promoteed";
            }
            case "X": {
                return "Regressed";
            }
            case "RE": {
                return "Renamed";
            }
            case "T": {
                return "Transfered";
            }
            case "TL": {
                return "Loaded";
            }
            case "UV": {
                return "Updated Replace Version";
            }
        }
        return this.getCode();
    }

    public static Operation getByCode(String code) {
        return codeCache.get(code);
    }

    public static Operation getByDescription(String description) {
        return descriptionCache.get(description);
    }

    public static Operation getByDescription(String description, boolean ignoreCase) {
        if (ignoreCase) {
            return description == null ? null : descriptionCacheUpperCase.get(description.toUpperCase());
        }
        return Operation.getByDescription(description);
    }

    static {
        codeCache = new HashMap<String, Operation>();
        descriptionCache = new HashMap<String, Operation>();
        descriptionCacheUpperCase = new HashMap<String, Operation>();
        for (Operation operation : Operation.values()) {
            codeCache.put(operation.getCode(), operation);
            descriptionCache.put(operation.getDescription(), operation);
            descriptionCacheUpperCase.put(operation.getDescription().toUpperCase(), operation);
        }
    }
}

