/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.util;

import com.compuware.ispw.restapi.HttpMode;
import com.compuware.ispw.restapi.util.HttpBodyDelete;
import com.compuware.ispw.restapi.util.HttpRequestNameValuePair;
import com.compuware.ispw.restapi.util.RequestAction;
import com.compuware.ispw.restapi.util.RestApiUtils;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;

public class HttpClientUtil {
    public HttpRequestBase createRequestBase(RequestAction requestAction) throws IOException {
        HttpRequestBase httpRequestBase = this.doCreateRequestBase(requestAction);
        for (HttpRequestNameValuePair header : requestAction.getHeaders()) {
            httpRequestBase.addHeader(header.getName(), header.getValue());
        }
        return httpRequestBase;
    }

    private HttpRequestBase doCreateRequestBase(RequestAction requestAction) throws IOException {
        HttpBodyDelete http;
        if (requestAction.getMode() == HttpMode.HEAD) {
            return new HttpHead(this.getUrlWithParams(requestAction));
        }
        if (requestAction.getMode() == HttpMode.GET) {
            return new HttpGet(this.getUrlWithParams(requestAction));
        }
        String uri = requestAction.getUrl().toString();
        if (requestAction.getMode() == HttpMode.DELETE) {
            http = new HttpBodyDelete(uri);
        } else if (requestAction.getMode() == HttpMode.PUT) {
            http = new HttpPut(uri);
        } else if (requestAction.getMode() == HttpMode.PATCH) {
            http = new HttpPatch(uri);
        } else {
            if (requestAction.getMode() == HttpMode.OPTIONS) {
                return new HttpOptions(this.getUrlWithParams(requestAction));
            }
            http = new HttpPost(uri);
        }
        http.setEntity(this.makeEntity(requestAction));
        return http;
    }

    private HttpEntity makeEntity(RequestAction requestAction) throws UnsupportedEncodingException {
        if (!Strings.isNullOrEmpty((String)requestAction.getRequestBody())) {
            ContentType contentType = null;
            for (HttpRequestNameValuePair header : requestAction.getHeaders()) {
                if (!"Content-type".equalsIgnoreCase(header.getName())) continue;
                contentType = ContentType.parse((String)header.getValue());
                break;
            }
            return new StringEntity(requestAction.getRequestBody(), contentType);
        }
        return HttpClientUtil.toUrlEncoded(requestAction.getParams());
    }

    private String getUrlWithParams(RequestAction requestAction) throws IOException {
        String url = requestAction.getUrl().toString();
        if (!requestAction.getParams().isEmpty()) {
            url = HttpClientUtil.appendParamsToUrl(url, requestAction.getParams());
        }
        return url;
    }

    private static UrlEncodedFormEntity toUrlEncoded(List<HttpRequestNameValuePair> params) throws UnsupportedEncodingException {
        return new UrlEncodedFormEntity(params);
    }

    public static String appendParamsToUrl(String url, List<HttpRequestNameValuePair> params) throws IOException {
        url = url + (url.contains("?") ? "&" : "?");
        url = url + HttpClientUtil.paramsToString(params);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String paramsToString(List<HttpRequestNameValuePair> params) throws IOException {
        StringBuilder sb = new StringBuilder();
        UrlEncodedFormEntity entity = HttpClientUtil.toUrlEncoded(params);
        try (BufferedReader br = null;){
            String s;
            br = new BufferedReader(new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8));
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
            String string = sb.toString();
            return string;
        }
    }

    public HttpResponse execute(HttpClient client, HttpContext context, HttpRequestBase method, PrintStream logger) throws IOException, InterruptedException {
        if (RestApiUtils.isIspwDebugMode()) {
            logger.println("Sending request to url: " + method.getURI());
        }
        HttpResponse httpResponse = client.execute((HttpUriRequest)method, context);
        if (RestApiUtils.isIspwDebugMode()) {
            logger.println("HTTP Response Code: " + httpResponse.getStatusLine());
        }
        return httpResponse;
    }
}

