/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.action;

import com.compuware.ispw.model.rest.TaskInfo;
import com.compuware.ispw.restapi.IspwContextPathBean;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.JsonProcessor;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.action.AbstractGetAction;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;

public class GetReleaseTaskInfoAction
extends AbstractGetAction {
    private static final String[] defaultProps = new String[]{"releaseId", "taskId"};
    private static final String contextPath = "/ispw/{srid}/releases/{releaseId}/tasks/{taskId}";

    public GetReleaseTaskInfoAction(PrintStream logger) {
        super(logger);
    }

    @Override
    public IspwRequestBean getIspwRequestBean(String srid, String ispwRequestBody, WebhookToken webhookToken) {
        List<String> pathTokens = Arrays.asList(defaultProps);
        return super.getIspwRequestBean(srid, ispwRequestBody, contextPath, pathTokens);
    }

    @Override
    public void startLog(PrintStream logger, IspwContextPathBean ispwContextPathBean, Object jsonObject) {
        logger.println("Getting task " + ispwContextPathBean.getTaskId() + " in Release " + ispwContextPathBean.getReleaseId());
    }

    @Override
    public Object endLog(PrintStream logger, IspwRequestBean ispwRequestBean, String responseJson) {
        TaskInfo taskInfo = new JsonProcessor().parse(responseJson, TaskInfo.class);
        logger.println("TaskId, Module, Type, UserId, Version, Status, Application/Stream/Level, Release");
        logger.println(" " + taskInfo.getTaskId() + ", " + taskInfo.getModuleName() + ", " + taskInfo.getModuleType() + ", " + taskInfo.getUserId() + ", " + taskInfo.getVersion() + ", " + taskInfo.getStatus() + ", " + taskInfo.getApplication() + "/" + taskInfo.getStream() + "/" + taskInfo.getLevel() + ", " + taskInfo.getRelease());
        return taskInfo;
    }
}

