/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi;

import com.compuware.ispw.git.GitToIspwUtils;
import com.compuware.ispw.model.changeset.ProgramList;
import com.compuware.ispw.model.rest.BuildResponse;
import com.compuware.ispw.model.rest.SetInfoResponse;
import com.compuware.ispw.model.rest.TaskInfo;
import com.compuware.ispw.model.rest.TaskListResponse;
import com.compuware.ispw.model.rest.TaskResponse;
import com.compuware.ispw.restapi.HttpMode;
import com.compuware.ispw.restapi.HttpRequestExecution;
import com.compuware.ispw.restapi.IspwContextPathBean;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.IspwRestApiRequest;
import com.compuware.ispw.restapi.JsonProcessor;
import com.compuware.ispw.restapi.MimeType;
import com.compuware.ispw.restapi.ResponseContentSupplier;
import com.compuware.ispw.restapi.ResponseHandle;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.WebhookTokenManager;
import com.compuware.ispw.restapi.action.GetSetInfoAction;
import com.compuware.ispw.restapi.action.IAction;
import com.compuware.ispw.restapi.action.SetInfoPostAction;
import com.compuware.ispw.restapi.util.HttpRequestNameValuePair;
import com.compuware.ispw.restapi.util.Operation;
import com.compuware.ispw.restapi.util.ReflectUtils;
import com.compuware.ispw.restapi.util.RestApiUtils;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.parboiled.common.FileUtils;

public final class IspwRestApiRequestStep
extends AbstractStepImpl {
    @Nonnull
    private String url = "";
    private boolean ignoreSslErrors = false;
    private HttpMode httpMode = DescriptorImpl.httpMode;
    private String httpProxy = "";
    private String validResponseCodes = "100:399";
    private String validResponseContent = "";
    private MimeType acceptType = DescriptorImpl.acceptType;
    private MimeType contentType = DescriptorImpl.contentType;
    private Integer timeout = 0;
    private String authentication = "";
    private String requestBody = "";
    private List<HttpRequestNameValuePair> customHeaders = DescriptorImpl.customHeaders;
    private String outputFile = "";
    private ResponseHandle responseHandle = DescriptorImpl.responseHandle;
    private String token = "";
    private String connectionId = "";
    private String credentialsId = "";
    private String ispwAction = "";
    private String ispwRequestBody = "#The following messages are commented out to show how to use the 'Request' field.\n#Click on the help button to the right of the screen for examples of how to populate this field based on 'Action' type\n#\n#For example, if you select GenerateTasksInAssignment for 'Action' field,\n# you may populate the following properties in 'Request' field.\n# The property value should be based on your own container ID and level.\n#\n#assignmentId=PLAY000313\n#level=STG2\n";
    private Boolean consoleLogResponseBody = DescriptorImpl.consoleLogResponseBody;
    private Boolean skipWaitingForSet = DescriptorImpl.skipWaitingForSet;

    @DataBoundConstructor
    public IspwRestApiRequestStep() {
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isIgnoreSslErrors() {
        return this.ignoreSslErrors;
    }

    public HttpMode getHttpMode() {
        return this.httpMode;
    }

    public String getIspwAction() {
        return this.ispwAction;
    }

    @DataBoundSetter
    public void setIspwAction(String ispwAction) {
        this.ispwAction = ispwAction;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    @DataBoundSetter
    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getIspwRequestBody() {
        return this.ispwRequestBody;
    }

    @DataBoundSetter
    public void setIspwRequestBody(String ispwRequestBody) {
        this.ispwRequestBody = ispwRequestBody;
    }

    public String getToken() {
        return this.token;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public String getValidResponseCodes() {
        return this.validResponseCodes;
    }

    public String getValidResponseContent() {
        return this.validResponseContent;
    }

    public MimeType getAcceptType() {
        return this.acceptType;
    }

    public MimeType getContentType() {
        return this.contentType;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Boolean getSkipWaitingForSet() {
        return this.skipWaitingForSet;
    }

    @DataBoundSetter
    public void setSkipWaitingForSet(Boolean skipWaitingForSet) {
        this.skipWaitingForSet = skipWaitingForSet;
    }

    @DataBoundSetter
    public void setConsoleLogResponseBody(Boolean consoleLogResponseBody) {
        this.consoleLogResponseBody = consoleLogResponseBody;
    }

    public Boolean getConsoleLogResponseBody() {
        return this.consoleLogResponseBody;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public List<HttpRequestNameValuePair> getCustomHeaders() {
        return this.customHeaders;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public ResponseHandle getResponseHandle() {
        return this.responseHandle;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    List<HttpRequestNameValuePair> resolveHeaders() {
        ArrayList<HttpRequestNameValuePair> headers = new ArrayList<HttpRequestNameValuePair>();
        headers.add(new HttpRequestNameValuePair("Content-type", MimeType.APPLICATION_JSON.toString()));
        headers.add(new HttpRequestNameValuePair("Authorization", this.getToken()));
        if (this.acceptType != null && this.acceptType != MimeType.NOT_SET) {
            headers.add(new HttpRequestNameValuePair("Accept", this.acceptType.getValue()));
        }
        for (HttpRequestNameValuePair header : this.customHeaders) {
            String headerName = header.getName();
            String headerValue = header.getValue();
            boolean maskValue = headerName.equalsIgnoreCase("Authorization") || header.getMaskValue();
            headers.add(new HttpRequestNameValuePair(headerName, headerValue, maskValue));
        }
        return headers;
    }

    public static final class Execution
    extends AbstractSynchronousNonBlockingStepExecution<ResponseContentSupplier> {
        @Inject
        private transient IspwRestApiRequestStep step;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient TaskListener listener;
        private static final long serialVersionUID = 1L;

        public ResponseContentSupplier runExec(HttpRequestExecution exec) throws InterruptedException, IOException {
            Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
            ResponseContentSupplier supplier = null;
            if (launcher != null) {
                VirtualChannel channel = launcher.getChannel();
                if (channel != null) {
                    supplier = (ResponseContentSupplier)channel.call((Callable)exec);
                }
            } else {
                supplier = exec.call();
            }
            return supplier;
        }

        protected ResponseContentSupplier run() throws Exception {
            ArrayList<String> variables;
            PrintStream logger = this.listener.getLogger();
            EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
            File buildDirectory = this.run.getRootDir();
            logger.println("buildDirectory: " + buildDirectory.getAbsolutePath());
            String buildTag = (String)envVars.get((Object)"BUILD_TAG");
            WebhookToken webhookToken = WebhookTokenManager.getInstance().get(buildTag);
            if (RestApiUtils.isIspwDebugMode()) {
                logger.println("...getting buildTag=" + buildTag + ", webhookToken=" + webhookToken);
            }
            IAction action = ReflectUtils.createAction(this.step.ispwAction, logger);
            this.step.httpMode = action.getHttpMode();
            if (!ReflectUtils.isActionInstantiated(action)) {
                String errorMsg = "Action:" + this.step.ispwAction + " is not implemented. Please make sure you have the correct ISPW action name.";
                logger.println(errorMsg);
                throw new IllegalStateException(new Exception(errorMsg));
            }
            if (RestApiUtils.isIspwDebugMode()) {
                logger.println("ispwAction=" + this.step.ispwAction + ", httpMode=" + (Object)((Object)this.step.httpMode));
            }
            String cesUrl = RestApiUtils.getCesUrl(this.step.connectionId, logger);
            String cesIspwHost = RestApiUtils.getIspwHostLabel(this.step.connectionId);
            String cesIspwToken = RestApiUtils.getCesToken(this.step.credentialsId, (Item)this.run.getParent());
            if (RestApiUtils.isIspwDebugMode()) {
                logger.println("...ces.url=" + cesUrl + ", ces.ispw.host=" + cesIspwHost + ", ces.ispw.token=" + cesIspwToken);
            }
            IspwRequestBean ispwRequestBean = null;
            FilePath buildParmPath = GitToIspwUtils.getFilePathInVirtualWorkspace(envVars, "automaticBuildParams.txt");
            String realIspwRequestBody = action.preprocess(this.step.ispwRequestBody, buildParmPath, logger);
            ispwRequestBean = action.getIspwRequestBean(cesIspwHost, realIspwRequestBody, webhookToken);
            if (ispwRequestBean == null) {
                logger.println("The " + this.step.ispwAction + " operation is skipped since the build parameters cannot be captured.");
                return null;
            }
            if (RestApiUtils.isIspwDebugMode()) {
                logger.println("ispwRequestBean=" + ispwRequestBean);
            }
            this.step.url = cesUrl + ispwRequestBean.getContextPath();
            this.step.requestBody = ispwRequestBean.getJsonRequest();
            this.step.token = cesIspwToken;
            if (Boolean.TRUE.equals(this.step.consoleLogResponseBody)) {
                logger.println();
                logger.println();
                logger.println("### [" + this.step.ispwAction + "] - " + "RFC 2616");
                logger.println();
                logger.println((Object)((Object)this.step.httpMode) + " " + this.step.url + " HTTP/1.1");
                logger.println("Content-type: " + MimeType.APPLICATION_JSON.getContentType().toString());
                logger.println("Authorization: " + RestApiUtils.maskToken(this.step.token));
                logger.println("");
                logger.println(this.step.requestBody);
                logger.println();
                logger.println("###");
                logger.println();
                logger.println();
            }
            if (!(variables = RestApiUtils.getVariables(this.step.url)).isEmpty()) {
                String errorMsg = "Action failed, need to define the following: " + variables;
                logger.println(errorMsg);
                throw new IllegalStateException(new Exception(errorMsg));
            }
            logger.println("Starting ISPW Operations Plugin");
            action.startLog(logger, ispwRequestBean.getIspwContextPathBean(), ispwRequestBean.getJsonObject());
            HttpRequestExecution exec = HttpRequestExecution.from(this.step, this.listener, this);
            ResponseContentSupplier supplier = this.runExec(exec);
            if (supplier == null) {
                String errorMsg = "Supplier is null. Please verify the pipeline script is structured correctly.";
                logger.println(errorMsg);
                throw new IllegalStateException(new Exception(errorMsg));
            }
            if (supplier.getAbortStatus() && !supplier.getAbortMessage().isEmpty()) {
                throw new AbortException(supplier.getAbortMessage());
            }
            String responseJson = supplier.getContent();
            if (RestApiUtils.isIspwDebugMode()) {
                logger.println("responseJson=" + responseJson);
            }
            Object respObject = action.endLog(logger, ispwRequestBean, responseJson);
            if (webhookToken != null) {
                SetInfoResponse setInfoResp;
                if (action instanceof GetSetInfoAction && respObject instanceof SetInfoResponse && StringUtils.isNotBlank((String)ispwRequestBean.getIspwContextPathBean().getLevel()) && !this.saveTttChangeSet(logger, envVars, setInfoResp = (SetInfoResponse)respObject) && this.run instanceof WorkflowRun) {
                    ProgramList programList = RestApiUtils.convertSetInfoResp(setInfoResp);
                    String tttJson = programList.toString();
                    WorkflowRun workflowRun = (WorkflowRun)this.run;
                    File rootDir = workflowRun.getRootDir();
                    File tttChangeSet = new File(rootDir, "../../changedPrograms.json");
                    if (tttChangeSet.exists()) {
                        logger.println("Deleting the old changed program list at " + tttChangeSet.getCanonicalPath());
                        boolean deleteSuccess = tttChangeSet.delete();
                        if (deleteSuccess) {
                            logger.println("delete successfully");
                        } else {
                            logger.println("failed to delete");
                        }
                    }
                    logger.println("Saving the changed program list to " + tttChangeSet.getCanonicalPath());
                    FileUtils.writeAllText((String)tttJson, (File)tttChangeSet);
                }
                return supplier;
            }
            if (Boolean.TRUE.equals(this.step.skipWaitingForSet)) {
                logger.println("Skip waiting for the completion of the set for this job...");
            }
            if (!this.step.skipWaitingForSet.booleanValue()) {
                String setId = "";
                if (respObject instanceof TaskResponse) {
                    TaskResponse taskResp = (TaskResponse)respObject;
                    setId = taskResp.getSetId();
                } else if (respObject instanceof BuildResponse) {
                    BuildResponse buildResp = (BuildResponse)respObject;
                    setId = buildResp.getSetId();
                }
                if (StringUtils.isNotBlank((String)setId) && (respObject instanceof TaskResponse || respObject instanceof BuildResponse)) {
                    int i;
                    HashSet<String> set = new HashSet<String>();
                    SetInfoResponse finalSetInfoResp = null;
                    boolean isSetHeld = false;
                    String setState = "Unknown";
                    for (i = 0; i < 60; ++i) {
                        Thread.sleep(2000L);
                        HttpRequestExecution poller = HttpRequestExecution.createPoller(setId, this.step, this.listener, this);
                        ResponseContentSupplier pollerSupplier = this.runExec(poller);
                        if (pollerSupplier == null) {
                            String errorMsg = "ResponseContentSupplier for polling is null. Please verify that the pipeline script is structured correctly.";
                            logger.println(errorMsg);
                            throw new IllegalStateException(new Exception(errorMsg));
                        }
                        JsonProcessor jsonProcessor = new JsonProcessor();
                        String pollingJson = pollerSupplier.getContent();
                        SetInfoResponse setInfoResp = jsonProcessor.parse(pollingJson, SetInfoResponse.class);
                        setState = StringUtils.trimToEmpty((String)setInfoResp.getState());
                        if (set.contains(setState)) continue;
                        logger.println("Set " + setInfoResp.getSetid() + " status - " + setState);
                        set.add(setState);
                        if (setState.equals("Closed") || setState.equals("Complete")) {
                            logger.println("ISPW: Action " + this.step.ispwAction + " completed");
                            IspwContextPathBean ispwContextPathBean = ispwRequestBean.getIspwContextPathBean();
                            if (ispwContextPathBean == null || !StringUtils.isNotBlank((String)ispwContextPathBean.getLevel())) break;
                            String taskLevel = ispwContextPathBean.getLevel();
                            HttpRequestExecution poller1 = HttpRequestExecution.createPoller(setId, taskLevel, this.step, this.listener, this);
                            ResponseContentSupplier pollerSupplier1 = this.runExec(poller1);
                            if (pollerSupplier1 == null) {
                                String errorMsg = "ResponseContentSupplier for TTT file information is null. Please verify that the pipeline script is structured correctly.";
                                logger.println(errorMsg);
                                throw new IllegalStateException(new Exception(errorMsg));
                            }
                            JsonProcessor jsonProcessor1 = new JsonProcessor();
                            String pollingJson1 = pollerSupplier1.getContent();
                            finalSetInfoResp = jsonProcessor1.parse(pollingJson1, SetInfoResponse.class);
                            if (finalSetInfoResp != null && finalSetInfoResp.getTasks() != null) {
                                StringBuilder taskNames = new StringBuilder();
                                finalSetInfoResp.getTasks().forEach(task -> taskNames.append(task.getModuleName() + ", "));
                                logger.println("ISPW tasks: " + taskNames.substring(0, taskNames.lastIndexOf(",")));
                            }
                            this.saveTttChangeSet(logger, envVars, finalSetInfoResp);
                            break;
                        }
                        if ("Failed".equalsIgnoreCase(setState)) {
                            String actionName = ispwRequestBean.getIspwContextPathBean().getAction();
                            if (StringUtils.isBlank((String)actionName)) {
                                actionName = action.getClass().getName();
                            }
                            if (!StringUtils.isNotBlank((String)actionName)) break;
                            logger.println(String.format("ISPW: Set " + setId + " - action [%s] failed", actionName));
                            break;
                        }
                        if ("Terminated".equalsIgnoreCase(setState) && "terminate".equalsIgnoreCase(ispwRequestBean.getIspwContextPathBean().getAction())) {
                            logger.println("ISPW: Set " + setId + " - successfully terminated");
                            break;
                        }
                        if ("Held".equalsIgnoreCase(setState) && "hold".equalsIgnoreCase(ispwRequestBean.getIspwContextPathBean().getAction())) {
                            logger.println("ISPW: Set " + setId + " - successfully held");
                            isSetHeld = true;
                            break;
                        }
                        if ("Held".equalsIgnoreCase(setState) && "unlock".equalsIgnoreCase(ispwRequestBean.getIspwContextPathBean().getAction())) {
                            logger.println("ISPW: Set " + setId + " - successfully unlocked.  Set is currently held.");
                            break;
                        }
                        if (!"Released".equalsIgnoreCase(setState) && !"Waiting-Lock".equalsIgnoreCase(setState) || !"release".equalsIgnoreCase(ispwRequestBean.getIspwContextPathBean().getAction())) continue;
                        logger.println("ISPW: Set " + setId + " - successfully released");
                        break;
                    }
                    if (i == 120) {
                        logger.println("Warn - max timeout reached");
                        return supplier;
                    }
                    if (!isSetHeld) {
                        if (respObject instanceof BuildResponse) {
                            this.buildActionTaskInfoLogger(setId, setState, logger, respObject);
                        } else if (finalSetInfoResp != null) {
                            this.logActionResults(finalSetInfoResp, action, logger);
                        }
                    }
                }
            }
            return supplier;
        }

        private boolean saveTttChangeSet(PrintStream logger, EnvVars envVars, SetInfoResponse setInfoResp) {
            ProgramList programList = RestApiUtils.convertSetInfoResp(setInfoResp);
            String tttJson = programList.toString();
            if (Boolean.TRUE.equals(this.step.consoleLogResponseBody)) {
                logger.println("tttJson=" + tttJson);
            }
            FilePath tttChangeSet = GitToIspwUtils.getFilePathInVirtualWorkspace(envVars, "changedPrograms.json");
            try {
                if (tttChangeSet != null) {
                    if (tttChangeSet.exists()) {
                        logger.println("Deleting the old changed program list at " + tttChangeSet.getRemote());
                        tttChangeSet.delete();
                    }
                    logger.println("Saving the changed program list to " + tttChangeSet.getRemote());
                    tttChangeSet.write(tttJson, "UTF-8");
                    return true;
                }
                return false;
            }
            catch (Exception x) {
                x.printStackTrace();
                return false;
            }
        }

        private void buildActionTaskInfoLogger(String setId, String setState, PrintStream logger, Object respObject) throws InterruptedException, IOException, RuntimeException {
            if (setState.equals("Closed") || setState.equals("Complete")) {
                List<TaskInfo> tasksBuilt;
                Thread.sleep(2000L);
                HttpRequestExecution poller = HttpRequestExecution.createTaskInfoPoller(setId, this.step, this.listener, this);
                ResponseContentSupplier pollerSupplier = this.runExec(poller);
                String pollingJson = pollerSupplier.getContent();
                JsonProcessor jsonProcessor = new JsonProcessor();
                TaskListResponse taskListResp = jsonProcessor.parse(pollingJson, TaskListResponse.class);
                BuildResponse buildResponse = (BuildResponse)respObject;
                if (buildResponse.getTasksBuilt().size() == 1) {
                    logger.println("ISPW: Set " + setId + " - " + buildResponse.getTasksBuilt().size() + " task will be built");
                } else {
                    logger.println("ISPW: Set " + setId + " - " + buildResponse.getTasksBuilt().size() + " tasks will be built");
                }
                List<TaskInfo> tasksNotBuilt = tasksBuilt = buildResponse.getTasksBuilt();
                List<TaskInfo> tasksInSet = taskListResp.getTasks();
                int numTasksToBeBuilt = tasksBuilt.size();
                HashSet<String> uniqueTasksInSet = new HashSet<String>();
                if (!tasksInSet.isEmpty()) {
                    for (TaskInfo task : tasksInSet) {
                        if (task.getOperation().startsWith("G")) {
                            logger.println("ISPW: Set " + setId + " - " + task.getModuleName() + " generated successfully");
                        }
                        uniqueTasksInSet.add(task.getTaskId());
                        tasksNotBuilt.removeIf(x -> x.getTaskId().equals(task.getTaskId()));
                    }
                    for (TaskInfo task : tasksNotBuilt) {
                        logger.println("ISPW: Set " + setId + " - " + task.getModuleName() + " did not generate successfully");
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("ISPW: " + uniqueTasksInSet.size() + " of " + numTasksToBeBuilt + " generated successfully. " + tasksNotBuilt.size() + " of " + numTasksToBeBuilt + " generated with errors.\n");
                    if (!tasksNotBuilt.isEmpty()) {
                        logger.println(sb);
                        logger.println("ISPW: The build process completed with generate errors.");
                        throw new AbortException("ISPW: Set processing has not generated successfully.");
                    }
                    logger.println(sb);
                }
            } else {
                throw new AbortException("ISPW: Set processing has not completed successfully. Set status is " + setState + ".");
            }
            logger.println("ISPW: The build process completed.");
        }

        private void logActionResults(SetInfoResponse finalSetInfoResp, IAction action, PrintStream logger) throws AbortException {
            if (action instanceof SetInfoPostAction) {
                String setState;
                SetInfoPostAction setAction = (SetInfoPostAction)action;
                Operation operation = setAction.getIspwOperation();
                List<TaskInfo> tasksInSet = finalSetInfoResp.getTasks();
                if (tasksInSet != null) {
                    for (TaskInfo task : tasksInSet) {
                        if (!task.getOperation().startsWith(operation.getCode())) continue;
                        logger.println("ISPW: " + task.getModuleName() + " " + operation.getPastTenseDescription() + " successfully");
                    }
                }
                if ((setState = StringUtils.trimToEmpty((String)finalSetInfoResp.getState())).equals("Closed") || setState.equals("Complete") || setState.equals("Waiting-Approval")) {
                    logger.println("ISPW: The " + this.step.getIspwAction() + " process completed.");
                } else {
                    throw new AbortException("ISPW: Set processing has not completed successfully. Set status is " + setState + ".");
                }
            }
        }

        FilePath resolveOutputFile() {
            String outputFile = this.step.getOutputFile();
            if (outputFile == null || outputFile.trim().isEmpty()) {
                return null;
            }
            try {
                FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
                if (workspace == null) {
                    throw new IllegalStateException("Could not find workspace to save file outputFile: " + outputFile + ". You should use it inside a 'node' block");
                }
                return workspace.child(outputFile);
            }
            catch (IOException | InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        public Item getProject() {
            return this.run.getParent();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public static final boolean ignoreSslErrors = false;
        public static final HttpMode httpMode = IspwRestApiRequest.DescriptorImpl.httpMode;
        public static final String httpProxy = "";
        public static final String validResponseCodes = "100:399";
        public static final String validResponseContent = "";
        public static final MimeType acceptType = IspwRestApiRequest.DescriptorImpl.acceptType;
        public static final MimeType contentType = IspwRestApiRequest.DescriptorImpl.contentType;
        public static final int timeout = 0;
        public static final Boolean quiet = IspwRestApiRequest.DescriptorImpl.quiet;
        public static final String authentication = "";
        public static final String requestBody = "";
        public static final String token = "";
        public static final List<HttpRequestNameValuePair> customHeaders = Collections.emptyList();
        public static final String outputFile = "";
        public static final ResponseHandle responseHandle = ResponseHandle.STRING;
        public static final String connectionId = "";
        public static final String credentialsId = "";
        public static final String ispwAction = "";
        public static final String ispwRequestBody = "#The following messages are commented out to show how to use the 'Request' field.\n#Click on the help button to the right of the screen for examples of how to populate this field based on 'Action' type\n#\n#For example, if you select GenerateTasksInAssignment for 'Action' field,\n# you may populate the following properties in 'Request' field.\n# The property value should be based on your own container ID and level.\n#\n#assignmentId=PLAY000313\n#level=STG2\n";
        public static final Boolean consoleLogResponseBody = IspwRestApiRequest.DescriptorImpl.consoleLogResponseBody;
        public static final Boolean skipWaitingForSet = false;

        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "ispwOperation";
        }

        public String getDisplayName() {
            return "Perform a Compuware ISPW Rest API Request and return a JSON object";
        }

        public ListBoxModel doFillIspwActionItems(@AncestorInPath Jenkins context, @QueryParameter String ispwAction, @AncestorInPath Item project) {
            return RestApiUtils.buildIspwActionItems(context, ispwAction, project);
        }

        public ListBoxModel doFillConnectionIdItems(@AncestorInPath Jenkins context, @QueryParameter String connectionId, @AncestorInPath Item project) {
            return RestApiUtils.buildConnectionIdItems(context, connectionId, project);
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Jenkins context, @QueryParameter String credentialsId, @AncestorInPath Item project) {
            return RestApiUtils.buildCredentialsIdItems(context, credentialsId, project);
        }

        public ListBoxModel doFillHttpModeItems() {
            return HttpMode.getFillItems();
        }

        public ListBoxModel doFillAcceptTypeItems() {
            return MimeType.getContentTypeFillItems();
        }

        public ListBoxModel doFillContentTypeItems() {
            return MimeType.getContentTypeFillItems();
        }

        public ListBoxModel doFillResponseHandleItems() {
            ListBoxModel items = new ListBoxModel();
            for (ResponseHandle responseHandle : ResponseHandle.values()) {
                items.add(responseHandle.name());
            }
            return items;
        }

        public ListBoxModel doFillAuthenticationItems(@AncestorInPath Item project, @QueryParameter String url) {
            return IspwRestApiRequest.DescriptorImpl.fillAuthenticationItems(project, url);
        }

        public FormValidation doCheckValidResponseCodes(@QueryParameter String value) {
            return IspwRestApiRequest.DescriptorImpl.checkValidResponseCodes(value);
        }
    }
}

