/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.git;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.compuware.ispw.git.CliExecutor;
import com.compuware.ispw.git.CustomGitChangeSetList;
import com.compuware.ispw.git.IGitToIspwPublish;
import com.compuware.ispw.git.RefMap;
import com.compuware.ispw.git.RemoteSystemProperties;
import com.compuware.ispw.restapi.util.RestApiUtils;
import com.compuware.jenkins.common.configuration.CpwrGlobalConfiguration;
import com.google.common.collect.Iterables;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildData;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;

public class GitToIspwUtils {
    public static ListBoxModel buildStandardCredentialsIdItems(@AncestorInPath Jenkins context, @QueryParameter String credentialsId, @AncestorInPath Item project) {
        List creds = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, Collections.emptyList());
        StandardListBoxModel model = new StandardListBoxModel();
        model.add((Object)new ListBoxModel.Option("", "", false));
        for (StandardUsernamePasswordCredentials c : creds) {
            boolean isSelected = false;
            if (credentialsId != null) {
                isSelected = credentialsId.matches(c.getId());
            }
            String description = Util.fixEmptyAndTrim((String)c.getDescription());
            model.add((Object)new ListBoxModel.Option(c.getUsername() + (description != null ? " (" + description + ")" : ""), c.getId(), isSelected));
        }
        return model;
    }

    public static ListBoxModel buildContainerPrefItems(@AncestorInPath Jenkins context, @QueryParameter String containerPref, @AncestorInPath Item project) {
        ListBoxModel model = new ListBoxModel();
        model.add((Object)new ListBoxModel.Option("per-commit", "per-commit"));
        model.add((Object)new ListBoxModel.Option("per-branch", "per-branch"));
        model.add((Object)new ListBoxModel.Option("custom", "custom"));
        return model;
    }

    public static Map<String, RefMap> parse(String branchMapping) {
        String[] lines;
        HashMap<String, RefMap> map = new HashMap<String, RefMap>();
        for (String line : lines = branchMapping.split("\n")) {
            int indexOfArrow;
            if ((line = StringUtils.trimToEmpty((String)line)).startsWith("#") || (indexOfArrow = line.indexOf("=>")) == -1) continue;
            String pattern = StringUtils.trimToEmpty((String)line.substring(0, indexOfArrow));
            String ispwLevel = "";
            String containerPref = "per-commit";
            String containerDesc = "";
            String rest = line.substring(indexOfArrow + 2);
            StringTokenizer tokenizer = new StringTokenizer(rest, ",");
            if (tokenizer.hasMoreTokens()) {
                ispwLevel = StringUtils.trimToEmpty((String)tokenizer.nextToken());
            }
            if (tokenizer.hasMoreElements()) {
                containerPref = StringUtils.trimToEmpty((String)tokenizer.nextToken());
            }
            if (tokenizer.hasMoreElements()) {
                containerDesc = StringUtils.trimToEmpty((String)tokenizer.nextToken());
            }
            RefMap refMap = new RefMap(ispwLevel, containerPref, containerDesc);
            map.put(pattern, refMap);
        }
        return map;
    }

    public static void trimEnvironmentVariables(EnvVars envVars) {
        String toHash = envVars.get("toHash", null);
        String fromHash = envVars.get("fromHash", null);
        String ref = envVars.get("ref", null);
        String refId = envVars.get("refId", null);
        envVars.put("toHash", StringUtils.trimToEmpty((String)toHash));
        envVars.put("fromHash", StringUtils.trimToEmpty((String)fromHash));
        envVars.put("ref", StringUtils.trimToEmpty((String)ref));
        envVars.put("refId", StringUtils.trimToEmpty((String)refId));
    }

    public static FilePath getFilePathInVirtualWorkspace(EnvVars envVars, String fileName) {
        FilePath filePath;
        block6: {
            filePath = null;
            try {
                String workspacePath = (String)envVars.get((Object)"WORKSPACE");
                if (workspacePath == null) {
                    return null;
                }
                String nodeName = (String)envVars.get((Object)"NODE_NAME");
                if (nodeName.contentEquals("master")) {
                    FilePath wsPath = new FilePath(new File(workspacePath));
                    filePath = new FilePath(wsPath, fileName);
                    break block6;
                }
                Jenkins jenkins = Jenkins.getInstanceOrNull();
                if (jenkins == null) {
                    throw new AbortException("The Jenkins instance " + nodeName + " has not been started or was already shut down.");
                }
                Computer computer = jenkins.getComputer(nodeName);
                if (computer != null) {
                    FilePath wsPath = new FilePath(computer.getChannel(), workspacePath);
                    filePath = new FilePath(wsPath, fileName);
                    break block6;
                }
                throw new AbortException("Unable to access the Jenkins instance " + nodeName);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        return filePath;
    }

    public static boolean callCli(Launcher launcher, Run<?, ?> build, PrintStream logger, EnvVars envVars, RefMap refMap, IGitToIspwPublish publishStep) throws InterruptedException, IOException {
        CpwrGlobalConfiguration globalConfig = CpwrGlobalConfiguration.get();
        RestApiUtils.assertNotNull(logger, globalConfig, "Jenkins:launcher cannot be null");
        VirtualChannel vChannel = launcher.getChannel();
        RestApiUtils.assertNotNull(logger, vChannel, "Jenkins:vChannel cannot be null");
        String toHash = envVars.get("toHash", null);
        String fromHash = envVars.get("fromHash", null);
        String ref = envVars.get("ref", null);
        String refId = envVars.get("refId", null);
        if (RestApiUtils.isIspwDebugMode()) {
            logger.println(String.format("toHash=%s, fromHash=%s, ref=%s, refId=%s", toHash, fromHash, ref, refId));
        }
        RestApiUtils.assertNotNull(logger, refMap, "refMap is null. Failed to mapping refId: %s to refMap. Please refine your branch mapping to match the branch name or ID in order to find correct refId.", refId);
        logger.println("Matched on the following mapping: " + refMap.toString());
        Properties remoteProperties = (Properties)vChannel.call((Callable)new RemoteSystemProperties());
        String remoteFileSeparator = remoteProperties.getProperty("file.separator");
        String workspacePath = (String)envVars.get((Object)"WORKSPACE");
        String topazCliWorkspace = workspacePath + remoteFileSeparator + "TopazCliWkspc";
        logger.println("TopazCliWorkspace: " + topazCliWorkspace);
        String osFile = launcher.isUnix() ? "IspwCLI.sh" : "IspwCLI.bat";
        String cliScriptFile = globalConfig.getTopazCLILocation(launcher) + remoteFileSeparator + osFile;
        logger.println("CLI Script File: " + cliScriptFile);
        String cliScriptFileRemote = new FilePath(vChannel, cliScriptFile).getRemote();
        logger.println("CLI Script File Remote: " + cliScriptFileRemote);
        FilePath workDir = new FilePath(vChannel, build.getRootDir().toString());
        workDir.mkdirs();
        if (RestApiUtils.isIspwDebugMode()) {
            String buildTag = (String)envVars.get((Object)"BUILD_TAG");
            logger.println("Getting buildTag =" + buildTag);
        }
        boolean success = true;
        CliExecutor cliExecutor = new CliExecutor(logger, build, launcher, envVars, workspacePath, topazCliWorkspace, globalConfig, cliScriptFileRemote, workDir);
        try {
            String ispwLevel = "";
            String containerDesc = "";
            String containerPref = "";
            ispwLevel = refMap.getIspwLevel();
            containerDesc = refMap.getContainerDesc();
            containerPref = refMap.getContainerPref();
            success = cliExecutor.execute(publishStep.getConnectionId(), publishStep.getCredentialsId(), publishStep.getRuntimeConfig(), publishStep.getStream(), publishStep.getApp(), ispwLevel, containerPref, containerDesc, publishStep.getGitRepoUrl(), publishStep.getGitCredentialsId(), ref, refId, fromHash, toHash, publishStep.getIspwConfigPath());
        }
        catch (AbortException e) {
            logger.println(e.getMessage());
            if (RestApiUtils.isIspwDebugMode()) {
                e.printStackTrace(logger);
            }
            success = false;
        }
        if (!success) {
            if (fromHash.trim().isEmpty() || toHash.trim().contentEquals("-2")) {
                logger.println("Failure: Synchronization failed.");
            } else if (fromHash.contentEquals("-1")) {
                logger.println("Failure: Synchronization for " + toHash.trim().replaceAll(":", ", "));
            } else {
                logger.println("Failure: Synchronization for push ending with commit " + toHash.trim());
            }
        }
        return success;
    }

    public static List<? extends ChangeLogSet<? extends ChangeLogSet.Entry>> getChangeSets(Run<?, ?> run, PrintStream logger) {
        if (run instanceof AbstractBuild) {
            return Collections.singletonList(((AbstractBuild)run).getChangeSet());
        }
        if (run instanceof WorkflowRun) {
            return ((WorkflowRun)run).getChangeSets();
        }
        return null;
    }

    public static boolean isSameRevisionUsedbyLastBuild(WorkflowRun run, GitSCM gitSCM, PrintStream logger) {
        boolean result = true;
        Revision curRevision = GitToIspwUtils.getRevision(run, gitSCM);
        WorkflowRun prevBuild = run.getPreviousBuild();
        if (prevBuild != null) {
            Revision preBuildRevision = GitToIspwUtils.getRevision(prevBuild, gitSCM);
            if (curRevision != null && preBuildRevision != null) {
                boolean bl = result = GitToIspwUtils.isSameRevision(curRevision, preBuildRevision) && !prevBuild.isBuilding();
                if (RestApiUtils.isIspwDebugMode()) {
                    Branch branch = (Branch)Iterables.getFirst((Iterable)curRevision.getBranches(), null);
                    if (result) {
                        logger.println("The same revision " + curRevision.getSha1String() + " for branch " + branch.getName() + " is used for computing the changelog for the Git source ");
                    }
                }
            }
        }
        return result;
    }

    public static boolean isSameRevision(Revision firstRevision, Revision secondBuildRevision) {
        return firstRevision != null && secondBuildRevision != null && firstRevision.getBranches() != null && secondBuildRevision.getBranches() != null && firstRevision.getSha1String() != null && firstRevision.getSha1String().equals(secondBuildRevision.getSha1String());
    }

    public static Revision getRevision(WorkflowRun run, GitSCM gitSCM) {
        BuildData buildData = gitSCM.getBuildData((Run)run);
        if (buildData != null) {
            return buildData.getLastBuiltRevision();
        }
        return null;
    }

    public static boolean isReCalculateChangesRequired(WorkflowRun run, TaskListener listener) {
        SCM thescm;
        WorkflowJob job;
        Collection scms;
        return run != null && (scms = (job = (WorkflowJob)run.getParent()).getSCMs()) != null && !scms.isEmpty() && (thescm = (SCM)scms.iterator().next()) instanceof GitSCM && GitToIspwUtils.isSameRevisionUsedbyLastBuild(run, (GitSCM)thescm, listener.getLogger());
    }

    public static List<CustomGitChangeSetList> calculateGitSCMChanges(Run<?, ?> run, FilePath workspace, TaskListener listener, EnvVars envVars) {
        ArrayList<CustomGitChangeSetList> listChangeLogSet;
        block10: {
            SCM thescm;
            Collection scms;
            WorkflowRun curRun;
            WorkflowJob job;
            CustomGitChangeSetList customGitChangeSetList = null;
            listChangeLogSet = new ArrayList<CustomGitChangeSetList>();
            PrintStream logger = listener.getLogger();
            if (run != null && (job = (WorkflowJob)(curRun = (WorkflowRun)run).getParent()) != null && (scms = job.getSCMs()) != null && scms.size() >= 1 && (thescm = (SCM)scms.iterator().next()) instanceof GitSCM) {
                GitSCM gitScm = (GitSCM)thescm;
                if (RestApiUtils.isIspwDebugMode()) {
                    logger.println("Retrieve the GitSCM object " + gitScm.getScmName());
                }
                WorkflowRun theRun = curRun;
                WorkflowRun preRun = theRun.getPreviousBuild();
                Revision revision = GitToIspwUtils.getRevision(theRun, gitScm);
                Revision preRevision = null;
                if (preRun != null) {
                    preRevision = GitToIspwUtils.getRevision(preRun, gitScm);
                    while (GitToIspwUtils.isSameRevision(revision, preRevision) && !preRun.isBuilding() && (preRun = (theRun = preRun).getPreviousBuild()) != null) {
                        revision = GitToIspwUtils.getRevision(theRun, gitScm);
                        preRevision = GitToIspwUtils.getRevision(preRun, gitScm);
                    }
                }
                if (preRun == null) {
                    logger.println("Skipping changelog. There is no proper revision for computing the changelog.");
                    return listChangeLogSet;
                }
                logger.println("Compute the changelog between [ " + revision.toString() + "] and [" + preRevision.toString() + "].");
                try {
                    GitClient git = gitScm.createClient(listener, envVars, run, workspace);
                    StringWriter sw = new StringWriter();
                    git.changelog(preRevision.getSha1String(), revision.getSha1String(), (Writer)sw);
                    String logString = sw.toString();
                    if (logString.trim().length() > 0) {
                        if (RestApiUtils.isIspwDebugMode()) {
                            logger.println("Calculated changed log = \n " + logString);
                        }
                        String[] lines = logString.split("\\r?\\n");
                        if (RestApiUtils.isIspwDebugMode()) {
                            logger.println("The changed log array length is " + lines.length);
                        }
                        logger.println("Start to parse the changelog.");
                        GitChangeLogParser logparser = (GitChangeLogParser)gitScm.createChangeLogParser();
                        ArrayList<String> logs = new ArrayList<String>(Arrays.asList(lines));
                        customGitChangeSetList = new CustomGitChangeSetList(run, null, logparser.parse(logs));
                        listChangeLogSet.add(customGitChangeSetList);
                    }
                }
                catch (Exception x) {
                    logger.println("Failed to calculate the changelog.");
                    if (!RestApiUtils.isIspwDebugMode()) break block10;
                    x.printStackTrace(logger);
                }
            }
        }
        return listChangeLogSet;
    }

    public static String escapeArgument(String args) {
        HashMap<String, String> charactersToReplace = new HashMap<String, String>();
        String escapedArg = args;
        charactersToReplace.put("%", "%%");
        for (Map.Entry pair : charactersToReplace.entrySet()) {
            escapedArg = args.replaceAll((String)pair.getKey(), (String)pair.getValue());
        }
        return escapedArg;
    }
}

