/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.git;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.compuware.ispw.git.GitToIspwUtils;
import com.compuware.ispw.restapi.util.RestApiUtils;
import com.compuware.jenkins.common.configuration.CpwrGlobalConfiguration;
import com.compuware.jenkins.common.configuration.HostConnection;
import com.compuware.jenkins.common.utils.ArgumentUtils;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CliExecutor {
    private PrintStream logger;
    private Run<?, ?> run;
    private EnvVars envVars;
    private Launcher launcher;
    private CpwrGlobalConfiguration globalConfig;
    private String targetFolder;
    private String topazCliWorkspace;
    private String gitLocalPath;
    private String cliScriptFileRemote;
    private FilePath workDir;
    private static int COMMAND_LINE_LIMITATION = 2048;

    public CliExecutor(PrintStream logger, Run<?, ?> run, Launcher launcher, EnvVars envVars, String gitLocalPath, String topazCliWorkspace, CpwrGlobalConfiguration globalConfig, String cliScriptFileRemote, FilePath workDir) {
        this.logger = logger;
        this.run = run;
        this.envVars = envVars;
        this.launcher = launcher;
        this.targetFolder = gitLocalPath;
        this.globalConfig = globalConfig;
        this.gitLocalPath = gitLocalPath;
        this.topazCliWorkspace = topazCliWorkspace;
        this.cliScriptFileRemote = cliScriptFileRemote;
        this.workDir = workDir;
    }

    public boolean execute(String connectionId, String credentialsId, String runtimeConfig, String stream, String app, String ispwLevel, String containerPref, String containerDesc, String gitRepoUrl, String gitCredentialsId, String ref, String refId, String fromHash, String toHash, String ispwConfigPath) throws InterruptedException, IOException {
        String osFile;
        FilePath jenkinsWorkSpace;
        StandardUsernamePasswordCredentials gitCredentials;
        String gitUserId = "";
        String gitPassword = "";
        String userId = "";
        String password = "";
        HostConnection connection = this.globalConfig.getHostConnection(connectionId);
        RestApiUtils.assertNotNull(this.logger, connection, "Unable to connect to host connection for connectionId: %s", connectionId);
        String host = ArgumentUtils.escapeForScript((String)connection.getHost());
        String port = ArgumentUtils.escapeForScript((String)connection.getPort());
        this.logger.println(String.format("Using host connection: %s:%s", host, port));
        String protocol = connection.getProtocol();
        String codePage = connection.getCodePage();
        String timeout = ArgumentUtils.escapeForScript((String)connection.getTimeout());
        StandardUsernamePasswordCredentials credentials = this.globalConfig.getLoginInformation((Item)this.run.getParent(), credentialsId);
        RestApiUtils.assertNotNull(this.logger, credentials, "The host credentials were not able to be obtained.");
        userId = ArgumentUtils.escapeForScript((String)credentials.getUsername());
        password = ArgumentUtils.escapeForScript((String)credentials.getPassword().getPlainText());
        if (RestApiUtils.isIspwDebugMode()) {
            this.logger.println("host=" + host + ", port=" + port + ", protocol=" + protocol + ", codePage=" + codePage + ", timeout=" + timeout + ", userId=" + userId + ", password=" + password + ", containerPref=" + containerPref + ", containerDesc=" + containerDesc);
        }
        if ((gitCredentials = this.globalConfig.getLoginInformation((Item)this.run.getParent(), gitCredentialsId)) != null) {
            gitUserId = ArgumentUtils.escapeForScript((String)gitCredentials.getUsername());
            gitPassword = ArgumentUtils.escapeForScript((String)gitCredentials.getPassword().getPlainText());
            if (RestApiUtils.isIspwDebugMode()) {
                this.logger.println("gitRepoUrl=" + gitRepoUrl + ", gitUserId=" + gitUserId + ", gitPassword=" + gitPassword);
            }
        } else {
            this.logger.println("The git credentials were not able to be obtained.");
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(this.cliScriptFileRemote);
        args.add(new String[]{"-operation", "syncGitToIspw"});
        args.add(new String[]{"-host", host});
        args.add(new String[]{"-port", port});
        args.add(new String[]{"-id", userId});
        args.add("-pass");
        args.add(password, true);
        if (StringUtils.isNotBlank((String)protocol)) {
            args.add(new String[]{"-protocol", protocol});
        }
        args.add(new String[]{"-code", codePage});
        args.add(new String[]{"-timeout", timeout});
        args.add(new String[]{"-targetFolder", this.targetFolder});
        args.add(new String[]{"-data", this.topazCliWorkspace});
        if (StringUtils.isNotBlank((String)runtimeConfig)) {
            args.add(new String[]{"-ispwServerConfig", runtimeConfig});
        }
        args.add(new String[]{"-ispwServerStream", stream});
        args.add(new String[]{"-ispwServerApp", app});
        args.add(new String[]{"-ispwCheckoutLevel", ispwLevel});
        if (StringUtils.isNotBlank((String)ispwConfigPath)) {
            args.add(new String[]{"-ispwConfigPath", StringUtils.trimToEmpty((String)ispwConfigPath)});
        }
        if (StringUtils.isNotBlank((String)containerPref)) {
            args.add(new String[]{"-ispwContainerCreation", StringUtils.trimToEmpty((String)containerPref)});
        }
        if (StringUtils.isNotBlank((String)containerDesc)) {
            args.add(new String[]{"-ispwContainerDescription", StringUtils.trimToEmpty((String)containerDesc)});
        }
        args.add(new String[]{"-gitUsername", gitUserId});
        args.add("-gitPassword");
        args.add(gitPassword, true);
        gitRepoUrl = GitToIspwUtils.escapeArgument(gitRepoUrl);
        args.add(new String[]{"-gitRepoUrl", ArgumentUtils.escapeForScript((String)gitRepoUrl)});
        args.add(new String[]{"-gitBranch", ref});
        args.add(new String[]{"-gitFromHash", fromHash});
        args.add(new String[]{"-gitLocalPath", this.gitLocalPath});
        boolean useHashFile = false;
        if ("-1".equals(fromHash)) {
            ArgumentListBuilder argClone = args.clone();
            argClone.add(new String[]{"-gitCommit", toHash});
            String sCmd = argClone.toString();
            if (sCmd.length() > COMMAND_LINE_LIMITATION) {
                this.logger.println("The calculated list of changed programs is too long. Topaz CLI release 20.04.01 is the minimum release required for supporting a long command line used by Git to ISPW integration.");
                useHashFile = true;
            }
        }
        if (!(jenkinsWorkSpace = new FilePath(this.launcher.getChannel(), this.targetFolder)).exists()) {
            jenkinsWorkSpace.mkdirs();
        }
        FilePath toHashTempFile = null;
        if (useHashFile) {
            toHashTempFile = jenkinsWorkSpace.createTempFile("toHash", ".txt");
            if (toHashTempFile.exists()) {
                toHashTempFile.delete();
            }
            toHashTempFile = jenkinsWorkSpace.createTextTempFile("toHash", ".txt", toHash);
            args.add(new String[]{"-gitCommitFile", toHashTempFile.getRemote()});
        } else {
            if (!toHash.contains(" ")) {
                toHash = "\"" + toHash + "\"";
            }
            args.add(new String[]{"-gitCommit", toHash});
        }
        this.workDir.mkdirs();
        this.logger.println("Shell script: " + args.toString());
        int exitValue = this.launcher.launch().cmds(args).envs((Map)this.envVars).stdout((OutputStream)this.logger).pwd(this.workDir).join();
        String string = osFile = this.launcher.isUnix() ? "IspwCLI.sh" : "IspwCLI.bat";
        if (useHashFile && toHashTempFile != null && toHashTempFile.exists() && !RestApiUtils.isIspwDebugMode()) {
            toHashTempFile.delete();
        }
        if (exitValue != 0) {
            throw new AbortException("Call " + osFile + " exited with value = " + exitValue);
        }
        this.logger.println("Call " + osFile + " exited with value = " + exitValue);
        return true;
    }
}

