/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.jenkins.common.utils;

import com.compuware.jenkins.common.configuration.Messages;
import hudson.AbortException;
import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CLIVersionUtils {
    public static final String HOST_CONNECTION_PROTOCOL_MINIMUM_VERSION = "19.4.1";

    private CLIVersionUtils() {
    }

    public static String getCLIVersion(FilePath cliDirectory, String minimumVersion) throws IOException, InterruptedException {
        String version = "";
        if (!cliDirectory.exists()) {
            throw new AbortException(Messages.cliNotInstalledError());
        }
        FilePath versionFilePath = cliDirectory.child(cliDirectory.getRemote() + "/" + "version.xml");
        if (!versionFilePath.exists()) {
            throw new AbortException(Messages.cliOldUnknownVersionError(minimumVersion));
        }
        version = CLIVersionUtils.parseXml(versionFilePath.read());
        return version;
    }

    public static void checkCLICompatibility(String version, String minimumVersion) throws IOException, InterruptedException {
        if (StringUtils.isEmpty((String)version)) {
            throw new AbortException(Messages.cliOldUnknownVersionError(minimumVersion));
        }
        if (CLIVersionUtils.compareVersions(version, minimumVersion) < 0) {
            throw new AbortException(Messages.cliOldVersionError(version, minimumVersion));
        }
    }

    public static void checkCLICompatibility(FilePath cliDirectory, String minimumVersion) throws IOException, InterruptedException {
        String version = CLIVersionUtils.getCLIVersion(cliDirectory, minimumVersion);
        CLIVersionUtils.checkCLICompatibility(version, minimumVersion);
    }

    public static void checkProtocolSupported(String cliVersion) throws AbortException {
        if (CLIVersionUtils.compareVersions(cliVersion, HOST_CONNECTION_PROTOCOL_MINIMUM_VERSION) < 0) {
            throw new AbortException(Messages.hostConnectionProtocolCliVersionError(cliVersion, HOST_CONNECTION_PROTOCOL_MINIMUM_VERSION));
        }
    }

    private static int compareVersions(String cliVersion, String minimumVersion) {
        if (StringUtils.isEmpty((String)cliVersion)) {
            return -1;
        }
        String[] minimumVersionParts = StringUtils.split((String)minimumVersion, (char)'.');
        String[] cliVersionParts = StringUtils.split((String)cliVersion, (char)'.');
        int length = Math.max(minimumVersionParts.length, cliVersionParts.length);
        for (int i = 0; i < length; ++i) {
            int cliVersionPart;
            int minimumVersionPart = i < minimumVersionParts.length ? Integer.parseInt(minimumVersionParts[i]) : 0;
            int n = cliVersionPart = i < cliVersionParts.length ? Integer.parseInt(cliVersionParts[i]) : 0;
            if (cliVersionPart < minimumVersionPart) {
                return -1;
            }
            if (cliVersionPart <= minimumVersionPart) continue;
            return 1;
        }
        return 0;
    }

    private static String parseXml(InputStream versionfile) throws IOException {
        String version = "";
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document document = dBuilder.parse(versionfile);
            version = document.getDocumentElement().getAttribute("version");
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new AbortException(Messages.cliParseXmlError());
        }
        return version;
    }
}

