/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.jenkins.common.configuration;

import com.compuware.jenkins.common.configuration.Messages;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class HostConnection
extends AbstractDescribableImpl<HostConnection> {
    private final String m_description;
    private final String m_hostPort;
    private final String m_protocol;
    private final String m_codePage;
    private final String m_timeout;
    private final String m_connectionId;
    private final String m_cesUrl;

    @DataBoundConstructor
    public HostConnection(String description, String hostPort, String protocol, String codePage, String timeout, String connectionId, String cesUrl) {
        this.m_description = StringUtils.trimToEmpty((String)description);
        this.m_hostPort = StringUtils.trimToEmpty((String)hostPort);
        this.m_protocol = StringUtils.trimToEmpty((String)protocol);
        this.m_codePage = StringUtils.trimToEmpty((String)codePage);
        this.m_timeout = StringUtils.trimToEmpty((String)timeout);
        this.m_connectionId = HostConnection.generateId(connectionId);
        this.m_cesUrl = StringUtils.trimToEmpty((String)cesUrl);
    }

    public HostConnection(String description, String hostPort, String codePage, String timeout, String connectionId, String cesUrl) {
        this(description, hostPort, null, codePage, timeout, connectionId, cesUrl);
    }

    public HostConnection(String description, String hostPort, String codePage, String timeout, String connectionId) {
        this(description, hostPort, null, codePage, timeout, connectionId, null);
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getHostPort() {
        return this.m_hostPort;
    }

    public String getHost() {
        return StringUtils.substringBefore((String)this.getHostPort(), (String)":");
    }

    public String getPort() {
        return StringUtils.substringAfter((String)this.getHostPort(), (String)":");
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public String getCodePage() {
        return this.m_codePage;
    }

    public String getTimeout() {
        return StringUtils.isBlank((String)this.m_timeout) ? "0" : this.m_timeout;
    }

    public String getConnectionId() {
        return this.m_connectionId;
    }

    public static String generateId(String id) {
        String generatedId = id;
        if (StringUtils.isEmpty((String)generatedId)) {
            generatedId = UUID.randomUUID().toString();
        }
        return generatedId;
    }

    public String getCesUrl() {
        return this.m_cesUrl;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<HostConnection> {
        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends HostConnection> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return Messages.displayNameHostConnection();
        }

        public FormValidation doCheckHostPort(@QueryParameter String value) {
            FormValidation result;
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (tempValue.isEmpty()) {
                result = FormValidation.error((String)Messages.checkHostPortEmptyError());
            } else {
                String[] hostPortParts = StringUtils.split((String)tempValue, (String)":");
                if (hostPortParts.length == 2) {
                    String host = StringUtils.trimToEmpty((String)hostPortParts[0]);
                    String port = StringUtils.trimToEmpty((String)hostPortParts[1]);
                    result = this.validateHostPort(host, port);
                } else {
                    int index;
                    result = hostPortParts.length > 2 ? FormValidation.error((String)Messages.checkHostPortFormatError()) : ((index = tempValue.indexOf(":")) == -1 ? FormValidation.error((String)Messages.checkHostPortFormatError()) : (index == 0 ? FormValidation.error((String)Messages.checkHostPortMissingHostError()) : FormValidation.error((String)Messages.checkHostPortMissingPortError())));
                }
            }
            return result;
        }

        private FormValidation validateHostPort(String host, String port) {
            FormValidation result = FormValidation.ok();
            if (host.isEmpty()) {
                result = FormValidation.error((String)Messages.checkHostPortMissingHostError());
            } else if (port.isEmpty()) {
                result = FormValidation.error((String)Messages.checkHostPortMissingPortError());
            } else if (!StringUtils.isNumeric((String)port)) {
                result = FormValidation.error((String)Messages.checkHostPortInvalidPortError());
            }
            return result;
        }

        public FormValidation doCheckDescription(@QueryParameter String value) {
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (tempValue.isEmpty()) {
                return FormValidation.error((String)Messages.checkDescriptionEmptyError());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (!tempValue.isEmpty()) {
                if (!StringUtils.isNumeric((String)tempValue)) {
                    return FormValidation.error((String)Messages.checkTimeoutError());
                }
                try {
                    Integer.parseInt(tempValue);
                }
                catch (NumberFormatException e) {
                    return FormValidation.error((String)Messages.checkTimeoutError());
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCesUrl(@QueryParameter String value) {
            FormValidation result = FormValidation.ok();
            if (StringUtils.isNotBlank((String)value)) {
                if (!value.endsWith("/")) {
                    value = value + "/";
                }
                try {
                    new URL(value);
                }
                catch (MalformedURLException e) {
                    result = FormValidation.error((String)Messages.checkCesUrlInvalidError());
                }
            }
            return result;
        }
    }
}

