/*
 * Decompiled with CFR 0.152.
 */
package com.composum.nodes.setup.impl;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"job.topics=com/composum/nodes/setup"})
public class NodesSetupService
implements JobConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(NodesSetupService.class);
    public static final String JOB_TOPIC = "com/composum/nodes/setup";
    public static final String SETUP_EXT = ".setup";
    public static final String INSTALL_FOLDER = "install";
    public static final String UPLOAD_FOLDER = "upload";
    public static final String NODES_CONTENT_PATH = "/libs/composum/nodes";
    public static final String NODES_BUNDLES_PATH = "/libs/composum/nodes/install";
    public static final String SETUP_NODES_FOLDER = "/libs/composum/nodes.setup";
    public static final String SETUP_BUNDLES_PATH = "/libs/composum/nodes.setup/upload";
    public static final String NODES_PACKAGES_PATH = "com/composum/nodes/";
    public static final Pattern VERSION_PATTERN = Pattern.compile("^(.*/)?composum-nodes-package-setup-bundle-(?<version>(.+))\\.jar$");
    public static final Pattern[] INSTALL_ARTIFACTS = new Pattern[]{Pattern.compile("^composum-nodes-package-setup-bundle-(.+)\\.jar$"), Pattern.compile("^.*\\.LoginAdminWhitelist\\.fragment-composum_nodes_setup\\.config$")};
    public static final Pattern[] BUNDLES_TO_UNINSTALL = new Pattern[]{Pattern.compile("^(.*/)?composum-nodes-jslibs-.*\\.jar$"), Pattern.compile("^(.*/)?composum-sling-core-jslibs-.*\\.jar$"), Pattern.compile("^(.*/)?composum-nodes-usermgr-.*\\.jar$"), Pattern.compile("^(.*/)?composum-sling-user-management-.*\\.jar$"), Pattern.compile("^(.*/)?composum-nodes-pckgmgr-.*\\.jar$"), Pattern.compile("^(.*/)?composum-sling-package-manager-.*\\.jar$"), Pattern.compile("^(.*/)?composum-nodes-console-.*\\.jar$"), Pattern.compile("^(.*/)?composum-sling-core-console-.*\\.jar$"), Pattern.compile("^(.*/)?composum-nodes-config-.*\\.jar$"), Pattern.compile("^(.*/)?composum-sling-core-config-.*\\.jar$"), Pattern.compile("^(.*/)?composum-nodes-commons-.*\\.jar$"), Pattern.compile("^(.*/)?composum-sling-core-commons-.*\\.jar$")};
    protected static final String REP_POLICY = "rep:policy";
    protected static final String REP_ACCESS_CONTROLLABLE = "rep:AccessControllable";
    @Reference
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    protected JobManager jobManager;
    @Reference
    private Packaging packaging;
    private volatile BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        LOG.info("Composum Nodes setup.activate...");
        Job job = this.jobManager.createJob(JOB_TOPIC).add();
        LOG.info("Composum Nodes setup: job created: [ {} ]", (Object)job.getId());
    }

    @Deactivate
    protected void deactivate() {
        LOG.info("Composum Nodes setup.deactivate...");
        this.bundleContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobConsumer.JobResult process(Job job) {
        block28: {
            this.wait(1);
            LOG.info("\n\nComposum Nodes setup: processing...\n");
            try (ResourceResolver resolver = this.resolverFactory.getAdministrativeResourceResolver(null);){
                Session session = (Session)resolver.adaptTo(Session.class);
                if (session != null) {
                    BundleContext origBundleContext = this.bundleContext;
                    try {
                        Node nodesSetupFolder = session.getNode(SETUP_NODES_FOLDER);
                        if (this.removeNodesBundles(session)) {
                            this.wait(3);
                        }
                        if (origBundleContext.equals(this.bundleContext)) {
                            this.setupNodesBundlesAndContent(session);
                            session.save();
                            LOG.info("\n\nComposum Nodes setup: SUCCESS.\n");
                        } else {
                            LOG.info("\n\nComposum Nodes setup: process stopped - waiting for a following job.\n");
                        }
                        break block28;
                    }
                    catch (PathNotFoundException ignore) {
                        LOG.info("\n\nComposum Nodes setup: no Nodes install folder found [ {} ]\n", (Object)SETUP_NODES_FOLDER);
                        break block28;
                    }
                    catch (IOException | RuntimeException | RepositoryException | PackageException ex) {
                        LOG.error("Composum Nodes setup: " + ex.getMessage(), ex);
                        LOG.error("\n\nComposum Nodes setup: process FAILED! Please retry or continue manually.\n");
                        break block28;
                    }
                    finally {
                        if (origBundleContext.equals(this.bundleContext)) {
                            try {
                                session.refresh(false);
                                this.removeInstallArtifacts(session);
                                session.save();
                            }
                            catch (RepositoryException exx) {
                                LOG.error("Composum Nodes setup: setup bundle + conf could not be removed - please remove manually.", (Throwable)exx);
                            }
                        }
                    }
                }
                LOG.error("Composum Nodes setup: can't adapt to Session, failed!");
            }
            catch (LoginException lex) {
                LOG.error("Composum Nodes setup: cannot get administrative resolver - {}" + lex.getMessage());
                LOG.error("\n\nComposum Nodes setup: process failed!\n");
            }
        }
        return JobConsumer.JobResult.OK;
    }

    protected boolean removeNodesBundles(@NotNull Session session) throws RepositoryException {
        boolean bundlesRemoved = false;
        try {
            Node nodesSetupFolder = session.getNode(SETUP_NODES_FOLDER);
            bundlesRemoved = this.removeUploadedBundles(session);
            if (bundlesRemoved) {
                this.wait(3);
            }
            bundlesRemoved = this.uninstallBundles() || bundlesRemoved;
        }
        catch (PathNotFoundException ignore) {
            LOG.info("\n\nComposum Nodes setup: no Nodes install folder found [ {} ]\n", (Object)SETUP_NODES_FOLDER);
        }
        return bundlesRemoved;
    }

    protected void setupNodesBundlesAndContent(@NotNull Session session) throws RepositoryException, PackageException, IOException {
        try {
            Node nodesSetupFolder = session.getNode(SETUP_NODES_FOLDER);
            try {
                Node nodesSetupBundles = session.getNode(SETUP_BUNDLES_PATH);
                NodeIterator iterator = nodesSetupBundles.getNodes();
                while (iterator.hasNext()) {
                    Node node = iterator.nextNode();
                    String targetPath = "/libs/composum/nodes/install/" + node.getName();
                    LOG.info("Composum Nodes setup: installing node [ {} ]", (Object)targetPath);
                    session.move(node.getPath(), targetPath);
                }
                session.save();
                nodesSetupBundles.remove();
                session.save();
            }
            catch (PathNotFoundException nodesSetupBundles) {
                // empty catch block
            }
            this.moveAcl(session.getNode(NODES_CONTENT_PATH), nodesSetupFolder, false);
            this.removeNodesContent(session);
            NodeIterator iterator = nodesSetupFolder.getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                String targetPath = "/libs/composum/nodes/" + node.getName();
                LOG.info("Composum Nodes setup: installing node [ {} ]", (Object)targetPath);
                session.move(node.getPath(), targetPath);
            }
            session.save();
            nodesSetupFolder.remove();
            session.save();
            Matcher matcher = VERSION_PATTERN.matcher(this.bundleContext.getBundle().getLocation());
            if (matcher.matches()) {
                this.wait(3);
                String version = matcher.group("version");
                this.installPackage(session, "com/composum/nodes/composum-nodes-jslibs-package-" + version + ".zip", new Pattern[0]);
            } else {
                LOG.warn("Composum Nodes setup: Couldn't determine our version from {}", (Object)this.bundleContext.getBundle().getLocation());
            }
        }
        catch (PathNotFoundException ignore) {
            LOG.info("\n\nComposum Nodes setup: no Nodes install folder found [ {} ]\n", (Object)SETUP_NODES_FOLDER);
        }
    }

    protected void moveAcl(Node src, Node target, boolean isSubnode) throws RepositoryException {
        NodeIterator it = src.getNodes();
        while (it.hasNext()) {
            Node srcChild = it.nextNode();
            String name = srcChild.getName();
            if (REP_POLICY.equals(name) || !target.hasNode(name)) continue;
            Node targetChild = target.getNode(name);
            this.moveAcl(srcChild, targetChild, true);
        }
        if (isSubnode && src.isNodeType(REP_ACCESS_CONTROLLABLE)) {
            target.addMixin(REP_ACCESS_CONTROLLABLE);
            LOG.info("Composum Nodes setup: keeping ACL on {}", (Object)src.getPath());
            src.getSession().move(src.getNode(REP_POLICY).getPath(), target.getPath() + '/' + REP_POLICY);
        }
    }

    protected void installPackage(@NotNull Session session, @NotNull String packagePath, Pattern ... subpckgPatterns) throws RepositoryException, PackageException, IOException {
        JcrPackage jcrPackage;
        JcrPackageManager manager = this.packaging.getPackageManager(session);
        Node pckgRoot = manager.getPackageRoot();
        Node pckgNode = pckgRoot.getNode(packagePath);
        if (pckgNode != null && (jcrPackage = manager.open(pckgNode, true)) != null) {
            ImportOptions importOptions = this.createPackageImportOptions();
            if (subpckgPatterns == null || subpckgPatterns.length < 1) {
                LOG.info("Composum Nodes setup: package install [ {} ]", (Object)packagePath);
                jcrPackage.install(importOptions);
            } else {
                PackageId[] subpackages;
                for (PackageId pckgId : subpackages = jcrPackage.extractSubpackages(importOptions)) {
                    JcrPackage subpackage = manager.open(pckgId);
                    if (subpackage == null) continue;
                    for (Pattern pattern : subpckgPatterns) {
                        String subpckgName;
                        Node subpckgNode = subpackage.getNode();
                        if (subpckgNode == null || !pattern.matcher(subpckgName = subpckgNode.getName()).matches()) continue;
                        LOG.info("Composum Nodes setup: subpackage install [ {} ]", (Object)subpckgName);
                        subpackage.install(importOptions);
                    }
                }
            }
        }
    }

    protected ImportOptions createPackageImportOptions() {
        ImportOptions options = new ImportOptions();
        options.setDryRun(false);
        options.setAutoSaveThreshold(1024);
        options.setImportMode(ImportMode.REPLACE);
        options.setHookClassLoader(this.dynamicClassLoaderManager.getDynamicClassLoader());
        return options;
    }

    protected void removeNodesContent(@NotNull Session session) throws RepositoryException {
        try {
            Node nodesContent = session.getNode(NODES_CONTENT_PATH);
            NodeIterator iterator = nodesContent.getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                if (INSTALL_FOLDER.equals(node.getName()) || REP_POLICY.equals(node.getName())) continue;
                LOG.info("Composum Nodes setup: removing node [ {} ]", (Object)node.getPath());
                node.remove();
            }
            session.save();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    protected boolean removeUploadedBundles(@NotNull Session session) {
        boolean result = false;
        try {
            Node bundlesFolder = session.getNode(NODES_BUNDLES_PATH);
            NodeIterator iterator = bundlesFolder.getNodes();
            while (iterator.hasNext()) {
                try {
                    Node bundleNode = iterator.nextNode();
                    if (this.isInstallArtifact(bundleNode.getName())) continue;
                    LOG.info("Composum Nodes setup: removing node [ {} ]", (Object)bundleNode.getPath());
                    bundleNode.remove();
                    result = true;
                }
                catch (RepositoryException ex) {
                    LOG.error("Composum Nodes setup: could not remove bundles / configs from /libs/composum/nodes/install", (Throwable)ex);
                }
            }
            session.save();
        }
        catch (PathNotFoundException bundlesFolder) {
        }
        catch (RepositoryException ex) {
            LOG.error("Composum Nodes setup: could not remove bundles / configs from /libs/composum/nodes/install", (Throwable)ex);
        }
        return result;
    }

    protected boolean uninstallBundles() {
        boolean result = false;
        for (Pattern pattern : BUNDLES_TO_UNINSTALL) {
            if (this.bundleContext == null) continue;
            for (Bundle bundle : this.bundleContext.getBundles()) {
                Matcher matcher = pattern.matcher(bundle.getLocation());
                if (!matcher.matches()) continue;
                try {
                    int state = bundle.getState();
                    if (state == 1) continue;
                    result = true;
                    LOG.info("Composum Nodes setup: uninstalling bundle [ {} ]", (Object)bundle.getLocation());
                    if (state == 32 || state == 8) {
                        bundle.stop();
                    }
                    bundle.uninstall();
                }
                catch (IllegalStateException | BundleException ex) {
                    LOG.error("Composum Nodes setup: trouble uninstalling bundle {}", (Object)bundle.getLocation(), (Object)ex);
                }
            }
        }
        return result;
    }

    protected boolean isInstallArtifact(@NotNull String name) {
        for (Pattern pattern : INSTALL_ARTIFACTS) {
            Matcher matcher = pattern.matcher(name);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    protected void removeInstallArtifacts(@NotNull Session session) throws RepositoryException {
        try {
            Node bundlesFolder = session.getNode(NODES_BUNDLES_PATH);
            NodeIterator iterator = bundlesFolder.getNodes();
            while (iterator.hasNext()) {
                try {
                    Node bundleNode = iterator.nextNode();
                    if (!this.isInstallArtifact(bundleNode.getName())) continue;
                    LOG.info("Composum Nodes setup: removing install node [ {} ]", (Object)bundleNode.getPath());
                    bundleNode.remove();
                }
                catch (RepositoryException ex) {
                    LOG.error("Composum Nodes setup: trouble cleaning up /libs/composum/nodes/install", (Throwable)ex);
                }
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    protected void wait(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException ex) {
            LOG.warn(ex.toString());
            Thread.currentThread().interrupt();
        }
    }
}

