/*
 * Decompiled with CFR 0.152.
 */
package com.compilit.logging;

import com.compilit.logging.MethodExecution;
import com.compilit.logging.api.Event;
import com.compilit.logging.api.Log;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.event.Level;

abstract class MethodPhase {
    private final Map<ProceedingJoinPoint, String> methodNames = new HashMap<ProceedingJoinPoint, String>();

    MethodPhase() {
    }

    abstract void next(ProceedingJoinPoint var1, Logger var2, List<Log> var3, MethodExecution var4);

    protected static String getMessage(String provided, Event event) {
        if (StringUtils.isNotBlank((CharSequence)provided)) {
            return provided;
        }
        return event.getDefaultMessage();
    }

    protected static boolean containsEvent(List<Log> logEntries, Event event) {
        return logEntries.stream().anyMatch(logEntry -> logEntry.event().equals((Object)event));
    }

    protected static Log getLogAnnotation(List<Log> logEntries, Event event) {
        return logEntries.stream().filter(logEntry -> logEntry.event().equals((Object)event)).findFirst().orElseThrow();
    }

    protected String getMethodName(ProceedingJoinPoint joinPoint) {
        String methodName;
        if (this.methodNames.containsKey(joinPoint)) {
            methodName = this.methodNames.get(joinPoint);
        } else {
            methodName = joinPoint.getSignature().getName();
            this.methodNames.put(joinPoint, methodName);
        }
        return methodName;
    }

    protected static void log(Logger logger, String message, Level level, Object ... args) {
        switch (level) {
            case ERROR: {
                logger.error(message, args);
                break;
            }
            case WARN: {
                logger.warn(message, args);
                break;
            }
            case INFO: {
                logger.info(message, args);
                break;
            }
            case DEBUG: {
                logger.debug(message, args);
                break;
            }
            case TRACE: {
                logger.trace(message, args);
            }
        }
    }
}

