/*
 * Decompiled with CFR 0.152.
 */
package com.commonsense.android.kotlin.system.datastructures;

import android.util.SparseArray;
import android.util.SparseIntArray;
import com.commonsense.android.kotlin.base.algorithms.Comparing;
import com.commonsense.android.kotlin.base.extensions.collections.SparseIntArrayKt;
import com.commonsense.android.kotlin.system.datastructures.IndexPath;
import com.commonsense.android.kotlin.system.datastructures.SectionIndexCache$findContainingSectionAndStartIndex$$inlined$binarySearch$1$wm$SparseIntArrayKt$WhenMappings;
import com.commonsense.android.kotlin.system.datastructures.SectionLookupRepKt;
import com.commonsense.android.kotlin.system.datastructures.TypeSection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ*\u0010\f\u001a\u0004\u0018\u00010\r\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u00130\u0012J\"\u0010\u0014\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u00130\u0012H\u0002J*\u0010\u0015\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u00130\u00122\b\b\u0002\u0010\u0016\u001a\u00020\u0004J\"\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0018*\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/commonsense/android/kotlin/system/datastructures/SectionIndexCache;", "", "()V", "isInvalid", "", "()Z", "<set-?>", "isValid", "sectionMapping", "Landroid/util/SparseIntArray;", "invalidate", "", "lookup", "Lcom/commonsense/android/kotlin/system/datastructures/IndexPath;", "T", "rawIndex", "", "data", "Landroid/util/SparseArray;", "Lcom/commonsense/android/kotlin/system/datastructures/TypeSection;", "rebuildMapping", "recompute", "forceUpdate", "findContainingSectionAndStartIndex", "Lkotlin/Pair;", "system_release"})
public final class SectionIndexCache {
    private SparseIntArray sectionMapping = new SparseIntArray();
    private boolean isValid = true;

    public final <T> void recompute(@NotNull SparseArray<TypeSection<T>> data, boolean forceUpdate) {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        if (this.isValid && !forceUpdate) {
            return;
        }
        this.rebuildMapping(data);
        this.isValid = true;
    }

    public static /* synthetic */ void recompute$default(SectionIndexCache sectionIndexCache, SparseArray sparseArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        sectionIndexCache.recompute(sparseArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> void rebuildMapping(SparseArray<TypeSection<T>> data) {
        this.sectionMapping.clear();
        int currentSize = 0;
        SparseArray<TypeSection<T>> $this$forEachIndexed$iv = data;
        boolean $i$f$forEachIndexed = false;
        int size$iv = $this$forEachIndexed$iv.size();
        int n = 0;
        int n2 = size$iv;
        while (n < n2) {
            void value;
            void index$iv;
            int key$iv = $this$forEachIndexed$iv.keyAt((int)index$iv);
            Object value$iv = $this$forEachIndexed$iv.valueAt((int)index$iv);
            void var10_10 = index$iv;
            TypeSection typeSection = (TypeSection)value$iv;
            int $noName_0 = key$iv;
            boolean bl = false;
            if (SectionLookupRepKt.access$isNotEmptyOrInvisible$p((TypeSection)value)) {
                this.sectionMapping.append(value.getSectionIndexValue(), currentSize += value.getVisibleCount());
            }
            ++index$iv;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T> IndexPath lookup(int rawIndex, @NotNull SparseArray<TypeSection<T>> data) {
        void key;
        Pair<Integer, Integer> didFind;
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        this.recompute(data, false);
        Pair<Integer, Integer> pair = didFind = this.findContainingSectionAndStartIndex(this.sectionMapping, rawIndex);
        if (pair == null) {
            return null;
        }
        Pair<Integer, Integer> pair2 = pair;
        int n = ((Number)pair2.component1()).intValue();
        int value = ((Number)pair2.component2()).intValue();
        return new IndexPath(rawIndex - value, (int)key);
    }

    public final void invalidate() {
        this.isValid = false;
        this.sectionMapping.clear();
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final boolean isInvalid() {
        return !this.isValid;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Integer, Integer> findContainingSectionAndStartIndex(@NotNull SparseIntArray $this$findContainingSectionAndStartIndex, int rawIndex) {
        void $this$previousValueOr$iv;
        Pair pair;
        block8: {
            SparseIntArray $this$binarySearch$iv = $this$findContainingSectionAndStartIndex;
            boolean $i$f$binarySearch = false;
            int start$iv = 0;
            int end$iv = $this$binarySearch$iv.size();
            while (start$iv < end$iv) {
                void $this$compareToRange$iv;
                void var22_27;
                void value;
                void $this$previousValueOr$iv22;
                void index;
                Pair pair$iv;
                int mid$iv = start$iv + (end$iv - start$iv) / 2;
                SparseIntArray $this$keyValueAt$iv$iv = $this$binarySearch$iv;
                boolean $i$f$keyValueAt = false;
                SparseIntArray $this$isIndexValid$iv$iv$iv = $this$keyValueAt$iv$iv;
                boolean $i$f$isIndexValid = false;
                boolean bl = mid$iv >= 0 && mid$iv < $this$isIndexValid$iv$iv$iv.size();
                if ((bl ? new Pair((Object)$this$keyValueAt$iv$iv.keyAt(mid$iv), (Object)$this$keyValueAt$iv$iv.valueAt(mid$iv)) : null) == null) {
                    throw (Throwable)new Exception("should never happen, mid = " + mid$iv + ", start = " + start$iv + ", end = " + end$iv + " \n" + " pretty SparseIntArray = " + SparseIntArrayKt.toPrettyString((SparseIntArray)$this$binarySearch$iv));
                }
                pair$iv = pair$iv;
                int n = mid$iv;
                int n2 = ((Number)pair$iv.getSecond()).intValue();
                int $noName_0 = ((Number)pair$iv.getFirst()).intValue();
                boolean bl2 = false;
                SparseIntArray sparseIntArray = $this$findContainingSectionAndStartIndex;
                int defaultValue$iv = 0;
                boolean $i$f$previousValueOr = false;
                void indexToConsider$iv = index - true;
                void $this$isIndexValid$iv$iv = $this$previousValueOr$iv22;
                boolean $i$f$isIndexValid2 = false;
                int from = indexToConsider$iv >= 0 && indexToConsider$iv < $this$isIndexValid$iv$iv.size() ? $this$previousValueOr$iv22.valueAt((int)indexToConsider$iv) : defaultValue$iv;
                int $this$previousValueOr$iv22 = rawIndex;
                void to$iv = value - true;
                boolean $i$f$compareToRange = false;
                switch (SectionIndexCache$findContainingSectionAndStartIndex$$inlined$binarySearch$1$wm$SparseIntArrayKt$WhenMappings.$EnumSwitchMapping$0[(from > to$iv ? Comparing.LessThan : (from <= (var22_27 = $this$compareToRange$iv) && to$iv >= var22_27 ? Comparing.Equal : ($this$compareToRange$iv > to$iv ? Comparing.LargerThan : Comparing.LessThan))).ordinal()]) {
                    case 1: {
                        start$iv = mid$iv + 1;
                        break;
                    }
                    case 2: {
                        end$iv = mid$iv;
                        break;
                    }
                    case 3: {
                        pair = pair$iv;
                        break block8;
                    }
                }
            }
            pair = null;
        }
        if (pair == null) {
            return null;
        }
        Pair index = pair;
        int prevIndex = $this$findContainingSectionAndStartIndex.indexOfKey(((Number)index.getFirst()).intValue());
        SparseIntArray start$iv = $this$findContainingSectionAndStartIndex;
        int defaultValue$iv = 0;
        boolean $i$f$previousValueOr = false;
        int indexToConsider$iv = prevIndex - 1;
        void $this$isIndexValid$iv$iv = $this$previousValueOr$iv;
        boolean $i$f$isIndexValid = false;
        int from = indexToConsider$iv >= 0 && indexToConsider$iv < $this$isIndexValid$iv$iv.size() ? $this$previousValueOr$iv.valueAt(indexToConsider$iv) : defaultValue$iv;
        return new Pair(index.getFirst(), (Object)from);
    }
}

