/*
 * Decompiled with CFR 0.152.
 */
package com.commonsense.android.kotlin.system.extensions;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.StyleableRes;
import android.support.v7.content.res.AppCompatResources;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0001H\u0087\b\u00a2\u0006\u0002\u0010\u0004\u001a!\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u00012\b\b\u0001\u0010\u0005\u001a\u00020\u0001H\u0087\b\u001a!\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0086\b\u001a\u0019\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0001H\u0086\b\u001a#\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0086\b\u001a6\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u00012\u0010\b\u0004\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u000e0\u0010H\u0086\b\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"getColorSafe", "", "Landroid/content/res/TypedArray;", "style", "(Landroid/content/res/TypedArray;I)Ljava/lang/Integer;", "defaultColor", "getDrawableSafe", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "getTextSafe", "", "defaultValue", "ifHaveOrNull", "T", "actionIf", "Lkotlin/Function0;", "(Landroid/content/res/TypedArray;ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "system_release"})
public final class TypedArrayExtensionsKt {
    @Nullable
    public static final Drawable getDrawableSafe(@NotNull TypedArray $receiver, @StyleableRes int style, @NotNull Context context) {
        Drawable drawable;
        boolean $i$f$ifHaveOrNull;
        int $i$f$getDrawableSafe = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int level$iv = 21;
        boolean $i$f$isApiOverOrEqualTo = false;
        if (Build.VERSION.SDK_INT >= level$iv) {
            Drawable drawable2;
            TypedArray $receiver$iv = $receiver;
            $i$f$ifHaveOrNull = false;
            if ($receiver$iv.hasValue(style)) {
                boolean bl = false;
                drawable2 = $receiver.getDrawable(style);
            } else {
                drawable2 = null;
            }
            return drawable2;
        }
        TypedArray $receiver$iv = $receiver;
        $i$f$ifHaveOrNull = false;
        if ($receiver$iv.hasValue(style)) {
            boolean bl = false;
            int defValue = -1;
            int drawableRes = $receiver.getResourceId(style, defValue);
            drawable = drawableRes != defValue ? AppCompatResources.getDrawable((Context)context, (int)drawableRes) : null;
        } else {
            drawable = null;
        }
        return drawable;
    }

    @Nullable
    public static final CharSequence getTextSafe(@NotNull TypedArray $receiver, @StyleableRes int style) {
        CharSequence charSequence;
        int $i$f$getTextSafe = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        TypedArray $receiver$iv = $receiver;
        boolean $i$f$ifHaveOrNull = false;
        if ($receiver$iv.hasValue(style)) {
            boolean bl = false;
            charSequence = $receiver.getText(style);
        } else {
            charSequence = null;
        }
        return charSequence;
    }

    @Nullable
    public static final CharSequence getTextSafe(@NotNull TypedArray $receiver, @StyleableRes int style, @Nullable CharSequence defaultValue) {
        CharSequence charSequence;
        int $i$f$getTextSafe = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        TypedArray $receiver$iv = $receiver;
        boolean $i$f$getTextSafe2 = false;
        TypedArray $receiver$iv$iv = $receiver$iv;
        boolean $i$f$ifHaveOrNull = false;
        if ($receiver$iv$iv.hasValue(style)) {
            boolean bl = false;
            charSequence = $receiver$iv.getText(style);
        } else {
            charSequence = null;
        }
        CharSequence charSequence2 = charSequence;
        if (charSequence == null) {
            charSequence2 = defaultValue;
        }
        return charSequence2;
    }

    @ColorInt
    @Nullable
    public static final Integer getColorSafe(@NotNull TypedArray $receiver, @StyleableRes int style) {
        Integer n;
        int $i$f$getColorSafe = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        TypedArray $receiver$iv = $receiver;
        boolean $i$f$ifHaveOrNull = false;
        if ($receiver$iv.hasValue(style)) {
            boolean bl = false;
            ColorStateList colorStateList = $receiver.getColorStateList(style);
            n = colorStateList != null ? Integer.valueOf(colorStateList.getDefaultColor()) : null;
        } else {
            n = null;
        }
        return n;
    }

    @ColorInt
    public static final int getColorSafe(@NotNull TypedArray $receiver, @StyleableRes int style, @ColorInt int defaultColor) {
        Integer n;
        int $i$f$getColorSafe = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        TypedArray $receiver$iv = $receiver;
        boolean $i$f$getColorSafe2 = false;
        TypedArray $receiver$iv$iv = $receiver$iv;
        boolean $i$f$ifHaveOrNull = false;
        if ($receiver$iv$iv.hasValue(style)) {
            boolean bl = false;
            ColorStateList colorStateList = $receiver$iv.getColorStateList(style);
            n = colorStateList != null ? Integer.valueOf(colorStateList.getDefaultColor()) : null;
        } else {
            n = null;
        }
        return n != null ? n : defaultColor;
    }

    @Nullable
    public static final <T> T ifHaveOrNull(@NotNull TypedArray $receiver, @StyleableRes int style, @NotNull Function0<? extends T> actionIf) {
        int $i$f$ifHaveOrNull = 0;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(actionIf, (String)"actionIf");
        if ($receiver.hasValue(style)) {
            return (T)actionIf.invoke();
        }
        return null;
    }
}

