/*
 * Decompiled with CFR 0.152.
 */
package com.commonsense.android.kotlin.system.extensions;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.annotation.StyleableRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.content.res.AppCompatResources;
import android.util.AttributeSet;
import android.view.Display;
import android.view.WindowManager;
import android.widget.Toast;
import com.commonsense.android.kotlin.system.extensions.StringExtensionsKt;
import com.commonsense.android.kotlin.system.logging.L;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\b\u001a\u0017\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\b\b\u0001\u0010\u0007\u001a\u00020\u0006H\u0086\b\u001a\u0019\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00022\b\b\u0001\u0010\n\u001a\u00020\u0006H\u0086\b\u001a0\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u0006\u001a\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0002H\u0086\b\u001a\u0015\u0010\u0015\u001a\u00020\u0016*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0004H\u0086\b\u001a!\u0010\u0018\u001a\u00020\u0016*\u00020\u00022\b\b\u0001\u0010\u0019\u001a\u00020\u00062\b\b\u0002\u0010\u001a\u001a\u00020\u0006H\u0086\b\u001a\u001f\u0010\u0018\u001a\u00020\u0016*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00042\b\b\u0002\u0010\u001a\u001a\u00020\u0006H\u0086\b\u001a\u0015\u0010\u001b\u001a\u00020\u0016*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0004H\u0086\b\u001a\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0016*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0086\b\u00a2\u0006\u0002\u0010 \u00a8\u0006!"}, d2={"checkPermission", "", "Landroid/content/Context;", "permission", "", "getColorSafe", "", "color", "getDrawableSafe", "Landroid/graphics/drawable/Drawable;", "drawable", "getTypedArrayFor", "Landroid/content/res/TypedArray;", "attributeSet", "Landroid/util/AttributeSet;", "style", "", "defStyleAttr", "defStyleRes", "getVirtualScreenSize", "Landroid/graphics/Point;", "presentDialer", "", "phoneNumber", "safeToast", "message", "length", "showOnMaps", "address", "startActivitySafe", "intent", "Landroid/content/Intent;", "(Landroid/content/Context;Landroid/content/Intent;)Lkotlin/Unit;", "system_release"})
public final class ContextExtensionsKt {
    public static final boolean checkPermission(@NotNull Context $receiver, @NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        return ContextCompat.checkSelfPermission((Context)$receiver, (String)permission) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public static final void presentDialer(@NotNull Context $receiver, @NotNull String phoneNumber) {
        Intent intent;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)phoneNumber, (String)"phoneNumber");
        Intent $receiver2 = intent = new Intent("android.intent.action.DIAL");
        $receiver2.setData(Uri.parse((String)("tel:" + phoneNumber)));
        Intent intent2 = intent;
        Context $receiver$iv = $receiver;
        String title$iv$iv = "ContextExtensions";
        String message$iv$iv = "";
        L l = L.INSTANCE;
        try {
            $receiver$iv.startActivity(intent2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable exception$iv$iv$iv) {
            void p3$iv$iv;
            void p2$iv$iv;
            Throwable throwable = exception$iv$iv$iv;
            String string = message$iv$iv;
            String p1$iv$iv = title$iv$iv;
            l.error(p1$iv$iv, (String)p2$iv$iv, (Throwable)p3$iv$iv);
            Object var8_8 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void showOnMaps(@NotNull Context $receiver, @NotNull String address) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        String urlEncoded = StringExtensionsKt.urlEncoded(address);
        Uri toLaunch = Uri.parse((String)("geo:0,0?q=" + urlEncoded));
        Intent intent = new Intent("android.intent.action.VIEW", toLaunch);
        Context $receiver$iv = $receiver;
        String title$iv$iv = "ContextExtensions";
        String message$iv$iv = "";
        L l = L.INSTANCE;
        try {
            $receiver$iv.startActivity(intent);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable exception$iv$iv$iv) {
            void p3$iv$iv;
            void p2$iv$iv;
            Throwable throwable = exception$iv$iv$iv;
            String string = message$iv$iv;
            String p1$iv$iv = title$iv$iv;
            l.error(p1$iv$iv, (String)p2$iv$iv, (Throwable)p3$iv$iv);
            Object var10_10 = null;
        }
    }

    @Nullable
    public static final Drawable getDrawableSafe(@NotNull Context $receiver, @DrawableRes int drawable) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return AppCompatResources.getDrawable((Context)$receiver, (int)drawable);
    }

    public static final void safeToast(@NotNull Context $receiver, @StringRes int message, int length) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        try {
            Toast.makeText((Context)$receiver, (int)message, (int)length).show();
        }
        catch (Exception e) {
            L.INSTANCE.error("Activity.safeToast", "failed to show toast", (Throwable)e);
        }
    }

    public static /* synthetic */ void safeToast$default(Context $receiver, int message, int length, int n, Object object) {
        if ((n & 2) != 0) {
            length = 0;
        }
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        try {
            Toast.makeText((Context)$receiver, (int)message, (int)length).show();
        }
        catch (Exception e) {
            L.INSTANCE.error("Activity.safeToast", "failed to show toast", (Throwable)e);
        }
    }

    public static final void safeToast(@NotNull Context $receiver, @NotNull String message, int length) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($receiver, message, length, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ Context $this_safeToast;
            final /* synthetic */ String $message;
            final /* synthetic */ int $length;

            @Nullable
            public final Object invokeSuspend(@NotNull Object result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object2 = result;
                        if (object2 instanceof Result.Failure) {
                            throw ((Result.Failure)object2).exception;
                        }
                        CoroutineScope coroutineScope = this.p$;
                        try {
                            Toast.makeText((Context)this.$this_safeToast, (CharSequence)this.$message, (int)this.$length).show();
                        }
                        catch (Exception e) {
                            L.INSTANCE.error("Activity.safeToast", "failed to show toast", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$this_safeToast = context;
                this.$message = string;
                this.$length = n;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static /* synthetic */ void safeToast$default(Context $receiver, String message, int length, int n, Object object) {
        if ((n & 2) != 0) {
            length = 0;
        }
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)2, null);
    }

    public static final int getColorSafe(@NotNull Context $receiver, @ColorRes int color) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ContextCompat.getColor((Context)$receiver, (int)color);
    }

    @Nullable
    public static final Point getVirtualScreenSize(@NotNull Context $receiver) {
        Display display;
        WindowManager windowManager;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Object object = $receiver.getSystemService("window");
        if (!(object instanceof WindowManager)) {
            object = null;
        }
        WindowManager windowManager2 = windowManager = (WindowManager)object;
        Display display2 = display = windowManager2 != null ? windowManager2.getDefaultDisplay() : null;
        if (display2 != null) {
            Display display3;
            Display it = display3 = display2;
            Point size = new Point();
            display.getSize(size);
            return size;
        }
        return null;
    }

    @NotNull
    public static final TypedArray getTypedArrayFor(@NotNull Context $receiver, @NotNull AttributeSet attributeSet, @StyleableRes @NotNull int[] style, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)attributeSet, (String)"attributeSet");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        TypedArray typedArray = $receiver.getTheme().obtainStyledAttributes(attributeSet, style, defStyleAttr, defStyleRes);
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"theme.obtainStyledAttrib\u2026efStyleAttr, defStyleRes)");
        return typedArray;
    }

    @NotNull
    public static /* synthetic */ TypedArray getTypedArrayFor$default(Context context, AttributeSet attributeSet, int[] nArray, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return ContextExtensionsKt.getTypedArrayFor(context, attributeSet, nArray, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Unit startActivitySafe(@NotNull Context $receiver, @NotNull Intent intent) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        String title$iv = "ContextExtensions";
        String message$iv = "";
        L l = L.INSTANCE;
        try {
            $receiver.startActivity(intent);
            unit = Unit.INSTANCE;
        }
        catch (Throwable exception$iv$iv) {
            void p3$iv;
            void p2$iv;
            Throwable throwable = exception$iv$iv;
            String string = message$iv;
            String p1$iv = title$iv;
            l.error(p1$iv, (String)p2$iv, (Throwable)p3$iv);
            unit = null;
        }
        return unit;
    }
}

