/*
 * Decompiled with CFR 0.152.
 */
package com.commonsense.android.kotlin.system;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.IntRange;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.commonsense.android.kotlin.base.debug.PrettyPrintKt;
import com.commonsense.android.kotlin.system.PermissionRequest;
import com.commonsense.android.kotlin.system.PermissionsHandling;
import com.commonsense.android.kotlin.system.PermissionsHandlingKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u00032\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J:\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u00140\u0019j\u0002`\u001a2\u0010\u0010\u001b\u001a\f\u0012\u0004\u0012\u00020\u00140\u0019j\u0002`\u001aJ<\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u00140\u0019j\u0002`\u001a2\u0010\u0010\u001b\u001a\f\u0012\u0004\u0012\u00020\u00140\u0019j\u0002`\u001aH\u0002J\u0016\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u001e\u001a\u00020\u000fJ\b\u0010\u001f\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/commonsense/android/kotlin/system/PermissionsHandling;", "", "handlerRequestCode", "", "(I)V", "getHandlerRequestCode", "()I", "requestsInFlight", "", "Lcom/commonsense/android/kotlin/system/PermissionRequest;", "onRequestPermissionResult", "", "requestCode", "permissions", "", "", "grantedResults", "", "(I[Ljava/lang/String;[I)Z", "performActionForPermission", "", "permission", "activity", "Landroid/app/Activity;", "onGranted", "Lkotlin/Function0;", "Lcom/commonsense/android/kotlin/base/EmptyFunction;", "onFailed", "requestPermissionFor", "requestPermissions", "toPrettyString", "toString", "system_release"})
public final class PermissionsHandling {
    private final List<PermissionRequest> requestsInFlight;
    private final int handlerRequestCode;

    public final void performActionForPermission(@NotNull String permission, @NotNull Activity activity, @NotNull Function0<Unit> onGranted, @NotNull Function0<Unit> onFailed) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull(onGranted, (String)"onGranted");
        Intrinsics.checkParameterIsNotNull(onFailed, (String)"onFailed");
        Context $receiver$iv22 = (Context)activity;
        boolean $receiver$iv22 = ContextCompat.checkSelfPermission((Context)$receiver$iv22, (String)permission) == 0;
        if ($receiver$iv22) {
            onGranted.invoke();
        }
        if (!$receiver$iv22) {
            this.requestPermissionFor(permission, activity, (Function0<Unit>)onGranted, (Function0<Unit>)onFailed);
        }
    }

    private final void requestPermissionFor(String permission, Activity activity, Function0<Unit> onGranted, Function0<Unit> onFailed) {
        boolean anyRequests = this.requestsInFlight.isEmpty();
        this.requestsInFlight.add(new PermissionRequest(permission, onGranted, onFailed));
        boolean $receiver$iv = anyRequests;
        if ($receiver$iv) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{permission}, (int)this.getHandlerRequestCode());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean onRequestPermissionResult(@IntRange(from=0L) int requestCode, @NotNull String[] permissions, @NotNull int[] grantedResults) {
        boolean $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)grantedResults, (String)"grantedResults");
        boolean bl = $receiver$iv = requestCode == this.handlerRequestCode;
        if ($receiver$iv) {
            void $receiver$iv$iv$iv;
            List $receiver$iv2 = this.requestsInFlight;
            Iterable $receiver$iv$iv = $receiver$iv2;
            Iterable iterable = $receiver$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                PermissionRequest it = (PermissionRequest)element$iv$iv$iv;
                if (!Intrinsics.areEqual((Object)it.getPermission(), (Object)((String)ArraysKt.firstOrNull((Object[])permissions)))) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            List collection$iv = (List)destination$iv$iv$iv;
            $receiver$iv2.removeAll(collection$iv);
            List requests = collection$iv;
            Integer n = ArraysKt.firstOrNull((int[])grantedResults);
            boolean isGranted = n != null ? PermissionsHandlingKt.isGranted(n) : false;
            Iterable $receiver$iv3 = requests;
            for (Object element$iv : $receiver$iv3) {
                void $receiver$iv4;
                PermissionRequest it = (PermissionRequest)element$iv;
                boolean element$iv$iv$iv = isGranted;
                Function0<Unit> action$iv = it.getOnGranted();
                void $receiver$iv$iv2 = $receiver$iv4;
                if ($receiver$iv$iv2 != false) {
                    action$iv.invoke();
                }
                $receiver$iv4 = $receiver$iv$iv2;
                action$iv = it.getOnFailed();
                $receiver$iv$iv2 = $receiver$iv4;
                if ($receiver$iv$iv2 != false) continue;
                action$iv.invoke();
            }
        }
        return $receiver$iv;
    }

    public final void requestPermissions(@NotNull String permission, @NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Context $receiver$iv = (Context)activity;
        boolean $receiver$iv2 = ContextCompat.checkSelfPermission((Context)$receiver$iv, (String)permission) == 0;
        if (!$receiver$iv2) {
            this.requestPermissionFor(permission, activity, (Function0<Unit>)requestPermissions.1.1.INSTANCE, (Function0<Unit>)requestPermissions.1.2.INSTANCE);
        }
    }

    @NotNull
    public String toString() {
        return this.toPrettyString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toPrettyString() {
        void var3_4;
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.requestsInFlight;
        StringBuilder stringBuilder = new StringBuilder().append("Permission handler state:");
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            PermissionRequest permissionRequest = (PermissionRequest)item$iv$iv;
            collection = destination$iv$iv;
            String string = it.getPermission() + ',' + " with onGrant: " + it.getOnGranted() + ',' + " on failed: " + it.getOnFailed();
            collection.add(string);
        }
        collection = (List)var3_4;
        return stringBuilder.append(PrettyPrintKt.prettyStringContent$default((List)collection, (String)"Permissions in flight:", (String)"no permissions in flight", null, (int)4, null)).append("\r\t").append("request code is ").append(this.handlerRequestCode).toString();
    }

    public final int getHandlerRequestCode() {
        return this.handlerRequestCode;
    }

    public PermissionsHandling(int handlerRequestCode) {
        List list;
        this.handlerRequestCode = handlerRequestCode;
        PermissionsHandling permissionsHandling = this;
        permissionsHandling.requestsInFlight = list = (List)new ArrayList();
    }

    public /* synthetic */ PermissionsHandling(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 999;
        }
        this(n);
    }

    public PermissionsHandling() {
        this(0, 1, null);
    }
}

