/*
 * Decompiled with CFR 0.152.
 */
package com.commonsense.android.kotlin.system.extensions;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.commonsense.android.kotlin.system.extensions.BaseViewExtensionsKt;
import com.commonsense.android.kotlin.system.extensions.GeneralExtensionsKt;
import com.commonsense.android.kotlin.system.extensions.SystemServicesExtensionsKt$sam$Runnable$599929d4;
import com.commonsense.android.kotlin.system.logging.LKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0007\u001a\u0012\u0010\f\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\u000b*\u00020\u000e\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"inputMethodManager", "Landroid/view/inputmethod/InputMethodManager;", "Landroid/content/Context;", "getInputMethodManager", "(Landroid/content/Context;)Landroid/view/inputmethod/InputMethodManager;", "rootView", "Landroid/view/View;", "Landroid/app/Activity;", "getRootView", "(Landroid/app/Activity;)Landroid/view/View;", "hideSoftKeyboard", "", "hideSoftKeyboardFrom", "editText", "Landroid/widget/EditText;", "requestFocusAndShowKeyboard", "system_release"})
public final class SystemServicesExtensionsKt {
    @SuppressLint(value={"NewApi"})
    @Nullable
    public static final InputMethodManager getInputMethodManager(@NotNull Context $receiver) {
        InputMethodManager inputMethodManager;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (GeneralExtensionsKt.isApiOverOrEqualTo(23)) {
            inputMethodManager = (InputMethodManager)$receiver.getSystemService(InputMethodManager.class);
        } else {
            Object object = $receiver.getSystemService("input_method");
            if (!(object instanceof InputMethodManager)) {
                object = null;
            }
            inputMethodManager = (InputMethodManager)object;
        }
        return inputMethodManager;
    }

    public static final void hideSoftKeyboardFrom(@NotNull Context $receiver, @NotNull EditText editText) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
            InputMethodManager inputMethodManager = SystemServicesExtensionsKt.getInputMethodManager($receiver);
            if (inputMethodManager == null) break block0;
            inputMethodManager.hideSoftInputFromWindow(editText.getWindowToken(), 0);
        }
    }

    public static final void hideSoftKeyboard(@NotNull Activity $receiver) {
        block2: {
            View view;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            View view2 = $receiver.getCurrentFocus();
            if (view2 == null) {
                view2 = view = SystemServicesExtensionsKt.getRootView($receiver);
            }
            if (view == null) {
                LKt.logWarning$default((ComponentCallbacks)$receiver, "no view in focus or root view", null, 2, null);
                return;
            }
            InputMethodManager inputMethodManager = SystemServicesExtensionsKt.getInputMethodManager((Context)$receiver);
            if (inputMethodManager == null) break block2;
            inputMethodManager.hideSoftInputFromInputMethod(view.getWindowToken(), 0);
        }
    }

    @Nullable
    public static final View getRootView(@NotNull Activity $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Window window = $receiver.getWindow();
        if (window == null || (window = window.getDecorView()) == null || (window = window.getRootView()) == null) {
            window = $receiver.findViewById(0x1020002);
        }
        return window;
    }

    public static final void requestFocusAndShowKeyboard(@NotNull EditText $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.requestFocus();
        Context context = $receiver.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        InputMethodManager inputMethodManager = SystemServicesExtensionsKt.getInputMethodManager(context);
        if (inputMethodManager != null) {
            inputMethodManager.toggleSoftInput(2, 1);
        }
        Function0 function0 = (Function0)new Function0<Unit>($receiver){

            public final void invoke() {
                BaseViewExtensionsKt.setSelectionAtEnd((EditText)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinPackage(BaseViewExtensionsKt.class, (String)"system_release");
            }

            public final String getName() {
                return "setSelectionAtEnd";
            }

            public final String getSignature() {
                return "setSelectionAtEnd(Landroid/widget/EditText;)V";
            }
        };
        $receiver.postDelayed((Runnable)new SystemServicesExtensionsKt$sam$Runnable$599929d4(function0), 32L);
    }
}

