/*
 * Decompiled with CFR 0.152.
 */
package com.commonsense.android.kotlin.base.compat;

import androidx.annotation.IntRange;
import com.commonsense.android.kotlin.base.compat.SSLContextProtocols;
import com.commonsense.android.kotlin.base.compat.SSLFactoryKt;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0016J.\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\nH\u0016J.\u0010\u0005\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u000f2\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u000f2\b\b\u0001\u0010\t\u001a\u00020\nH\u0016J.\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u000f2\b\b\u0001\u0010\t\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0015\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/commonsense/android/kotlin/base/compat/SSLSocketFactoryCompat;", "Ljavax/net/ssl/SSLSocketFactory;", "()V", "factory", "(Ljavax/net/ssl/SSLSocketFactory;)V", "createSocket", "Ljava/net/Socket;", "host", "Ljava/net/InetAddress;", "port", "", "address", "localAddress", "localPort", "socket", "", "autoClose", "", "localHost", "getDefaultCipherSuites", "", "()[Ljava/lang/String;", "getSupportedCipherSuites", "base_release"})
public final class SSLSocketFactoryCompat
extends SSLSocketFactory {
    private final SSLSocketFactory factory;

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        String[] stringArray = this.factory.getSupportedCipherSuites();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"factory.supportedCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getDefaultCipherSuites() {
        String[] stringArray = this.factory.getDefaultCipherSuites();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"factory.defaultCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public Socket createSocket() throws IOException {
        Socket socket = SSLFactoryKt.setProtocolToTls12(this.factory.createSocket());
        Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"factory.createSocket().setProtocolToTls12()");
        return socket;
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable Socket socket, @Nullable String host, @IntRange(from=0L, to=65535L) int port, boolean autoClose) throws IOException {
        Socket socket2 = SSLFactoryKt.setProtocolToTls12(this.factory.createSocket(socket, host, port, autoClose));
        Intrinsics.checkExpressionValueIsNotNull((Object)socket2, (String)"factory.createSocket(soc\u2026ose).setProtocolToTls12()");
        return socket2;
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable String host, @IntRange(from=0L, to=65535L) int port) throws Exception {
        Socket socket = SSLFactoryKt.setProtocolToTls12(this.factory.createSocket(host, port));
        Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"factory.createSocket(hos\u2026ort).setProtocolToTls12()");
        return socket;
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable String host, @IntRange(from=0L, to=65535L) int port, @Nullable InetAddress localHost, int localPort) throws Exception {
        Socket socket = SSLFactoryKt.setProtocolToTls12(this.factory.createSocket(host, port, localHost, localPort));
        Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"factory.createSocket(hos\u2026ort).setProtocolToTls12()");
        return socket;
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable InetAddress host, @IntRange(from=0L, to=65535L) int port) throws IOException {
        Socket socket = SSLFactoryKt.setProtocolToTls12(this.factory.createSocket(host, port));
        Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"factory.createSocket(hos\u2026ort).setProtocolToTls12()");
        return socket;
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable InetAddress address, @IntRange(from=0L, to=65535L) int port, @Nullable InetAddress localAddress, int localPort) throws IOException {
        Socket socket = SSLFactoryKt.setProtocolToTls12(this.factory.createSocket(address, port, localAddress, localPort));
        Intrinsics.checkExpressionValueIsNotNull((Object)socket, (String)"factory.createSocket(add\u2026ort).setProtocolToTls12()");
        return socket;
    }

    public SSLSocketFactoryCompat() throws Exception {
        SSLSocketFactory optFactory;
        SSLSocketFactory sSLSocketFactory = optFactory = SSLContextProtocols.TLSv12.createSocketFactory();
        if (sSLSocketFactory == null) {
            throw (Throwable)new RuntimeException("Cannot work with SSL / TLS when its not available.");
        }
        this.factory = sSLSocketFactory;
    }

    public SSLSocketFactoryCompat(@NotNull SSLSocketFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        this.factory = factory;
    }
}

