/*
 * Decompiled with CFR 0.152.
 */
package com.commonsense.android.kotlin.base.extensions.collections;

import android.support.annotation.IntRange;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.commonsense.android.kotlin.base.algorithms.Comparing;
import com.commonsense.android.kotlin.base.extensions.collections.SpareArrayExtensionsKt$WhenMappings;
import com.commonsense.android.kotlin.base.extensions.collections.SparseArrayEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\u001a=\u0010\u0000\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u001a\b\u0004\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0086\b\u001ak\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\t\u0018\u00010\u0001\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00032H\b\u0004\u0010\n\u001aB\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u0011H\t\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u0005j\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u00020\u000f`\u0010H\u0086\b\u001a9\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u001e\b\u0004\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00120\u0014j\b\u0012\u0004\u0012\u0002H\u0002`\u0015H\u0086\b\u001aK\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0018*\b\u0012\u0004\u0012\u0002H\u00020\u00032$\b\u0004\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00180\u0014j\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0018`\u001aH\u0086\b\u001a'\u0010\u001b\u001a\u00020\u0012*\u00020\u001c2\u0018\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001e0\u0017H\u0086\b\u001a!\u0010\u001b\u001a\u00020\u0012*\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001fH\u0086\b\u001a/\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\u00010\u0017\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00032\b\b\u0003\u0010!\u001a\u00020\u0006H\u0086\b*v\u0010\"\u001a\u0004\b\u0000\u0010\t\u001a\u0004\b\u0001\u0010#\"2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u0011H\t\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u0002H#0\u000522\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u0011H\t\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u0002H#0\u0005\u00a8\u0006$"}, d2={"binarySearch", "Lcom/commonsense/android/kotlin/base/extensions/collections/SparseArrayEntry;", "E", "Landroid/util/SparseArray;", "comparere", "Lkotlin/Function2;", "", "Lcom/commonsense/android/kotlin/base/algorithms/Comparing;", "findFirst", "T", "condition", "Lkotlin/ParameterName;", "name", "key", "item", "", "Lcom/commonsense/android/kotlin/base/extensions/collections/SparseArrayEntryMapper;", "forEach", "", "action", "Lkotlin/Function1;", "Lcom/commonsense/android/kotlin/base/FunctionUnit;", "map", "", "U", "mapper", "Lcom/commonsense/android/kotlin/base/MapFunction;", "set", "Landroid/util/SparseIntArray;", "input", "Lkotlin/Pair;", "", "toList", "maxKeyValue", "SparseArrayEntryMapper", "O", "base_release"})
public final class SpareArrayExtensionsKt {
    public static final void set(@NotNull SparseIntArray $receiver, @NotNull List<Pair<Integer, Integer>> input) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        $receiver.clear();
        Iterable $receiver$iv = input;
        for (Object element$iv : $receiver$iv) {
            Pair it = (Pair)element$iv;
            $receiver.put(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue());
        }
    }

    public static final void set(@NotNull SparseIntArray $receiver, @NotNull Map<Integer, Integer> input) {
        Map<Integer, Integer> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        $receiver.clear();
        Map<Integer, Integer> map = $receiver$iv = input;
        Iterator<Map.Entry<Integer, Integer>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Integer> element$iv;
            Map.Entry<Integer, Integer> it = element$iv = iterator.next();
            $receiver.put(((Number)it.getKey()).intValue(), ((Number)it.getValue()).intValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<SparseArrayEntry<T>> toList(@NotNull SparseArray<T> $receiver, @IntRange(from=1L) int maxKeyValue) {
        void $receiver$iv$iv;
        List list;
        ArrayList list$iv;
        Iterator $receiver$iv$iv2;
        ArrayList $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)$receiver.size());
        SparseArray<T> sparseArray = $receiver;
        void var6_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv2.iterator();
        while (iterator.hasNext()) {
            void p1;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            Integer n2 = sparseArray.keyAt((int)p1);
            collection.add(n2);
        }
        List mapped = (List)destination$iv$iv;
        if (maxKeyValue < Integer.MAX_VALUE) {
            Object item$iv;
            int it;
            $receiver$iv = (ArrayList)mapped;
            list$iv = new ArrayList();
            $receiver$iv$iv2 = $receiver$iv.iterator();
            while ($receiver$iv$iv2.hasNext() && (it = ((Number)(item$iv = $receiver$iv$iv2.next())).intValue()) <= maxKeyValue) {
                list$iv.add(item$iv);
            }
            list = list$iv;
        } else {
            list = mapped;
        }
        $receiver$iv = list;
        list$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            SparseArrayEntry<Object> sparseArrayEntry;
            SparseArrayEntry<Object> sparseArrayEntry2;
            Object element$iv$iv = element$iv$iv$iv;
            int key = ((Number)element$iv$iv).intValue();
            if ($receiver.get(key) != null) {
                Object object;
                Object it = object;
                sparseArrayEntry2 = new SparseArrayEntry<Object>(key, it);
            } else {
                sparseArrayEntry2 = null;
            }
            if (sparseArrayEntry2 == null) continue;
            SparseArrayEntry<Object> it$iv$iv = sparseArrayEntry = sparseArrayEntry2;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static /* bridge */ /* synthetic */ List toList$default(SparseArray $receiver, int maxKeyValue, int n, Object object) {
        void $receiver$iv$iv;
        List list;
        ArrayList list$iv;
        Iterator $receiver$iv$iv2;
        ArrayList $receiver$iv;
        if ((n & 1) != 0) {
            maxKeyValue = Integer.MAX_VALUE;
        }
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)$receiver.size());
        SparseArray sparseArray = $receiver;
        void var6_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv2.iterator();
        while (iterator.hasNext()) {
            void p1;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            Integer n3 = sparseArray.keyAt((int)p1);
            collection.add(n3);
        }
        List mapped = (List)destination$iv$iv;
        if (maxKeyValue < Integer.MAX_VALUE) {
            Object item$iv;
            int it;
            $receiver$iv = (ArrayList)mapped;
            list$iv = new ArrayList();
            $receiver$iv$iv2 = $receiver$iv.iterator();
            while ($receiver$iv$iv2.hasNext() && (it = ((Number)(item$iv = $receiver$iv$iv2.next())).intValue()) <= maxKeyValue) {
                list$iv.add(item$iv);
            }
            list = list$iv;
        } else {
            list = mapped;
        }
        $receiver$iv = list;
        list$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            SparseArrayEntry<Object> sparseArrayEntry;
            SparseArrayEntry<Object> sparseArrayEntry2;
            Object element$iv$iv = element$iv$iv$iv;
            int key = ((Number)element$iv$iv).intValue();
            if ($receiver.get(key) != null) {
                Object object2;
                Object it = object2;
                sparseArrayEntry2 = new SparseArrayEntry<Object>(key, it);
            } else {
                sparseArrayEntry2 = null;
            }
            if (sparseArrayEntry2 == null) continue;
            SparseArrayEntry<Object> it$iv$iv = sparseArrayEntry = sparseArrayEntry2;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T> SparseArrayEntry<T> findFirst(@NotNull SparseArray<T> $receiver, @NotNull Function2<? super Integer, ? super T, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        int size = $receiver.size();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            int key = $receiver.keyAt((int)i);
            Object item = $receiver.get(key);
            if (((Boolean)condition.invoke((Object)key, item)).booleanValue()) {
                return new SparseArrayEntry<Object>(key, item);
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <E, U> List<U> map(@NotNull SparseArray<E> $receiver, @NotNull Function1<? super E, ? extends U> mapper) {
        List list;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(mapper, (String)"mapper");
        List $receiver2 = list = (List)new ArrayList();
        SparseArray<E> $receiver$iv = $receiver;
        int n = 0;
        int n2 = $receiver$iv.size();
        while (n < n2) {
            void i$iv;
            Object it = $receiver$iv.valueAt((int)i$iv);
            $receiver2.add(mapper.invoke(it));
            ++i$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public static final <E> void forEach(@NotNull SparseArray<E> $receiver, @NotNull Function1<? super E, Unit> action) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        int n = 0;
        int n2 = $receiver.size();
        while (n < n2) {
            void i;
            action.invoke($receiver.valueAt((int)i));
            ++i;
        }
    }

    @Nullable
    public static final <E> SparseArrayEntry<E> binarySearch(@NotNull SparseArray<E> $receiver, @NotNull Function2<? super E, ? super Integer, ? extends Comparing> comparere) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(comparere, (String)"comparere");
        int start = 0;
        int end = $receiver.size();
        while (start < end) {
            int mid = start + (end - start) / 2;
            int key = $receiver.keyAt(mid);
            Object item = $receiver.valueAt(key);
            Comparing compResult = (Comparing)((Object)comparere.invoke(item, (Object)mid));
            switch (SpareArrayExtensionsKt$WhenMappings.$EnumSwitchMapping$0[compResult.ordinal()]) {
                case 1: {
                    start = mid + 1;
                    break;
                }
                case 2: {
                    end = mid;
                    break;
                }
                case 3: {
                    return new SparseArrayEntry<Object>(key, item);
                }
            }
        }
        return null;
    }
}

