/*
 * Decompiled with CFR 0.152.
 */
package com.common.log;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import com.common.log.CustomLogConfigurator;
import com.common.log.DatePatternType;
import java.io.File;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LogUtils {
    private static final String DEFAULT_FILE_NAME = "log_";
    private static final String DEFAULT_FILE_PATTERN = "%d{yyy-MM-dd HH:mm:ss} %p %t %l %m%n";
    private static LogUtils instance;
    private static boolean SWITCH_LOG;
    private CustomLogConfigurator logConfigurator;
    private Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogUtils getInstance(Context context) {
        if (instance != null) return instance;
        Class<LogUtils> clazz = LogUtils.class;
        synchronized (LogUtils.class) {
            if (instance != null) return instance;
            instance = new LogUtils(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public LogUtils setFileName(String fileName) {
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            this.logConfigurator.setFileName(fileName);
        }
        return instance;
    }

    public LogUtils setRootLevel(Level level) {
        this.logConfigurator.setRootLevel(level);
        return instance;
    }

    public LogUtils setFilePattern(String filePattern) {
        this.logConfigurator.setFilePattern(filePattern);
        return instance;
    }

    public LogUtils setLogCatPattern(String logCatPattern) {
        this.logConfigurator.setLogCatPattern(logCatPattern);
        return instance;
    }

    public LogUtils setMaxBackupSize(int maxBackupSize) {
        this.logConfigurator.setMaxBackupSize(maxBackupSize);
        return instance;
    }

    public LogUtils setMaxFileSize(long maxFileSize) {
        this.logConfigurator.setMaxFileSize(maxFileSize);
        return instance;
    }

    public LogUtils setUseFileAppender(boolean useFileAppender) {
        this.logConfigurator.setUseFileAppender(useFileAppender);
        return instance;
    }

    public LogUtils setUseLogCatAppender(boolean useLogCatAppender) {
        this.logConfigurator.setUseLogCatAppender(useLogCatAppender);
        return instance;
    }

    public LogUtils setUseDailyFileAppender(boolean useDailyFileAppender) {
        this.logConfigurator.setUseDailyFileAppender(useDailyFileAppender);
        return instance;
    }

    public LogUtils setResetConfiguration(boolean resetConfiguration) {
        this.logConfigurator.setResetConfiguration(resetConfiguration);
        return instance;
    }

    public LogUtils setKeepDays(int keepDays) {
        this.logConfigurator.setKeepDays(keepDays);
        return instance;
    }

    public LogUtils setDatePatternType(DatePatternType datePatternType) {
        this.logConfigurator.setDatePatternType(datePatternType);
        return instance;
    }

    public void init() {
        this.logConfigurator.setResetConfiguration(true);
        this.logConfigurator.configure();
    }

    private LogUtils(Context context) {
        this.context = context;
        this.logConfigurator = new CustomLogConfigurator();
        if (this.isSdcardMounted()) {
            this.logConfigurator.setFileName(Environment.getExternalStorageDirectory() + File.separator + context.getPackageName() + File.separator + DEFAULT_FILE_NAME);
        } else {
            this.logConfigurator.setFileName("//data//data//" + context.getPackageName() + "//files" + File.separator + DEFAULT_FILE_NAME);
        }
        this.logConfigurator.setUseLogCatAppender(true);
        this.logConfigurator.setUseDailyFileAppender(true);
        this.logConfigurator.setKeepDays(7);
        this.logConfigurator.setDatePatternType(DatePatternType.TOP_OF_DAY);
        this.logConfigurator.setImmediateFlush(true);
        this.logConfigurator.setRootLevel(Level.DEBUG);
        this.logConfigurator.setFilePattern(DEFAULT_FILE_PATTERN);
    }

    public static void switchLog(boolean switchLog) {
        SWITCH_LOG = switchLog;
    }

    public static void d(String tag, String message) {
        if (SWITCH_LOG) {
            Logger LOGGER = LogUtils.getLogger(tag);
            LOGGER.debug((Object)message);
        }
    }

    public static void d(String tag, String message, Throwable exception) {
        if (SWITCH_LOG) {
            Logger LOGGER = LogUtils.getLogger(tag);
            LOGGER.debug((Object)message, exception);
        }
    }

    public static void i(String tag, String message) {
        if (SWITCH_LOG) {
            Logger LOGGER = LogUtils.getLogger(tag);
            LOGGER.info((Object)message);
        }
    }

    public static void i(String tag, String message, Throwable exception) {
        if (SWITCH_LOG) {
            Logger LOGGER = LogUtils.getLogger(tag);
            LOGGER.info((Object)message, exception);
        }
    }

    public static void w(String tag, String message) {
        if (SWITCH_LOG) {
            Logger LOGGER = LogUtils.getLogger(tag);
            LOGGER.warn((Object)message);
        }
    }

    public static void w(String tag, String message, Throwable exception) {
        if (SWITCH_LOG) {
            Logger LOGGER = LogUtils.getLogger(tag);
            LOGGER.warn((Object)message, exception);
        }
    }

    public static void e(String tag, String message) {
        if (SWITCH_LOG) {
            Logger LOGGER = LogUtils.getLogger(tag);
            LOGGER.error((Object)message);
        }
    }

    public static void e(String tag, String message, Throwable exception) {
        if (SWITCH_LOG) {
            Logger LOGGER = LogUtils.getLogger(tag);
            LOGGER.error((Object)message, exception);
        }
    }

    public static void f(String tag, String message) {
        if (SWITCH_LOG) {
            Logger LOGGER = LogUtils.getLogger(tag);
            LOGGER.fatal((Object)message);
        }
    }

    public static void f(String tag, String message, Throwable exception) {
        if (SWITCH_LOG) {
            Logger LOGGER = LogUtils.getLogger(tag);
            LOGGER.fatal((Object)message, exception);
        }
    }

    public static Logger getLogger(String tag) {
        Logger logger = TextUtils.isEmpty((CharSequence)tag) ? Logger.getRootLogger() : Logger.getLogger((String)tag);
        return logger;
    }

    private boolean isSdcardMounted() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    static {
        SWITCH_LOG = true;
    }
}

