/*
 * Decompiled with CFR 0.152.
 */
package com.common.log;

import android.annotation.SuppressLint;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class CustomDailyFileAppender
extends FileAppender {
    private static final String TAG = "CustomDailyFileAppender";
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private int keepDays;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    RollingCalendar rc = new RollingCalendar();
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    public CustomDailyFileAppender() {
    }

    public CustomDailyFileAppender(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rc.setType(type);
            File file = new File(this.fileName);
            this.scheduledFilename = this.fileName + this.sdf.format(new Date(file.lastModified()));
        } else {
            Log.e((String)TAG, (String)("Either File or DatePattern options are not set for appender [" + this.name + "]."));
        }
    }

    void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                Log.d((String)TAG, (String)("Appender [" + this.name + "] to be rolled every minute."));
                break;
            }
            case 1: {
                Log.d((String)TAG, (String)("Appender [" + this.name + "] to be rolled on top of every hour."));
                break;
            }
            case 2: {
                Log.d((String)TAG, (String)("Appender [" + this.name + "] to be rolled at midday and midnight."));
                break;
            }
            case 3: {
                Log.d((String)TAG, (String)("Appender [" + this.name + "] to be rolled at midnight."));
                break;
            }
            case 4: {
                Log.d((String)TAG, (String)("Appender [" + this.name + "] to be rolled at start of week."));
                break;
            }
            case 5: {
                Log.d((String)TAG, (String)("Appender [" + this.name + "] to be rolled at start of every month."));
                break;
            }
            default: {
                Log.w((String)TAG, (String)("Unknown periodicity for appender [" + this.name + "]."));
            }
        }
    }

    int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.getDefault());
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    void rollOver() throws IOException {
        File target;
        Log.d((String)TAG, (String)"rollOver  -> rollOver");
        if (this.keepDays != 0) {
            String deleteFileName;
            switch (this.rc.getType()) {
                case 0: {
                    deleteFileName = this.fileName + this.sdf.format(new Date(this.now.getTime() - (long)(this.keepDays * 60 * 1000)));
                    break;
                }
                case 1: {
                    deleteFileName = this.fileName + this.sdf.format(new Date(this.now.getTime() - (long)(this.keepDays * 60 * 60 * 1000)));
                    break;
                }
                case 2: {
                    deleteFileName = this.fileName + this.sdf.format(new Date(this.now.getTime() - (long)(this.keepDays * 12 * 60 * 60 * 1000)));
                    break;
                }
                case 3: {
                    deleteFileName = this.fileName + this.sdf.format(new Date(this.now.getTime() - (long)(this.keepDays * 24 * 60 * 60 * 1000)));
                    break;
                }
                case 4: {
                    deleteFileName = this.fileName + this.sdf.format(new Date(this.now.getTime() - (long)(this.keepDays * 7 * 24 * 60 * 60 * 1000)));
                    break;
                }
                case 5: {
                    deleteFileName = this.fileName + this.sdf.format(new Date(this.now.getTime() - (long)(this.keepDays * 30 * 24 * 60 * 60 * 1000)));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown periodicity type.");
                }
            }
            target = new File(deleteFileName);
            if (target.exists()) {
                target.delete();
                Log.d((String)TAG, (String)("delete log file -> " + deleteFileName));
            }
        }
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
        } else {
            String datedFilename = this.fileName + this.sdf.format(this.now);
            if (!this.scheduledFilename.equals(datedFilename)) {
                File file;
                boolean result;
                this.closeFile();
                target = new File(this.scheduledFilename);
                if (target.exists()) {
                    target.delete();
                }
                if (result = (file = new File(this.fileName)).renameTo(target)) {
                    Log.d((String)TAG, (String)(this.fileName + " -> " + this.scheduledFilename));
                } else {
                    Log.e((String)TAG, (String)("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "]."));
                }
                try {
                    this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
                }
                catch (IOException var6) {
                    this.errorHandler.error("setFile(" + this.fileName + ", true) call failed.");
                }
                this.scheduledFilename = datedFilename;
            }
        }
    }

    protected void subAppend(LoggingEvent event) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.rollOver();
            }
            catch (IOException var5) {
                if (var5 instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                Log.e((String)TAG, (String)"rollOver() failed.", (Throwable)var5);
            }
        }
        super.subAppend(event);
    }

    public int getKeepDays() {
        return this.keepDays;
    }

    public void setKeepDays(int keepDays) {
        this.keepDays = keepDays;
    }

    class RollingCalendar
    extends GregorianCalendar {
        private static final long serialVersionUID = -3560331770601814177L;
        int type;

        RollingCalendar() {
            this.type = -1;
        }

        RollingCalendar(TimeZone tz, Locale locale) {
            super(tz, locale);
            this.type = -1;
        }

        void setType(int type) {
            this.type = type;
        }

        int getType() {
            return this.type;
        }

        public long getNextCheckMillis(Date now) {
            return this.getNextCheckDate(now).getTime();
        }

        @SuppressLint(value={"WrongConstant"})
        public Date getNextCheckDate(Date now) {
            this.setTime(now);
            switch (this.type) {
                case 0: {
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(12, 1);
                    break;
                }
                case 1: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(11, 1);
                    break;
                }
                case 2: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    int hour = this.get(11);
                    if (hour < 12) {
                        this.set(11, 12);
                        break;
                    }
                    this.set(11, 0);
                    this.add(5, 1);
                    break;
                }
                case 3: {
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(5, 1);
                    break;
                }
                case 4: {
                    this.set(7, this.getFirstDayOfWeek());
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(3, 1);
                    break;
                }
                case 5: {
                    this.set(5, 1);
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(2, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown periodicity type.");
                }
            }
            return this.getTime();
        }
    }
}

