/*
 * Decompiled with CFR 0.152.
 */
package com.common.log;

import android.os.Environment;
import android.util.Log;
import com.common.log.CustomLogConfigurator;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Level;

public class Log4jConfigure {
    private static final int MAX_FILE_SIZE = 0xA00000;
    private static final String DEFAULT_LOG_DIR = "//MyApp//Log//";
    private static final String DEFAULT_LOG_FILE_NAME = "log";
    private static final String TAG = "Log4jConfigure";
    private static final String PACKAGE_NAME = "com.king.logtest";

    public static void configure(String fileName) {
        CustomLogConfigurator logConfigurator = new CustomLogConfigurator();
        try {
            if (Log4jConfigure.isSdcardMounted()) {
                logConfigurator.setFileName(Environment.getExternalStorageDirectory() + DEFAULT_LOG_DIR + fileName);
            } else {
                logConfigurator.setFileName("//data//data//com.king.logtest//files" + File.separator + fileName);
            }
            logConfigurator.setUseDailyFileAppender(true);
            logConfigurator.setKeepDays(1);
            logConfigurator.setImmediateFlush(true);
            logConfigurator.setRootLevel(Level.DEBUG);
            logConfigurator.configure();
            Log.e((String)TAG, (String)"Log4j config finish");
        }
        catch (Throwable throwable) {
            logConfigurator.setResetConfiguration(true);
            Log.e((String)TAG, (String)("Log4j config error, use default config. Error:" + throwable));
        }
    }

    public static void configure() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'.log'");
        Log4jConfigure.configure(sdf.format(new Date()));
    }

    private static boolean isSdcardMounted() {
        return "mounted".equals(Environment.getExternalStorageState());
    }
}

