/*
 * Decompiled with CFR 0.152.
 */
package com.commercehub.gradle.plugin.avro;

import com.commercehub.gradle.plugin.avro.AvroBasePlugin;
import com.commercehub.gradle.plugin.avro.AvroExtension;
import com.commercehub.gradle.plugin.avro.GenerateAvroJavaTask;
import com.commercehub.gradle.plugin.avro.GenerateAvroProtocolTask;
import com.commercehub.gradle.plugin.avro.SetBuilder;
import java.io.File;
import java.io.FileFilter;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.plugins.ide.idea.GenerateIdeaModule;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModule;

public class AvroPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(JavaPlugin.class);
        project.getPlugins().apply(AvroBasePlugin.class);
        AvroPlugin.configureTasks(project);
        AvroPlugin.configureIntelliJ(project);
    }

    private static void configureTasks(final Project project) {
        AvroPlugin.getSourceSets(project).all((Action)new Action<SourceSet>(){

            public void execute(SourceSet sourceSet) {
                GenerateAvroProtocolTask protoTask = AvroPlugin.configureProtocolGenerationTask(project, sourceSet);
                AvroPlugin.configureJavaGenerationTask(project, sourceSet, protoTask);
            }
        });
    }

    private static void configureIntelliJ(final Project project) {
        project.getPlugins().withType(IdeaPlugin.class).all((Action)new Action<IdeaPlugin>(){

            public void execute(IdeaPlugin ideaPlugin) {
                SourceSet mainSourceSet = AvroPlugin.getMainSourceSet(project);
                SourceSet testSourceSet = AvroPlugin.getTestSourceSet(project);
                final File mainGeneratedOutputDir = AvroPlugin.getGeneratedOutputDir(project, mainSourceSet, "java");
                final File testGeneratedOutputDir = AvroPlugin.getGeneratedOutputDir(project, testSourceSet, "java");
                project.getTasks().withType(GenerateIdeaModule.class).all((Action)new Action<GenerateIdeaModule>(){

                    public void execute(GenerateIdeaModule generateIdeaModule) {
                        generateIdeaModule.doFirst((Action)new Action<Task>(){

                            public void execute(Task task) {
                                project.mkdir((Object)mainGeneratedOutputDir);
                                project.mkdir((Object)testGeneratedOutputDir);
                            }
                        });
                    }
                });
                IdeaModule module = ideaPlugin.getModel().getModule();
                module.setSourceDirs(new SetBuilder().addAll(module.getSourceDirs()).add(AvroPlugin.getAvroSourceDir(project, mainSourceSet)).add(mainGeneratedOutputDir).build());
                module.setTestSourceDirs(new SetBuilder().addAll(module.getTestSourceDirs()).add(AvroPlugin.getAvroSourceDir(project, testSourceSet)).add(testGeneratedOutputDir).build());
                SetBuilder<File> excludeDirs = new SetBuilder<File>();
                excludeDirs.addAll(module.getExcludeDirs()).remove(project.getBuildDir());
                File buildDir = project.getBuildDir();
                if (buildDir.isDirectory()) {
                    excludeDirs.addAll(project.getBuildDir().listFiles(new NonGeneratedDirectoryFileFilter()));
                }
                module.setExcludeDirs(excludeDirs.build());
            }
        });
    }

    private static GenerateAvroProtocolTask configureProtocolGenerationTask(final Project project, final SourceSet sourceSet) {
        String taskName = sourceSet.getTaskName("generate", "avroProtocol");
        GenerateAvroProtocolTask task = (GenerateAvroProtocolTask)project.getTasks().create(taskName, GenerateAvroProtocolTask.class);
        task.setDescription(String.format("Generates %s Avro protocol definition files from IDL files.", sourceSet.getName()));
        task.setGroup("Source Generation");
        task.source(new Object[]{AvroPlugin.getAvroSourceDir(project, sourceSet)});
        task.include(new String[]{"**/*.avdl"});
        task.getConventionMapping().map("outputDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return AvroPlugin.getGeneratedOutputDir(project, sourceSet, "avpr");
            }
        });
        return task;
    }

    private static GenerateAvroJavaTask configureJavaGenerationTask(final Project project, final SourceSet sourceSet, GenerateAvroProtocolTask protoTask) {
        String taskName = sourceSet.getTaskName("generate", "avroJava");
        GenerateAvroJavaTask task = (GenerateAvroJavaTask)project.getTasks().create(taskName, GenerateAvroJavaTask.class);
        task.setDescription(String.format("Generates %s Avro Java source files from schema/protocol definition files.", sourceSet.getName()));
        task.setGroup("Source Generation");
        task.source(new Object[]{AvroPlugin.getAvroSourceDir(project, sourceSet)});
        task.source(new Object[]{protoTask.getOutputDir()});
        task.source(new Object[]{protoTask.getOutputs()});
        task.include(new String[]{"**/*.avsc", "**/*.avpr"});
        task.getConventionMapping().map("outputDir", (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return AvroPlugin.getGeneratedOutputDir(project, sourceSet, "java");
            }
        });
        final JavaCompile compileJavaTask = AvroPlugin.getCompileJavaTask(project, sourceSet);
        compileJavaTask.source(new Object[]{task.getOutputDir()});
        compileJavaTask.source(new Object[]{task.getOutputs()});
        final AvroExtension avroExtension = (AvroExtension)project.getExtensions().findByType(AvroExtension.class);
        ConventionMapping taskMapping = AvroPlugin.conventionMapping((Object)task);
        taskMapping.map("outputCharacterEncoding", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String compilationEncoding = compileJavaTask.getOptions().getEncoding();
                String extensionEncoding = avroExtension.getOutputCharacterEncoding();
                return compilationEncoding != null ? compilationEncoding : extensionEncoding;
            }
        });
        return task;
    }

    private static File getAvroSourceDir(Project project, SourceSet sourceSet) {
        return project.file((Object)String.format("src/%s/avro", sourceSet.getName()));
    }

    private static File getGeneratedOutputDir(Project project, SourceSet sourceSet, String extension) {
        return new File(project.getBuildDir(), String.format("generated-%s-avro-%s", sourceSet.getName(), extension));
    }

    private static JavaCompile getCompileJavaTask(Project project, SourceSet sourceSet) {
        return (JavaCompile)project.getTasks().getByName(sourceSet.getCompileJavaTaskName());
    }

    private static SourceSetContainer getSourceSets(Project project) {
        return ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
    }

    private static SourceSet getMainSourceSet(Project project) {
        return (SourceSet)AvroPlugin.getSourceSets(project).getByName("main");
    }

    private static SourceSet getTestSourceSet(Project project) {
        return (SourceSet)AvroPlugin.getSourceSets(project).getByName("test");
    }

    private static ConventionMapping conventionMapping(Object conventionAware) {
        return ((IConventionAware)conventionAware).getConventionMapping();
    }

    private static class NonGeneratedDirectoryFileFilter
    implements FileFilter {
        private NonGeneratedDirectoryFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && !file.getName().startsWith("generated-");
        }
    }
}

