/*
 * Decompiled with CFR 0.152.
 */
package com.commercehub.gradle.plugin.avro;

import com.commercehub.gradle.plugin.avro.FilenameUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.specs.Spec;

class FileExtensionSpec
implements Spec<File> {
    private final Set<String> extensions;

    FileExtensionSpec(String ... extensions) {
        this.extensions = new HashSet<String>(Arrays.asList(extensions));
    }

    FileExtensionSpec(Collection<String> extensions) {
        this.extensions = new HashSet<String>(extensions);
    }

    public boolean isSatisfiedBy(File file) {
        return this.extensions.contains(FilenameUtils.getExtension(file.getName()));
    }
}

