/*
 * Decompiled with CFR 0.152.
 */
package com.commercehub.gradle.plugin.avro;

import com.commercehub.gradle.plugin.avro.FileExtensionSpec;
import com.commercehub.gradle.plugin.avro.FileUtils;
import com.commercehub.gradle.plugin.avro.OutputDirTask;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class GenerateAvroSchemaTask
extends OutputDirTask {
    @TaskAction
    protected void process() {
        this.getLogger().info("Found {} files", (Object)this.getSource().getFiles().size());
        this.failOnUnsupportedFiles();
        this.processFiles();
    }

    private void failOnUnsupportedFiles() {
        FileCollection unsupportedFiles = this.filterSources((Spec<? super File>)new NotSpec((Spec)new FileExtensionSpec("avpr")));
        if (!unsupportedFiles.isEmpty()) {
            throw new GradleException(String.format("Unsupported file extension for the following files: %s", unsupportedFiles));
        }
    }

    private void processFiles() {
        int processedFileCount = 0;
        for (File sourceFile : this.filterSources(new FileExtensionSpec("avpr"))) {
            this.processProtoFile(sourceFile);
            ++processedFileCount;
        }
        this.setDidWork(processedFileCount > 0);
    }

    private void processProtoFile(File sourceFile) {
        this.getLogger().info("Processing {}", (Object)sourceFile);
        try {
            Protocol protocol = Protocol.parse((File)sourceFile);
            for (Schema schema : protocol.getTypes()) {
                String path = schema.getNamespace().replaceAll(Pattern.quote("."), "/");
                File schemaFile = new File(((Directory)this.getOutputDir().get()).getAsFile(), path + "/" + schema.getName() + "." + "avsc");
                String schemaJson = schema.toString(true);
                FileUtils.writeJsonFile(schemaFile, schemaJson);
                this.getLogger().debug("Wrote {}", (Object)schemaFile.getPath());
            }
        }
        catch (IOException ex) {
            throw new GradleException(String.format("Failed to process protocol definition file %s", sourceFile), (Throwable)ex);
        }
    }
}

