/*
 * Decompiled with CFR 0.152.
 */
package com.commercehub.gradle.plugin.avro;

import com.commercehub.gradle.plugin.avro.AvroExtension;
import com.commercehub.gradle.plugin.avro.Constants;
import java.nio.charset.Charset;
import java.util.Map;
import javax.inject.Inject;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalTypes;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public class DefaultAvroExtension
implements AvroExtension {
    private final Property<String> outputCharacterEncoding;
    private final Property<String> stringType;
    private final Property<String> fieldVisibility;
    private final Property<String> templateDirectory;
    private final Property<Boolean> createSetters;
    private final Property<Boolean> createOptionalGetters;
    private final Property<Boolean> gettersReturnOptional;
    private final Property<Boolean> enableDecimalLogicalType;
    private final Property<String> dateTimeLogicalType;
    private final MapProperty<String, Class<? extends LogicalTypes.LogicalTypeFactory>> logicalTypeFactories;
    private final ListProperty<Class<? extends Conversion<?>>> customConversions;

    @Inject
    public DefaultAvroExtension(ObjectFactory objects) {
        this.outputCharacterEncoding = objects.property(String.class);
        this.stringType = objects.property(String.class).convention((Object)Constants.DEFAULT_STRING_TYPE);
        this.fieldVisibility = objects.property(String.class).convention((Object)Constants.DEFAULT_FIELD_VISIBILITY);
        this.templateDirectory = objects.property(String.class);
        this.createSetters = objects.property(Boolean.class).convention((Object)true);
        this.createOptionalGetters = objects.property(Boolean.class).convention((Object)false);
        this.gettersReturnOptional = objects.property(Boolean.class).convention((Object)false);
        this.enableDecimalLogicalType = objects.property(Boolean.class).convention((Object)true);
        this.dateTimeLogicalType = objects.property(String.class).convention((Object)Constants.DEFAULT_DATE_TIME_LOGICAL_TYPE);
        this.logicalTypeFactories = objects.mapProperty(String.class, Constants.LOGICAL_TYPE_FACTORY_TYPE.getConcreteClass()).convention(Constants.DEFAULT_LOGICAL_TYPE_FACTORIES);
        this.customConversions = objects.listProperty(Constants.CONVERSION_TYPE.getConcreteClass()).convention(Constants.DEFAULT_CUSTOM_CONVERSIONS);
    }

    @Override
    public Property<String> getOutputCharacterEncoding() {
        return this.outputCharacterEncoding;
    }

    public void setOutputCharacterEncoding(String outputCharacterEncoding) {
        this.outputCharacterEncoding.set((Object)outputCharacterEncoding);
    }

    public void setOutputCharacterEncoding(Charset outputCharacterEncoding) {
        this.setOutputCharacterEncoding(outputCharacterEncoding.name());
    }

    @Override
    public Property<String> getStringType() {
        return this.stringType;
    }

    public void setStringType(String stringType) {
        this.stringType.set((Object)stringType);
    }

    public void setStringType(GenericData.StringType stringType) {
        this.setStringType(stringType.name());
    }

    @Override
    public Property<String> getFieldVisibility() {
        return this.fieldVisibility;
    }

    public void setFieldVisibility(String fieldVisibility) {
        this.fieldVisibility.set((Object)fieldVisibility);
    }

    public void setFieldVisibility(SpecificCompiler.FieldVisibility fieldVisibility) {
        this.setFieldVisibility(fieldVisibility.name());
    }

    @Override
    public Property<String> getTemplateDirectory() {
        return this.templateDirectory;
    }

    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory.set((Object)templateDirectory);
    }

    @Override
    public Property<Boolean> isCreateSetters() {
        return this.createSetters;
    }

    public void setCreateSetters(String createSetters) {
        this.setCreateSetters(Boolean.parseBoolean(createSetters));
    }

    public void setCreateSetters(boolean createSetters) {
        this.createSetters.set((Object)createSetters);
    }

    @Override
    public Property<Boolean> isCreateOptionalGetters() {
        return this.createOptionalGetters;
    }

    public void setCreateOptionalGetters(String createOptionalGetters) {
        this.setCreateOptionalGetters(Boolean.parseBoolean(createOptionalGetters));
    }

    public void setCreateOptionalGetters(boolean createOptionalGetters) {
        this.createOptionalGetters.set((Object)createOptionalGetters);
    }

    @Override
    public Property<Boolean> isGettersReturnOptional() {
        return this.gettersReturnOptional;
    }

    public void setGettersReturnOptional(String gettersReturnOptional) {
        this.setGettersReturnOptional(Boolean.parseBoolean(gettersReturnOptional));
    }

    public void setGettersReturnOptional(boolean gettersReturnOptional) {
        this.gettersReturnOptional.set((Object)gettersReturnOptional);
    }

    @Override
    public Property<Boolean> isEnableDecimalLogicalType() {
        return this.enableDecimalLogicalType;
    }

    public void setEnableDecimalLogicalType(String enableDecimalLogicalType) {
        this.setEnableDecimalLogicalType(Boolean.parseBoolean(enableDecimalLogicalType));
    }

    public void setEnableDecimalLogicalType(boolean enableDecimalLogicalType) {
        this.enableDecimalLogicalType.set((Object)enableDecimalLogicalType);
    }

    @Override
    public Property<String> getDateTimeLogicalType() {
        return this.dateTimeLogicalType;
    }

    public void setDateTimeLogicalType(String dateTimeLogicalType) {
        this.dateTimeLogicalType.set((Object)dateTimeLogicalType);
    }

    public void setDateTimeLogicalType(SpecificCompiler.DateTimeLogicalTypeImplementation dateTimeLogicalType) {
        this.setDateTimeLogicalType(dateTimeLogicalType.name());
    }

    @Override
    public MapProperty<String, Class<? extends LogicalTypes.LogicalTypeFactory>> getLogicalTypeFactories() {
        return this.logicalTypeFactories;
    }

    public void setLogicalTypeFactories(Provider<? extends Map<? extends String, ? extends Class<? extends LogicalTypes.LogicalTypeFactory>>> provider) {
        this.logicalTypeFactories.set(provider);
    }

    public void setLogicalTypeFactories(Map<? extends String, ? extends Class<? extends LogicalTypes.LogicalTypeFactory>> logicalTypeFactories) {
        this.logicalTypeFactories.set(logicalTypeFactories);
    }

    @Override
    public ListProperty<Class<? extends Conversion<?>>> getCustomConversions() {
        return this.customConversions;
    }

    public void setCustomConversions(Provider<Iterable<Class<? extends Conversion<?>>>> provider) {
        this.customConversions.set(provider);
    }

    public void setCustomConversions(Iterable<Class<? extends Conversion<?>>> customConversions) {
        this.customConversions.set(customConversions);
    }

    @Override
    public AvroExtension logicalTypeFactory(String typeName, Class<? extends LogicalTypes.LogicalTypeFactory> typeFactoryClass) {
        this.logicalTypeFactories.put((Object)typeName, typeFactoryClass);
        return this;
    }

    @Override
    public AvroExtension customConversion(Class<? extends Conversion<?>> conversionClass) {
        this.customConversions.add(conversionClass);
        return this;
    }
}

