/*
 * Decompiled with CFR 0.152.
 */
package com.commercehub.gradle.plugin.avro;

import com.commercehub.gradle.plugin.avro.FileState;
import com.commercehub.gradle.plugin.avro.TypeState;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.avro.Schema;
import org.gradle.api.Project;

class ProcessingState {
    private final Map<String, TypeState> typeStates = new HashMap<String, TypeState>();
    private final Set<FileState> delayedFiles = new LinkedHashSet<FileState>();
    private final Queue<FileState> filesToProcess = new LinkedList<FileState>();
    private int processedTotal = 0;

    ProcessingState(Set<File> files, Project project) {
        for (File file : files) {
            this.filesToProcess.add(new FileState(file, project.relativePath((Object)file)));
        }
    }

    Map<String, Schema> determineParserTypes(FileState fileState) {
        Set<String> duplicateTypeNames = fileState.getDuplicateTypeNames();
        HashMap<String, Schema> types = new HashMap<String, Schema>();
        for (TypeState typeState : this.typeStates.values()) {
            String typeName = typeState.getName();
            if (duplicateTypeNames.contains(typeName)) continue;
            types.put(typeState.getName(), typeState.getSchema());
        }
        return types;
    }

    void processTypeDefinitions(FileState fileState, Map<String, Schema> newTypes) {
        String path = fileState.getPath();
        for (Map.Entry<String, Schema> entry : newTypes.entrySet()) {
            String typeName = entry.getKey();
            Schema schema = entry.getValue();
            this.getTypeState(typeName).processTypeDefinition(path, schema);
        }
        fileState.clearError();
        ++this.processedTotal;
        this.queueDelayedFilesForProcessing();
    }

    Set<FileState> getFailedFiles() {
        return this.delayedFiles;
    }

    TypeState getTypeState(String typeName) {
        TypeState typeState = this.typeStates.get(typeName);
        if (typeState == null) {
            typeState = new TypeState(typeName);
            this.typeStates.put(typeName, typeState);
        }
        return typeState;
    }

    void queueForProcessing(FileState fileState) {
        this.filesToProcess.add(fileState);
    }

    void queueForDelayedProcessing(FileState fileState) {
        this.delayedFiles.add(fileState);
    }

    private void queueDelayedFilesForProcessing() {
        this.filesToProcess.addAll(this.delayedFiles);
        this.delayedFiles.clear();
    }

    FileState nextFileState() {
        return this.filesToProcess.poll();
    }

    boolean isWorkRemaining() {
        return !this.filesToProcess.isEmpty();
    }

    int getProcessedTotal() {
        return this.processedTotal;
    }
}

