/*
 * Decompiled with CFR 0.152.
 */
package com.sleepbot.datetimepicker.canvassaveproxy;

import android.graphics.Canvas;
import android.util.Log;
import com.sleepbot.datetimepicker.canvassaveproxy.CanvasSaveProxy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LegacyCanvasSaveProxy
implements CanvasSaveProxy {
    private static final String TAG = CanvasSaveProxy.class.getSimpleName();
    private static final String METHOD_NAME = "save";
    private static final String FIELD_NAME = "CLIP_SAVE_FLAG";
    private final Canvas mCanvas;
    private final Method mSaveMethod;
    private final int mClipSaveFlag;

    LegacyCanvasSaveProxy(Canvas canvas) {
        Log.d((String)TAG, (String)"New LegacyCanvasSaveProxy");
        this.mCanvas = canvas;
        this.mSaveMethod = this.findSaveMethod();
        this.mClipSaveFlag = this.getClipSaveFlagValue();
    }

    @Override
    public int save() {
        return this.invokeSave();
    }

    @Override
    public boolean isFor(Canvas canvas) {
        return canvas == this.mCanvas;
    }

    private int getClipSaveFlagValue() {
        try {
            Field constantField = Canvas.class.getDeclaredField(FIELD_NAME);
            return (Integer)constantField.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Failed to get value of CLIP_SAVE_FLAG - NoSuchFieldException", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to get value of CLIP_SAVE_FLAG - IllegalAccessException", e);
        }
    }

    private Method findSaveMethod() {
        try {
            return Canvas.class.getMethod(METHOD_NAME, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Canvas does not contain a method with signature save(int)");
        }
    }

    private int invokeSave() {
        try {
            return (Integer)this.mSaveMethod.invoke((Object)this.mCanvas, this.mClipSaveFlag);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to execute save(int) - IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Failed to execute save(int) - InvocationTargetException", e);
        }
    }
}

