/*
 * Decompiled with CFR 0.152.
 */
package com.fourmob.datetimepicker.date;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.fourmob.datetimepicker.Utils;
import com.fourmob.datetimepicker.date.CalendarDay;
import com.fourmob.datetimepicker.date.DayPickerView;
import com.fourmob.datetimepicker.date.SimpleMonthView;
import java.util.HashMap;
import java.util.Stack;

public class SimpleMonthPagerAdapter
extends PagerAdapter
implements SimpleMonthView.OnDayClickListener {
    private static final String TAG = "SimpleMonthAdapter";
    private CalendarDay mSelectedDay;
    private int mTotalMonths;
    private HashMap<String, SimpleMonthView> mCurrentViews;
    private Stack<SimpleMonthView> mRecycledViewsList;
    private DayPickerView.DayPickerParams mParams;
    private MonthPagerListener mListener;

    public SimpleMonthPagerAdapter(DayPickerView.DayPickerParams params) {
        this.updateParams(params, false);
        this.mCurrentViews = new HashMap();
        this.mRecycledViewsList = new Stack();
    }

    private boolean isDayInMonth(CalendarDay date, int year, int month) {
        return date.year == year && date.month == month;
    }

    public int getCount() {
        return this.mTotalMonths;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    private SimpleMonthView createOrRecycleMonthView(Context context) {
        SimpleMonthView monthView;
        if (this.mRecycledViewsList.isEmpty()) {
            monthView = new SimpleMonthView(context);
            monthView.setOnDayClickListener(this);
        } else {
            monthView = this.mRecycledViewsList.pop();
        }
        return monthView;
    }

    public void updateParams(DayPickerView.DayPickerParams params, boolean invalidate) {
        this.mParams = params;
        this.mSelectedDay = this.mParams.selectedDate;
        this.mTotalMonths = Utils.getMonthsBetweenDates(this.mParams.minDate.month, this.mParams.minDate.year, this.mParams.maxDate.month, this.mParams.maxDate.year);
        if (invalidate) {
            this.notifyDataSetChanged();
        }
    }

    public Object instantiateItem(ViewGroup container, int position) {
        SimpleMonthView monthView = this.createOrRecycleMonthView(container.getContext());
        int firstMonth = this.mParams.minDate.month;
        int month = (position + firstMonth) % 12;
        int year = (position + firstMonth) / 12 + this.mParams.minDate.year;
        int selectedDay = -1;
        if (this.isDayInMonth(this.mSelectedDay, year, month)) {
            selectedDay = this.mSelectedDay.day;
        }
        monthView.reuse();
        this.updateMonthViewParams(monthView, selectedDay, month, year);
        container.addView((View)monthView);
        this.mCurrentViews.put(this.createViewKey(month, year), monthView);
        return monthView;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        SimpleMonthView recycledView = (SimpleMonthView)((Object)object);
        container.removeView((View)recycledView);
        this.mCurrentViews.remove(this.createViewKey(recycledView.getMonth(), recycledView.getYear()));
        this.mRecycledViewsList.push(recycledView);
    }

    private void updateMonthViewParams(SimpleMonthView monthView, int selectedDay, int month, int year) {
        HashMap<String, Integer> drawingParams = new HashMap<String, Integer>();
        drawingParams.put("selected_day", selectedDay);
        drawingParams.put("year", year);
        drawingParams.put("month", month);
        drawingParams.put("week_start", this.mParams.firstDayOfWeek);
        CalendarDay minDate = this.mParams.minDate;
        drawingParams.put("minDateDay", minDate.day);
        drawingParams.put("minDateMonth", minDate.month);
        drawingParams.put("minDateYear", minDate.year);
        CalendarDay maxDate = this.mParams.maxDate;
        drawingParams.put("maxDateDay", maxDate.day);
        drawingParams.put("maxDateMonth", maxDate.month);
        drawingParams.put("maxDateYear", maxDate.year);
        monthView.setMonthParams(drawingParams);
        monthView.invalidate();
    }

    private String createViewKey(int month, int year) {
        return month + "." + year;
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    @Override
    public void onDayClick(SimpleMonthView simpleMonthView, CalendarDay calendarDay) {
        if (calendarDay != null) {
            CalendarDay minDate = this.mParams.minDate;
            CalendarDay maxDate = this.mParams.maxDate;
            if ((calendarDay.isAfter(minDate) || calendarDay.equals(minDate)) && (calendarDay.isBefore(maxDate) || calendarDay.equals(maxDate))) {
                this.onDayTapped(calendarDay);
            } else {
                Log.i((String)TAG, (String)"ignoring push since day is after minDate or before maxDate");
            }
        }
    }

    protected void onDayTapped(CalendarDay calendarDay) {
        this.setSelectedDayInternal(calendarDay);
        if (this.mListener != null) {
            this.mListener.onDateSelected(calendarDay.year, calendarDay.month, calendarDay.day);
        }
    }

    private void setSelectedDayInternal(CalendarDay calendarDay) {
        this.mSelectedDay = calendarDay;
        for (String key : this.mCurrentViews.keySet()) {
            if (key.equals(this.createViewKey(calendarDay.month, calendarDay.year))) continue;
            this.mCurrentViews.get(key).clearSelection();
        }
    }

    public void setListener(MonthPagerListener listener) {
        this.mListener = listener;
    }

    public static interface MonthPagerListener {
        public void onDateSelected(int var1, int var2, int var3);
    }
}

