/*
 * Decompiled with CFR 0.152.
 */
package com.fourmob.datetimepicker.date;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CalendarDay
implements Parcelable {
    private Calendar calendar;
    public final int day;
    public final int month;
    public final int year;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public CalendarDay createFromParcel(Parcel in) {
            return new CalendarDay(in);
        }

        public CalendarDay[] newArray(int size) {
            return new CalendarDay[size];
        }
    };

    public CalendarDay() {
        this(System.currentTimeMillis());
    }

    public CalendarDay(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public CalendarDay(long timeInMillis) {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.setTimeInMillis(timeInMillis);
        this.month = this.calendar.get(2);
        this.year = this.calendar.get(1);
        this.day = this.calendar.get(5);
    }

    public CalendarDay(Calendar calendar) {
        this.year = calendar.get(1);
        this.month = calendar.get(2);
        this.day = calendar.get(5);
    }

    private CalendarDay(Parcel in) {
        this.year = in.readInt();
        this.month = in.readInt();
        this.day = in.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.year);
        dest.writeInt(this.month);
        dest.writeInt(this.day);
    }

    public boolean equals(CalendarDay o) {
        return o.year == this.year && o.day == this.day && o.month == this.month;
    }

    public boolean isAfter(CalendarDay day) {
        return this.convertToDate(this).after(this.convertToDate(day));
    }

    public boolean isBefore(CalendarDay day) {
        return this.convertToDate(this).before(this.convertToDate(day));
    }

    public Date convertToDate(CalendarDay day) {
        Date utilDate = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
            utilDate = formatter.parse(day.year + "/" + day.month + "/" + day.day);
        }
        catch (ParseException e) {
            Log.e((String)"SimpleMonthAdapter", (String)"error while converting", (Throwable)e);
        }
        return utilDate;
    }
}

