/*
 * Decompiled with CFR 0.152.
 */
package com.coherentlogic.coherent.data.model.core.util;

import com.coherentlogic.coherent.data.model.core.util.Action;
import java.io.IOException;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Utils {
    public static final String GMT_MINUS_6 = "GMT-6";
    public static final TimeZone GMT_MINUS_6_TIMEZONE = TimeZone.getTimeZone("GMT-6");
    public static final Calendar TODAY = GregorianCalendar.getInstance(GMT_MINUS_6_TIMEZONE);

    public static Date using(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance(GMT_MINUS_6_TIMEZONE);
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        return calendar.getTime();
    }

    public static void forEachChild(Element targetElement, String tagName, Action<Element> action) {
        List children = null;
        if (targetElement != null && targetElement.hasChildNodes()) {
            children = DomUtils.getChildElementsByTagName((Element)targetElement, (String)tagName);
        }
        if (children != null) {
            for (Element next : children) {
                action.execute(next);
            }
        }
    }

    public static Document toDocument(String xml) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource source = new InputSource(new StringReader(xml));
        return builder.parse(source);
    }

    public static Object assertNotNull(String variableName, Object value) {
        if (value == null) {
            throw new NullPointerException("The variable named " + variableName + " is null.");
        }
        return value;
    }
}

