/*
 * Decompiled with CFR 0.152.
 */
package com.coherentlogic.coherent.data.model.core.domain;

import com.coherentlogic.coherent.data.model.core.command.CommandExecutorSpecification;
import com.coherentlogic.coherent.data.model.core.domain.AcceptorSpecification;
import com.coherentlogic.coherent.data.model.core.exceptions.CloneFailedException;
import com.coherentlogic.coherent.data.model.core.listeners.AggregatePropertyChangeEvent;
import com.coherentlogic.coherent.data.model.core.listeners.AggregatePropertyChangeListener;
import com.coherentlogic.coherent.data.model.core.strategies.DefaultTraversalStrategy;
import com.coherentlogic.coherent.data.model.core.strategies.TraversalStrategySpecification;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@MappedSuperclass
public class SerializableBean
implements Serializable,
Cloneable,
AcceptorSpecification,
CommandExecutorSpecification {
    private static final long serialVersionUID = 3557664417023869095L;
    public static final String SERIALIZABLE_BEAN = "serializable_bean";
    public static final String PRIMARY_KEY = "primaryKey";
    public static final String CREATED_TIME_MILLIS = "createdTimeMillis";
    public static final String CREATED_DATE = "createdDate";
    public static final String UPDATED_DATE = "updatedDate";
    public static final String VERSION = "version";
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long primaryKey = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="createdDate", nullable=false)
    private Date createdDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="updatedDate", nullable=false)
    private Date updatedDate;
    @Version
    @Column(name="optlock", columnDefinition="integer DEFAULT 0", nullable=false)
    @XStreamOmitField
    private long version = 0L;
    @Transient
    @XStreamOmitField
    private final transient VetoableChangeSupport vetoableChangeSupport;
    @Transient
    @XStreamOmitField
    public final transient PropertyChangeSupport propertyChangeSupport;
    @Transient
    @XStreamOmitField
    public final transient List<AggregatePropertyChangeListener<SerializableBean>> aggregatePropertyChangeListeners;

    static PropertyChangeSupport createDefaultPropertyChangeSupport(SerializableBean serializableBean) {
        return new PropertyChangeSupport(serializableBean);
    }

    public SerializableBean() {
        this.propertyChangeSupport = SerializableBean.createDefaultPropertyChangeSupport(this);
        this.vetoableChangeSupport = new VetoableChangeSupport(this);
        this.aggregatePropertyChangeListeners = new ArrayList<AggregatePropertyChangeListener<SerializableBean>>();
    }

    public SerializableBean(PropertyChangeSupport propertyChangeSupport, VetoableChangeSupport vetoableChangeSupport, List<AggregatePropertyChangeListener<SerializableBean>> aggregatePropertyChangeListeners) {
        this.propertyChangeSupport = propertyChangeSupport;
        this.vetoableChangeSupport = vetoableChangeSupport;
        this.aggregatePropertyChangeListeners = aggregatePropertyChangeListeners;
    }

    @PrePersist
    protected void onCreate() {
        this.createdDate = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.updatedDate = new Date();
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        Date oldValue = this.createdDate;
        this.createdDate = createdDate;
        this.firePropertyChange(CREATED_DATE, oldValue, createdDate);
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        Date oldValue = this.updatedDate;
        this.updatedDate = updatedDate;
        this.firePropertyChange(UPDATED_DATE, oldValue, updatedDate);
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        long oldValue = this.version;
        this.version = version;
        this.firePropertyChange(VERSION, oldValue, version);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.TABLE)
    public Long getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(Long primaryKey) {
        Long oldValue = this.primaryKey;
        this.primaryKey = primaryKey;
        this.firePropertyChange(PRIMARY_KEY, oldValue, primaryKey);
    }

    protected static Date clone(Date date) {
        Date newDate = null;
        if (date != null) {
            newDate = (Date)date.clone();
        }
        return newDate;
    }

    public <X> X clone(Class<X> type) {
        Object object = this.clone();
        X result = type.cast(object);
        return result;
    }

    public Object clone() {
        try {
            return BeanUtils.cloneBean((Object)this);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CloneFailedException("Illegal access exception thrown", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new CloneFailedException("Failed to instantiate the class.", instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CloneFailedException("Invocation target exception thrown.", invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CloneFailedException("No such method exception thrown.", noSuchMethodException);
        }
    }

    @Transient
    public VetoableChangeSupport getVetoableChangeSupport() {
        return this.vetoableChangeSupport;
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport.removeVetoableChangeListener(listener);
    }

    @Transient
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    static boolean propertiesDiffer(Object oldValue, Object newValue) {
        boolean result = false;
        if (oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) {
            result = true;
        }
        return result;
    }

    protected boolean propertiesDiffer(int oldValue, int newValue) {
        boolean result = false;
        if (oldValue != newValue) {
            result = true;
        }
        return result;
    }

    protected boolean propertiesDiffer(boolean oldValue, boolean newValue) {
        boolean result = false;
        if (oldValue != newValue) {
            result = true;
        }
        return result;
    }

    protected SerializableBean firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        return this.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
    }

    protected SerializableBean firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        return this.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
    }

    protected SerializableBean firePropertyChange(String propertyName, int oldValue, int newValue) {
        return this.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
    }

    protected SerializableBean firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SerializableBean.propertiesDiffer(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue())) {
            this.propertyChangeSupport.firePropertyChange(propertyChangeEvent);
        }
        return this;
    }

    protected SerializableBean fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.propertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        return this;
    }

    protected SerializableBean fireIndexedPropertyChange(String propertyName, int index, int oldValue, int newValue) {
        this.propertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        return this;
    }

    protected SerializableBean fireIndexedPropertyChange(String propertyName, int index, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        return this;
    }

    protected SerializableBean fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        this.vetoableChangeSupport.fireVetoableChange(propertyName, oldValue, newValue);
        return this;
    }

    protected SerializableBean fireVetoableChange(String propertyName, boolean oldValue, boolean newValue) throws PropertyVetoException {
        this.vetoableChangeSupport.fireVetoableChange(propertyName, oldValue, newValue);
        return this;
    }

    protected SerializableBean fireVetoableChange(String propertyName, int oldValue, int newValue) throws PropertyVetoException {
        this.vetoableChangeSupport.fireVetoableChange(propertyName, oldValue, newValue);
        return this;
    }

    protected SerializableBean fireVetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        this.vetoableChangeSupport.fireVetoableChange(propertyChangeEvent);
        return this;
    }

    @Transient
    public List<AggregatePropertyChangeListener<SerializableBean>> getAggregatePropertyChangeListeners() {
        return this.aggregatePropertyChangeListeners;
    }

    public void addAggregatePropertyChangeListener(AggregatePropertyChangeListener<SerializableBean> aggregatePropertyChangeListener) {
        this.aggregatePropertyChangeListeners.add(aggregatePropertyChangeListener);
    }

    public boolean removeAggregatePropertyChangeListener(AggregatePropertyChangeListener<? extends SerializableBean> aggregatePropertyChangeListener) {
        return this.aggregatePropertyChangeListeners.remove(aggregatePropertyChangeListener);
    }

    public SerializableBean fireAggregatePropertyChangeEvent(AggregatePropertyChangeEvent<SerializableBean> aggregatePropertyChangeEvent) {
        for (AggregatePropertyChangeListener<SerializableBean> aggregatePropertyChangeListener : this.aggregatePropertyChangeListeners) {
            aggregatePropertyChangeListener.onAggregatePropertyChangeEvent(aggregatePropertyChangeEvent);
        }
        return this;
    }

    public boolean equals(Object target) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)target, (String[])new String[]{CREATED_TIME_MILLIS});
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public void accept(TraversalStrategySpecification traversalStrategy, Consumer<SerializableBean> ... visitors) {
        this.accept(traversalStrategy, Arrays.asList(visitors));
    }

    @Override
    public void accept(TraversalStrategySpecification traversalStrategy, Collection<Consumer<SerializableBean>> visitors) {
        traversalStrategy.execute(this, visitors);
    }

    @Override
    public void accept(Consumer<SerializableBean> ... visitors) {
        this.accept(Arrays.asList(visitors));
    }

    @Override
    public void accept(Collection<Consumer<SerializableBean>> visitors) {
        this.accept((TraversalStrategySpecification)new DefaultTraversalStrategy(), visitors);
    }

    @Override
    public <S extends SerializableBean> void invoke(Consumer<S> consumer) {
        consumer.accept(this);
    }
}

