/*
 * Decompiled with CFR 0.152.
 */
package com.coherentlogic.coherent.data.model.core.domain;

import com.coherentlogic.coherent.data.model.core.annotations.Changeable;
import com.coherentlogic.coherent.data.model.core.domain.SerializableBean;
import com.coherentlogic.coherent.data.model.core.exceptions.MisconfiguredException;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyChangeEventGeneratorMethodInterceptor<T>
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PropertyChangeEventGeneratorMethodInterceptor.class);
    static final String FIRE_PROPERTY_CHANGE = "firePropertyChange";
    private final Class<T> targetClass;
    private final Method firePropertyChangeMethod;

    public PropertyChangeEventGeneratorMethodInterceptor(Class<T> targetClass) {
        this.targetClass = targetClass;
        try {
            this.firePropertyChangeMethod = SerializableBean.class.getDeclaredMethod(FIRE_PROPERTY_CHANGE, PropertyChangeEvent.class);
        }
        catch (Exception e) {
            throw new RuntimeException("An exception was thrown when attempting to get the method named firePropertyChange.", e);
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object targetObject = invocation.getThis();
        SerializableBean target = this.asSerializableBean(targetObject);
        Method method = invocation.getMethod();
        int parameterCount = method.getParameterCount();
        Object result = null;
        if (parameterCount == 1) {
            Parameter[] parameters = method.getParameters();
            Parameter parameter = parameters[0];
            if (parameter.isAnnotationPresent(Changeable.class)) {
                Changeable changeable = parameter.getAnnotation(Changeable.class);
                String parameterName = changeable.value();
                if ("".equals(parameterName)) {
                    throw new MisconfiguredException("The changeable.value (parameterName) cannot be blank.");
                }
                Field field = this.targetClass.getDeclaredField(parameterName);
                log.debug("parameterName: " + parameterName + ", field: " + field.getName());
                this.doSetAndFireUpdate(invocation, target, field, targetObject, parameterName);
            } else {
                log.debug("The method " + method + " exists and has one parameter however the parameter has not been annotated with the " + Changeable.class + " annotation, hence no PropertyChangeEvents will be fired unless the code has been manually added to the method.");
                result = invocation.proceed();
            }
        } else {
            log.debug("The method " + method + " exists and has either zero or more than one parameter so no PropertyChangeEvents will be fired unless the code has been manually added to the method.");
            result = invocation.proceed();
        }
        return result;
    }

    SerializableBean asSerializableBean(Object targetObject) {
        SerializableBean result = null;
        if (targetObject == null || !(targetObject instanceof SerializableBean)) {
            if (targetObject == null) {
                throw new NullPointerException("The targetObject is null.");
            }
            throw new MisconfiguredException("The bean must extend SerializableBean; targetObject class: " + targetObject.getClass());
        }
        result = (SerializableBean)targetObject;
        return result;
    }

    Object doSetAndFireUpdate(MethodInvocation invocation, SerializableBean target, Field field, Object targetObject, String parameterName) throws Throwable {
        field.setAccessible(true);
        Object oldValue = field.get(targetObject);
        Object result = invocation.proceed();
        Object newValue = field.get(targetObject);
        log.debug("oldValue: " + oldValue + ", newValue: " + newValue);
        field.setAccessible(false);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(target, parameterName, oldValue, newValue);
        this.firePropertyChangeMethod.invoke((Object)target, propertyChangeEvent);
        return result;
    }
}

