/*
 * Decompiled with CFR 0.152.
 */
package com.coherentlogic.coherent.data.model.core.annotations;

import com.coherentlogic.coherent.data.model.core.annotations.Visitable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
@Scope(value="prototype")
public class VisitableAnnotationProcessor {
    private static final Logger log = LoggerFactory.getLogger(VisitableAnnotationProcessor.class);
    private final Map<Class<?>, Set<Field>> fieldsMap = new HashMap();

    protected Map<Class<?>, Set<Field>> getFieldsMap() {
        return this.fieldsMap;
    }

    public VisitableAnnotationProcessor register(String packageName) {
        this.register(Visitable.class, packageName);
        return this;
    }

    protected void register(Class<? extends Annotation> annotation, String packageName) {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set annotatedClasses = reflections.getTypesAnnotatedWith(annotation);
        annotatedClasses.forEach(annotatedClass -> this.register(annotation, (Class<?>)annotatedClass));
    }

    protected void register(Class<? extends Annotation> annotation, Class<?> ... targets) {
        this.register(annotation, Arrays.asList(targets));
    }

    protected void register(Class<? extends Annotation> annotation, List<Class<?>> targets) {
        targets.forEach(target -> {
            log.debug("Registering the target: " + target);
            if (target != null) {
                final HashSet fields = new HashSet();
                ReflectionUtils.doWithFields((Class)target, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                    public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                        log.debug("Adding the field: " + field);
                        fields.add(field);
                    }
                }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

                    public boolean matches(Field field) {
                        return field.isAnnotationPresent(Visitable.class);
                    }
                });
                this.fieldsMap.put((Class<?>)target, fields);
            }
        });
    }

    public Set<Field> getFieldsFor(Class<?> target) {
        return this.fieldsMap.get(target);
    }
}

