/*
 * Decompiled with CFR 0.152.
 */
package com.coherentlogic.coherent.data.adapter.core.util;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WelcomeMessage {
    private static final Logger log = LoggerFactory.getLogger(WelcomeMessage.class);
    private final List<String> text;
    public static final String IGNORE_WELCOME_MESSAGE_FLAG = "ignoreWelcomeMessageFlag";
    private final Boolean ignoreWelcomeMessageFlag;

    public WelcomeMessage() {
        this(new ArrayList<String>());
    }

    public WelcomeMessage(List<String> text) {
        this.text = text;
        String flag = System.getProperty(IGNORE_WELCOME_MESSAGE_FLAG);
        this.ignoreWelcomeMessageFlag = flag != null ? Boolean.valueOf(flag) : Boolean.FALSE;
    }

    public WelcomeMessage addText(String ... text) {
        for (String next : text) {
            this.text.add(next);
        }
        return this;
    }

    public List<String> getText() {
        return this.text;
    }

    public WelcomeMessage display() {
        this.text.forEach(next -> log.info(next));
        this.text.forEach(next -> {
            if (!this.ignoreWelcomeMessageFlag.booleanValue()) {
                System.out.println((String)next);
            }
        });
        return this;
    }

    public String toString() {
        return "WelcomeMessage [text=" + this.text + "]";
    }

    public static void main(String[] unused) {
        System.setProperty(IGNORE_WELCOME_MESSAGE_FLAG, "false");
        new WelcomeMessage().addText("********************************************************************************").addText("*** All work and no play makes Jack a dull boy.                              ***").addText("********************************************************************************").display();
    }
}

