/*
 * Decompiled with CFR 0.152.
 */
package com.coherentlogic.coherent.data.adapter.core.services;

import com.coherentlogic.coherent.data.adapter.core.exceptions.GenericReflectionException;
import com.coherentlogic.coherent.data.adapter.core.exceptions.InvalidConfigurationException;
import com.coherentlogic.coherent.data.model.core.annotations.Visitable;
import com.coherentlogic.coherent.data.model.core.domain.SerializableBean;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.springframework.util.ReflectionUtils;

public class BeanTraversalService<R> {
    private Map<Class<?>, Set<Field>> fieldsMap = new HashMap();

    public BeanTraversalService<R> register(Class<SerializableBean> ... targets) {
        return this.register(Arrays.asList(targets));
    }

    public BeanTraversalService<R> register(List<Class<SerializableBean>> targets) {
        targets.forEach(target -> {
            if (target == null || !SerializableBean.class.isAssignableFrom((Class<?>)target)) {
                throw new InvalidConfigurationException("The target " + target + " must be non-null and of type SerializableBean.");
            }
            final HashSet fields = new HashSet();
            ReflectionUtils.doWithFields((Class)target, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    fields.add(field);
                }
            }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

                public boolean matches(Field field) {
                    return field.isAnnotationPresent(Visitable.class);
                }
            });
            this.fieldsMap.put((Class<?>)target, fields);
        });
        return this;
    }

    public BeanTraversalService<R> forEach(FieldConsumer fieldConsumer, SerializableBean ... serializableBeans) {
        return this.forEach(fieldConsumer, Arrays.asList(serializableBeans));
    }

    public BeanTraversalService<R> forEach(FieldConsumer fieldConsumer, List<SerializableBean> serializableBeans) {
        Optional.of(serializableBeans).ifPresent(innerItems -> innerItems.forEach(serializableBean -> this.forEach(fieldConsumer, (SerializableBean)serializableBean, this.fieldsMap)));
        return this;
    }

    private BeanTraversalService<R> forEach(FieldConsumer fieldConsumer, SerializableBean serializableBean, Map<Class<?>, Set<Field>> fieldsMap) {
        Optional.of(serializableBean).ifPresent(innerItem -> {
            Set fieldSet = (Set)fieldsMap.get(innerItem.getClass());
            if (fieldSet != null) {
                fieldSet.forEach(field -> this.forEach(fieldConsumer, serializableBean, (Field)field));
            }
        });
        return this;
    }

    private BeanTraversalService<R> forEach(FieldConsumer fieldConsumer, SerializableBean serializableBean, Field field) {
        Optional.of(serializableBean).ifPresent(innerItem -> {
            if (field.getType().equals(List.class)) {
                try {
                    field.setAccessible(true);
                    List listField = (List)field.get(serializableBean);
                    field.setAccessible(false);
                    this.forEach(fieldConsumer, (List<SerializableBean>)listField);
                }
                catch (Exception exception) {
                    throw new GenericReflectionException("An exception was thrown, see details below (field.name: " + field.getName() + ")", exception);
                }
            }
            fieldConsumer.accept(serializableBean, field);
        });
        return this;
    }

    public BeanTraversalService<R> forEach(FieldSetConsumer fieldConsumer, SerializableBean ... serializableBeans) {
        return this.forEach(fieldConsumer, Arrays.asList(serializableBeans));
    }

    public BeanTraversalService<R> forEach(FieldSetConsumer fieldSetConsumer, List<SerializableBean> serializableBeans) {
        Optional.of(serializableBeans).ifPresent(beans -> beans.forEach(serializableBean -> this.forEach(fieldSetConsumer, (SerializableBean)serializableBean, this.fieldsMap)));
        return this;
    }

    private BeanTraversalService<R> forEach(FieldSetConsumer fieldSetConsumer, SerializableBean serializableBean, Map<Class<?>, Set<Field>> fieldsMap) {
        Optional.of(serializableBean).ifPresent(innerItem -> {
            Set fieldSet = (Set)fieldsMap.get(innerItem.getClass());
            fieldSetConsumer.accept(serializableBean, fieldSet);
            fieldSet.forEach(field -> {
                if (field.getType().equals(List.class)) {
                    List serializableBeans;
                    field.setAccessible(true);
                    try {
                        serializableBeans = (List)field.get(serializableBean);
                    }
                    catch (Exception exception) {
                        throw new GenericReflectionException("Unable to get the field with name: " + field.getName(), exception);
                    }
                    this.forEach(fieldSetConsumer, (List<SerializableBean>)serializableBeans);
                    field.setAccessible(false);
                }
            });
        });
        return this;
    }

    public static interface FieldSetConsumer
    extends BiConsumer<SerializableBean, Set<Field>> {
    }

    public static interface FieldConsumer
    extends BiConsumer<SerializableBean, Field> {
    }
}

