/*
 * Decompiled with CFR 0.152.
 */
package com.coherentlogic.coherent.data.adapter.core.command;

import com.coherentlogic.coherent.data.adapter.core.builders.AbstractQueryBuilder;
import com.coherentlogic.coherent.data.adapter.core.command.CommandExecutorSpecification;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultithreadedCommandExecutor
implements CommandExecutorSpecification<String> {
    private static final Logger log = LoggerFactory.getLogger(MultithreadedCommandExecutor.class);
    private final ExecutorService executorService;

    public MultithreadedCommandExecutor(int nThreads) {
        this.executorService = Executors.newFixedThreadPool(nThreads);
    }

    @Override
    public <X extends AbstractQueryBuilder<String>, Y> Future<Y> invoke(final X queryBuilder, final Function<X, Y> function) {
        log.debug("invoke: method begins; currentThread: " + Thread.currentThread() + ", queryBuilder: " + queryBuilder + ", function: " + function);
        Future result = this.executorService.submit(new Callable<Y>(){

            @Override
            public Y call() throws Exception {
                log.debug("call: method begins; currentThread: " + Thread.currentThread() + ", queryBuilder: " + queryBuilder + ", function: " + function);
                Object result = function.apply(queryBuilder);
                log.debug("call: method ends; result: " + result);
                return result;
            }
        });
        log.debug("invoke: method ends; result: " + result);
        return result;
    }
}

