/*
 * Decompiled with CFR 0.152.
 */
package com.coherentlogic.coherent.data.adapter.core.cache;

import com.coherentlogic.coherent.data.adapter.core.cache.CacheServiceProviderSpecification;
import com.coherentlogic.coherent.data.model.core.domain.SerializableBean;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapCompliantCacheServiceProvider<K>
implements CacheServiceProviderSpecification<K> {
    private static final Logger log = LoggerFactory.getLogger(MapCompliantCacheServiceProvider.class);
    private final Map<K, SerializableBean> cache;

    public MapCompliantCacheServiceProvider(Map<K, SerializableBean> cache) {
        this.cache = cache;
    }

    @Override
    public <V extends SerializableBean> V get(K key) {
        log.debug("get: method begins; key: " + key);
        SerializableBean value = this.cache.get(key);
        log.debug("get: method ends; value: " + value);
        return (V)value;
    }

    @Override
    public <V extends SerializableBean> void put(K key, V value) {
        log.debug("put: method begins; key: " + key + ", value: " + value);
        this.cache.put(key, value);
        log.debug("put: method ends.");
    }

    public String toString() {
        return "MapCompliantCacheServiceProvider [cache=" + this.cache + "]";
    }
}

