/*
 * Decompiled with CFR 0.152.
 */
package com.coherentlogic.coherent.data.adapter.core.builders;

import com.coherentlogic.coherent.data.adapter.core.command.CommandExecutorSpecification;
import com.coherentlogic.coherent.data.adapter.core.command.DefaultCommandExecutor;
import com.coherentlogic.coherent.data.adapter.core.exceptions.InvalidConfigurationException;
import com.coherentlogic.coherent.data.adapter.core.listeners.QueryBuilderEvent;
import com.coherentlogic.coherent.data.adapter.core.listeners.QueryBuilderEventListener;
import com.coherentlogic.coherent.data.adapter.core.listeners.QueryBuilderExceptionEvent;
import com.coherentlogic.coherent.data.model.core.domain.SerializableBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueryBuilder<K> {
    private static final Logger log = LoggerFactory.getLogger(AbstractQueryBuilder.class);
    private final List<QueryBuilderEventListener<K>> queryBuilderEventListeners;
    private final CommandExecutorSpecification<K> commandExecutor;

    public AbstractQueryBuilder() {
        this(new ArrayList<QueryBuilderEventListener<K>>(), new DefaultCommandExecutor());
    }

    public AbstractQueryBuilder(List<QueryBuilderEventListener<K>> queryBuilderListeners, CommandExecutorSpecification<K> commandExecutor) {
        this.queryBuilderEventListeners = queryBuilderListeners;
        this.commandExecutor = commandExecutor;
    }

    protected CommandExecutorSpecification<K> getCommandExecutor() {
        return this.commandExecutor;
    }

    public <X extends AbstractQueryBuilder<K>, Y> Future<Y> invoke(Function<X, Y> function) {
        return this.commandExecutor.invoke(this, function);
    }

    public List<QueryBuilderEventListener<K>> getQueryBuilderListeners() {
        return this.queryBuilderEventListeners;
    }

    @SafeVarargs
    public final void addQueryBuilderEventListener(QueryBuilderEventListener<K> ... queryBuilderListeners) {
        this.queryBuilderEventListeners.addAll(Arrays.asList(queryBuilderListeners));
    }

    @SafeVarargs
    public final void removeQueryBuilderEventListener(QueryBuilderEventListener<K> ... queryBuilderListeners) {
        this.queryBuilderEventListeners.removeAll(Arrays.asList(queryBuilderListeners));
    }

    protected <T extends SerializableBean> void fireQueryBuilderEvent(QueryBuilderEvent<K, T> queryBuilderEvent) {
        for (QueryBuilderEventListener<K> queryBuilderListener : this.queryBuilderEventListeners) {
            queryBuilderListener.onEvent(queryBuilderEvent);
        }
    }

    protected <T extends SerializableBean> void fireQueryBuilderEvent(QueryBuilderEvent.EventType eventType, K key, T value, long operationBeganAtMillis, long operationAtThisStepMillis) {
        this.fireQueryBuilderEvent(new QueryBuilderEvent<K, T>(this, eventType, key, value, operationBeganAtMillis, operationAtThisStepMillis));
    }

    protected <T extends SerializableBean> void fireQueryBuilderEvent(QueryBuilderEvent.EventType eventType, K key, T value, Throwable cause, long operationBeganAtMillis, long operationAtThisStepMillis) {
        this.fireQueryBuilderEvent(new QueryBuilderExceptionEvent<K, T>(this, eventType, key, value, cause, operationBeganAtMillis, operationAtThisStepMillis));
    }

    protected <T extends SerializableBean> void fireQueryBuilderEvent(QueryBuilderEvent.EventType eventType, K key, T value, long operationBeganAtMillis) {
        this.fireQueryBuilderEvent(eventType, key, value, operationBeganAtMillis, System.currentTimeMillis());
    }

    protected <T extends SerializableBean> void fireQueryBuilderEvent(K key, T value, Throwable cause, long operationBeganAtMillis) {
        this.fireQueryBuilderEvent(QueryBuilderEvent.EventType.exceptionThrown, key, value, cause, operationBeganAtMillis, System.currentTimeMillis());
    }

    public void accept(Consumer<SerializableBean> visitor, SerializableBean ... serializableBeans) {
        this.accept(Arrays.asList(visitor), Arrays.asList(serializableBeans));
    }

    public void accept(Consumer<SerializableBean> visitorA, Consumer<SerializableBean> visitorB, SerializableBean ... serializableBeans) {
        this.accept(Arrays.asList(visitorA, visitorB), Arrays.asList(serializableBeans));
    }

    public void accept(Consumer<SerializableBean>[] visitors, SerializableBean ... serializableBeans) {
        this.accept(Arrays.asList(visitors), Arrays.asList(serializableBeans));
    }

    public void accept(Collection<Consumer<SerializableBean>> visitors, Collection<SerializableBean> serializableBeans) {
        if (serializableBeans != null) {
            serializableBeans.forEach(serializableBean -> serializableBean.accept(visitors));
        }
    }

    public String getProperty(String key) {
        String result;
        if (log.isDebugEnabled()) {
            log.debug("getProperty: method begins; key: " + key);
        }
        if ((result = System.getProperty(key)) == null) {
            result = this.getProperty(System.getenv(), key);
        }
        if (log.isDebugEnabled()) {
            log.debug("getProperty: method ends; key: " + key + ", result: " + result);
        }
        if (result == null) {
            throw new InvalidConfigurationException("The key " + key + " must point to a non-null value (start the API with -D" + key + "=[some value] or set they key-value-pair in the OS an environment settings).");
        }
        return result;
    }

    String getProperty(Map<String, String> env, String key) {
        if (log.isDebugEnabled()) {
            log.debug("getProperty: method begins; env: " + env + ", key: " + key);
        }
        String result = env.get(key);
        if (log.isDebugEnabled()) {
            log.debug("getProperty: method ends; env: " + env + ", key: " + key + ", result: " + result);
        }
        return result;
    }

    public String toString() {
        return "AbstractQueryBuilder [queryBuilderEventListeners=" + this.queryBuilderEventListeners + ", commandExecutor=" + this.commandExecutor + "]";
    }
}

