package com.coherentlogic.coherent.data.adapter.core.command;

import java.util.concurrent.Future;
import java.util.function.Function;

import com.coherentlogic.coherent.data.adapter.core.builders.AbstractQueryBuilder;

/**
 * Specification for CommandExecutor implementations which allows for commands to be added and executed.
 * 
 * @TODO Only one implementation of this exists at the moment so we may consider removing the interface.
 *
 * @author <a href="https://www.linkedin.com/in/thomasfuller">Thomas P. Fuller</a>
 * @author <a href="mailto:support@coherentlogic.com">Support</a>
 */
public interface CommandExecutorSpecification<K> {

    <X extends AbstractQueryBuilder<K>, Y> Future<Y> invoke(X queryBuilder, Function<X, Y> function);
}
