;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.ivschat.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.ivschat/ID
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ivschat/TagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.ivschat.TagResourceRequest/resourceArn
     :cognitect.aws.ivschat.TagResourceRequest/tags]))

(s/def
  :cognitect.aws.ivschat/GetRoomResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ivschat.GetRoomResponse/maximumMessageRatePerSecond
     :cognitect.aws.ivschat.GetRoomResponse/arn
     :cognitect.aws.ivschat.GetRoomResponse/tags
     :cognitect.aws.ivschat.GetRoomResponse/id
     :cognitect.aws.ivschat.GetRoomResponse/name
     :cognitect.aws.ivschat.GetRoomResponse/createTime
     :cognitect.aws.ivschat.GetRoomResponse/updateTime
     :cognitect.aws.ivschat.GetRoomResponse/maximumMessageLength
     :cognitect.aws.ivschat.GetRoomResponse/messageReviewHandler]))

(s/def
  :cognitect.aws.ivschat/DisconnectUserRequest
  (s/keys
    :req-un
    [:cognitect.aws.ivschat.DisconnectUserRequest/roomIdentifier
     :cognitect.aws.ivschat.DisconnectUserRequest/userId]
    :opt-un
    [:cognitect.aws.ivschat.DisconnectUserRequest/reason]))

(s/def
  :cognitect.aws.ivschat/ChatTokenCapabilities
  (s/coll-of :cognitect.aws.ivschat/ChatTokenCapability))

(s/def
  :cognitect.aws.ivschat/UpdateRoomResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ivschat.UpdateRoomResponse/maximumMessageRatePerSecond
     :cognitect.aws.ivschat.UpdateRoomResponse/arn
     :cognitect.aws.ivschat.UpdateRoomResponse/tags
     :cognitect.aws.ivschat.UpdateRoomResponse/id
     :cognitect.aws.ivschat.UpdateRoomResponse/name
     :cognitect.aws.ivschat.UpdateRoomResponse/createTime
     :cognitect.aws.ivschat.UpdateRoomResponse/updateTime
     :cognitect.aws.ivschat.UpdateRoomResponse/maximumMessageLength
     :cognitect.aws.ivschat.UpdateRoomResponse/messageReviewHandler]))

(s/def :cognitect.aws.ivschat/TagResourceResponse (s/keys))

(s/def
  :cognitect.aws.ivschat/EventName
  (s/spec
    (s/and string? #(<= 1 (count %) 100))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 100) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ivschat/SessionDurationInMinutes
  (s/spec (s/and int? #(<= 1 % 180)) :gen #(gen/choose 1 180)))

(s/def
  :cognitect.aws.ivschat/ChatTokenCapability
  (s/spec string? :gen #(s/gen #{"DELETE_MESSAGE" "SEND_MESSAGE" "DISCONNECT_USER"})))

(s/def
  :cognitect.aws.ivschat/DeleteMessageRequest
  (s/keys
    :req-un
    [:cognitect.aws.ivschat.DeleteMessageRequest/id
     :cognitect.aws.ivschat.DeleteMessageRequest/roomIdentifier]
    :opt-un
    [:cognitect.aws.ivschat.DeleteMessageRequest/reason]))

(s/def
  :cognitect.aws.ivschat/MessageID
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ivschat/RoomName
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9-_]*$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ivschat/DeleteRoomRequest
  (s/keys :req-un [:cognitect.aws.ivschat.DeleteRoomRequest/identifier]))

(s/def
  :cognitect.aws.ivschat/Tags
  (s/map-of
    :cognitect.aws.ivschat/TagKey
    :cognitect.aws.ivschat/TagValue
    :min-count
    0
    :max-count
    50))

(s/def :cognitect.aws.ivschat/ChatToken string?)

(s/def
  :cognitect.aws.ivschat/ChatTokenAttributes
  (s/map-of :cognitect.aws.ivschat/String :cognitect.aws.ivschat/String))

(s/def
  :cognitect.aws.ivschat/RoomIdentifier
  (s/spec
    #(re-matches (re-pattern "^arn:aws:ivschat:[a-z0-9-]+:[0-9]+:room/[a-zA-Z0-9-]+$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.ivschat/SendEventResponse
  (s/keys :opt-un [:cognitect.aws.ivschat.SendEventResponse/id]))

(s/def
  :cognitect.aws.ivschat/Reason
  (s/spec
    (s/and string? #(<= 1 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ivschat/RoomID
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.ivschat/LambdaArn
  (s/spec
    #(re-matches (re-pattern "^$|^arn:aws:lambda:[a-z0-9-]+:[0-9]{12}:function:.+") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.ivschat/EventAttributes
  (s/map-of :cognitect.aws.ivschat/String :cognitect.aws.ivschat/String))

(s/def :cognitect.aws.ivschat/RoomList (s/coll-of :cognitect.aws.ivschat/RoomSummary))

(s/def
  :cognitect.aws.ivschat/CreateRoomRequest
  (s/keys
    :opt-un
    [:cognitect.aws.ivschat.CreateRoomRequest/maximumMessageRatePerSecond
     :cognitect.aws.ivschat.CreateRoomRequest/tags
     :cognitect.aws.ivschat.CreateRoomRequest/name
     :cognitect.aws.ivschat.CreateRoomRequest/maximumMessageLength
     :cognitect.aws.ivschat.CreateRoomRequest/messageReviewHandler]))

(s/def
  :cognitect.aws.ivschat/TagValue
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ivschat/RoomSummary
  (s/keys
    :opt-un
    [:cognitect.aws.ivschat.RoomSummary/arn
     :cognitect.aws.ivschat.RoomSummary/tags
     :cognitect.aws.ivschat.RoomSummary/id
     :cognitect.aws.ivschat.RoomSummary/name
     :cognitect.aws.ivschat.RoomSummary/createTime
     :cognitect.aws.ivschat.RoomSummary/updateTime
     :cognitect.aws.ivschat.RoomSummary/messageReviewHandler]))

(s/def
  :cognitect.aws.ivschat/CreateChatTokenResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ivschat.CreateChatTokenResponse/token
     :cognitect.aws.ivschat.CreateChatTokenResponse/tokenExpirationTime
     :cognitect.aws.ivschat.CreateChatTokenResponse/sessionExpirationTime]))

(s/def
  :cognitect.aws.ivschat/ListTagsForResourceRequest
  (s/keys :req-un [:cognitect.aws.ivschat.ListTagsForResourceRequest/resourceArn]))

(s/def
  :cognitect.aws.ivschat/RoomMaxMessageLength
  (s/spec (s/and int? #(<= 1 % 500)) :gen #(gen/choose 1 500)))

(s/def :cognitect.aws.ivschat/DisconnectUserResponse (s/keys))

(s/def :cognitect.aws.ivschat/UntagResourceResponse (s/keys))

(s/def
  :cognitect.aws.ivschat/ListRoomsRequest
  (s/keys
    :opt-un
    [:cognitect.aws.ivschat.ListRoomsRequest/maxResults
     :cognitect.aws.ivschat.ListRoomsRequest/nextToken
     :cognitect.aws.ivschat.ListRoomsRequest/name
     :cognitect.aws.ivschat.ListRoomsRequest/messageReviewHandlerUri]))

(s/def
  :cognitect.aws.ivschat/MessageReviewHandler
  (s/keys
    :opt-un
    [:cognitect.aws.ivschat.MessageReviewHandler/uri
     :cognitect.aws.ivschat.MessageReviewHandler/fallbackResult]))

(s/def
  :cognitect.aws.ivschat/RoomArn
  (s/spec
    #(re-matches (re-pattern "^arn:aws:ivschat:[a-z0-9-]+:[0-9]+:room/[a-zA-Z0-9-]+$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.ivschat/UserID
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.ivschat/DeleteMessageResponse
  (s/keys :opt-un [:cognitect.aws.ivschat.DeleteMessageResponse/id]))

(s/def
  :cognitect.aws.ivschat/ListRoomsResponse
  (s/keys
    :req-un
    [:cognitect.aws.ivschat.ListRoomsResponse/rooms]
    :opt-un
    [:cognitect.aws.ivschat.ListRoomsResponse/nextToken]))

(s/def
  :cognitect.aws.ivschat/MaxRoomResults
  (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def
  :cognitect.aws.ivschat/UntagResourceRequest
  (s/keys
    :req-un
    [:cognitect.aws.ivschat.UntagResourceRequest/resourceArn
     :cognitect.aws.ivschat.UntagResourceRequest/tagKeys]))

(s/def
  :cognitect.aws.ivschat/TagKey
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.ivschat/Time inst?)

(s/def :cognitect.aws.ivschat/FallbackResult (s/spec string? :gen #(s/gen #{"DENY" "ALLOW"})))

(s/def
  :cognitect.aws.ivschat/SendEventRequest
  (s/keys
    :req-un
    [:cognitect.aws.ivschat.SendEventRequest/eventName
     :cognitect.aws.ivschat.SendEventRequest/roomIdentifier]
    :opt-un
    [:cognitect.aws.ivschat.SendEventRequest/attributes]))

(s/def
  :cognitect.aws.ivschat/ResourceArn
  (s/spec
    #(re-matches (re-pattern "^arn:aws:ivschat:[a-z0-9-]+:[0-9]+:[a-z-]/[a-zA-Z0-9-]+$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.ivschat/CreateRoomResponse
  (s/keys
    :opt-un
    [:cognitect.aws.ivschat.CreateRoomResponse/maximumMessageRatePerSecond
     :cognitect.aws.ivschat.CreateRoomResponse/arn
     :cognitect.aws.ivschat.CreateRoomResponse/tags
     :cognitect.aws.ivschat.CreateRoomResponse/id
     :cognitect.aws.ivschat.CreateRoomResponse/name
     :cognitect.aws.ivschat.CreateRoomResponse/createTime
     :cognitect.aws.ivschat.CreateRoomResponse/updateTime
     :cognitect.aws.ivschat.CreateRoomResponse/maximumMessageLength
     :cognitect.aws.ivschat.CreateRoomResponse/messageReviewHandler]))

(s/def
  :cognitect.aws.ivschat/CreateChatTokenRequest
  (s/keys
    :req-un
    [:cognitect.aws.ivschat.CreateChatTokenRequest/roomIdentifier
     :cognitect.aws.ivschat.CreateChatTokenRequest/userId]
    :opt-un
    [:cognitect.aws.ivschat.CreateChatTokenRequest/capabilities
     :cognitect.aws.ivschat.CreateChatTokenRequest/sessionDurationInMinutes
     :cognitect.aws.ivschat.CreateChatTokenRequest/attributes]))

(s/def
  :cognitect.aws.ivschat/UpdateRoomRequest
  (s/keys
    :req-un
    [:cognitect.aws.ivschat.UpdateRoomRequest/identifier]
    :opt-un
    [:cognitect.aws.ivschat.UpdateRoomRequest/maximumMessageRatePerSecond
     :cognitect.aws.ivschat.UpdateRoomRequest/name
     :cognitect.aws.ivschat.UpdateRoomRequest/maximumMessageLength
     :cognitect.aws.ivschat.UpdateRoomRequest/messageReviewHandler]))

(s/def
  :cognitect.aws.ivschat/GetRoomRequest
  (s/keys :req-un [:cognitect.aws.ivschat.GetRoomRequest/identifier]))

(s/def
  :cognitect.aws.ivschat/ListTagsForResourceResponse
  (s/keys :req-un [:cognitect.aws.ivschat.ListTagsForResourceResponse/tags]))

(s/def
  :cognitect.aws.ivschat/PaginationToken
  (s/spec
    (s/and string? #(<= 0 (count %) 1024))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 1024) #(gen/vector (gen/char-alpha) %))))))

(s/def :cognitect.aws.ivschat/String string?)

(s/def
  :cognitect.aws.ivschat/RoomMaxMessageRatePerSecond
  (s/spec (s/and int? #(<= 1 % 10)) :gen #(gen/choose 1 10)))

(s/def
  :cognitect.aws.ivschat/TagKeyList
  (s/coll-of :cognitect.aws.ivschat/TagKey :min-count 0 :max-count 50))

(s/def :cognitect.aws.ivschat.TagResourceRequest/resourceArn :cognitect.aws.ivschat/ResourceArn)

(s/def :cognitect.aws.ivschat.TagResourceRequest/tags :cognitect.aws.ivschat/Tags)

(s/def :cognitect.aws.ivschat.GetRoomResponse/tags :cognitect.aws.ivschat/Tags)

(s/def
  :cognitect.aws.ivschat.GetRoomResponse/messageReviewHandler
  :cognitect.aws.ivschat/MessageReviewHandler)

(s/def :cognitect.aws.ivschat.GetRoomResponse/name :cognitect.aws.ivschat/RoomName)

(s/def :cognitect.aws.ivschat.GetRoomResponse/createTime :cognitect.aws.ivschat/Time)

(s/def :cognitect.aws.ivschat.GetRoomResponse/updateTime :cognitect.aws.ivschat/Time)

(s/def :cognitect.aws.ivschat.GetRoomResponse/id :cognitect.aws.ivschat/RoomID)

(s/def
  :cognitect.aws.ivschat.GetRoomResponse/maximumMessageRatePerSecond
  :cognitect.aws.ivschat/RoomMaxMessageRatePerSecond)

(s/def
  :cognitect.aws.ivschat.GetRoomResponse/maximumMessageLength
  :cognitect.aws.ivschat/RoomMaxMessageLength)

(s/def :cognitect.aws.ivschat.GetRoomResponse/arn :cognitect.aws.ivschat/RoomArn)

(s/def :cognitect.aws.ivschat.DisconnectUserRequest/reason :cognitect.aws.ivschat/Reason)

(s/def
  :cognitect.aws.ivschat.DisconnectUserRequest/roomIdentifier
  :cognitect.aws.ivschat/RoomIdentifier)

(s/def :cognitect.aws.ivschat.DisconnectUserRequest/userId :cognitect.aws.ivschat/UserID)

(s/def :cognitect.aws.ivschat.UpdateRoomResponse/tags :cognitect.aws.ivschat/Tags)

(s/def
  :cognitect.aws.ivschat.UpdateRoomResponse/messageReviewHandler
  :cognitect.aws.ivschat/MessageReviewHandler)

(s/def :cognitect.aws.ivschat.UpdateRoomResponse/name :cognitect.aws.ivschat/RoomName)

(s/def :cognitect.aws.ivschat.UpdateRoomResponse/createTime :cognitect.aws.ivschat/Time)

(s/def :cognitect.aws.ivschat.UpdateRoomResponse/updateTime :cognitect.aws.ivschat/Time)

(s/def :cognitect.aws.ivschat.UpdateRoomResponse/id :cognitect.aws.ivschat/RoomID)

(s/def
  :cognitect.aws.ivschat.UpdateRoomResponse/maximumMessageRatePerSecond
  :cognitect.aws.ivschat/RoomMaxMessageRatePerSecond)

(s/def
  :cognitect.aws.ivschat.UpdateRoomResponse/maximumMessageLength
  :cognitect.aws.ivschat/RoomMaxMessageLength)

(s/def :cognitect.aws.ivschat.UpdateRoomResponse/arn :cognitect.aws.ivschat/RoomArn)

(s/def :cognitect.aws.ivschat.DeleteMessageRequest/id :cognitect.aws.ivschat/MessageID)

(s/def :cognitect.aws.ivschat.DeleteMessageRequest/reason :cognitect.aws.ivschat/Reason)

(s/def
  :cognitect.aws.ivschat.DeleteMessageRequest/roomIdentifier
  :cognitect.aws.ivschat/RoomIdentifier)

(s/def :cognitect.aws.ivschat.DeleteRoomRequest/identifier :cognitect.aws.ivschat/RoomIdentifier)

(s/def :cognitect.aws.ivschat.SendEventResponse/id :cognitect.aws.ivschat/ID)

(s/def
  :cognitect.aws.ivschat.CreateRoomRequest/maximumMessageLength
  :cognitect.aws.ivschat/RoomMaxMessageLength)

(s/def
  :cognitect.aws.ivschat.CreateRoomRequest/maximumMessageRatePerSecond
  :cognitect.aws.ivschat/RoomMaxMessageRatePerSecond)

(s/def
  :cognitect.aws.ivschat.CreateRoomRequest/messageReviewHandler
  :cognitect.aws.ivschat/MessageReviewHandler)

(s/def :cognitect.aws.ivschat.CreateRoomRequest/name :cognitect.aws.ivschat/RoomName)

(s/def :cognitect.aws.ivschat.CreateRoomRequest/tags :cognitect.aws.ivschat/Tags)

(s/def :cognitect.aws.ivschat.RoomSummary/arn :cognitect.aws.ivschat/RoomArn)

(s/def :cognitect.aws.ivschat.RoomSummary/createTime :cognitect.aws.ivschat/Time)

(s/def :cognitect.aws.ivschat.RoomSummary/id :cognitect.aws.ivschat/RoomID)

(s/def
  :cognitect.aws.ivschat.RoomSummary/messageReviewHandler
  :cognitect.aws.ivschat/MessageReviewHandler)

(s/def :cognitect.aws.ivschat.RoomSummary/name :cognitect.aws.ivschat/RoomName)

(s/def :cognitect.aws.ivschat.RoomSummary/tags :cognitect.aws.ivschat/Tags)

(s/def :cognitect.aws.ivschat.RoomSummary/updateTime :cognitect.aws.ivschat/Time)

(s/def
  :cognitect.aws.ivschat.CreateChatTokenResponse/sessionExpirationTime
  :cognitect.aws.ivschat/Time)

(s/def :cognitect.aws.ivschat.CreateChatTokenResponse/token :cognitect.aws.ivschat/ChatToken)

(s/def
  :cognitect.aws.ivschat.CreateChatTokenResponse/tokenExpirationTime
  :cognitect.aws.ivschat/Time)

(s/def
  :cognitect.aws.ivschat.ListTagsForResourceRequest/resourceArn
  :cognitect.aws.ivschat/ResourceArn)

(s/def :cognitect.aws.ivschat.ListRoomsRequest/maxResults :cognitect.aws.ivschat/MaxRoomResults)

(s/def
  :cognitect.aws.ivschat.ListRoomsRequest/messageReviewHandlerUri
  :cognitect.aws.ivschat/LambdaArn)

(s/def :cognitect.aws.ivschat.ListRoomsRequest/name :cognitect.aws.ivschat/RoomName)

(s/def :cognitect.aws.ivschat.ListRoomsRequest/nextToken :cognitect.aws.ivschat/PaginationToken)

(s/def
  :cognitect.aws.ivschat.MessageReviewHandler/fallbackResult
  :cognitect.aws.ivschat/FallbackResult)

(s/def :cognitect.aws.ivschat.MessageReviewHandler/uri :cognitect.aws.ivschat/LambdaArn)

(s/def :cognitect.aws.ivschat.DeleteMessageResponse/id :cognitect.aws.ivschat/ID)

(s/def :cognitect.aws.ivschat.ListRoomsResponse/nextToken :cognitect.aws.ivschat/PaginationToken)

(s/def :cognitect.aws.ivschat.ListRoomsResponse/rooms :cognitect.aws.ivschat/RoomList)

(s/def :cognitect.aws.ivschat.UntagResourceRequest/resourceArn :cognitect.aws.ivschat/ResourceArn)

(s/def :cognitect.aws.ivschat.UntagResourceRequest/tagKeys :cognitect.aws.ivschat/TagKeyList)

(s/def :cognitect.aws.ivschat.SendEventRequest/attributes :cognitect.aws.ivschat/EventAttributes)

(s/def :cognitect.aws.ivschat.SendEventRequest/eventName :cognitect.aws.ivschat/EventName)

(s/def :cognitect.aws.ivschat.SendEventRequest/roomIdentifier :cognitect.aws.ivschat/RoomIdentifier)

(s/def :cognitect.aws.ivschat.CreateRoomResponse/tags :cognitect.aws.ivschat/Tags)

(s/def
  :cognitect.aws.ivschat.CreateRoomResponse/messageReviewHandler
  :cognitect.aws.ivschat/MessageReviewHandler)

(s/def :cognitect.aws.ivschat.CreateRoomResponse/name :cognitect.aws.ivschat/RoomName)

(s/def :cognitect.aws.ivschat.CreateRoomResponse/createTime :cognitect.aws.ivschat/Time)

(s/def :cognitect.aws.ivschat.CreateRoomResponse/updateTime :cognitect.aws.ivschat/Time)

(s/def :cognitect.aws.ivschat.CreateRoomResponse/id :cognitect.aws.ivschat/RoomID)

(s/def
  :cognitect.aws.ivschat.CreateRoomResponse/maximumMessageRatePerSecond
  :cognitect.aws.ivschat/RoomMaxMessageRatePerSecond)

(s/def
  :cognitect.aws.ivschat.CreateRoomResponse/maximumMessageLength
  :cognitect.aws.ivschat/RoomMaxMessageLength)

(s/def :cognitect.aws.ivschat.CreateRoomResponse/arn :cognitect.aws.ivschat/RoomArn)

(s/def
  :cognitect.aws.ivschat.CreateChatTokenRequest/attributes
  :cognitect.aws.ivschat/ChatTokenAttributes)

(s/def
  :cognitect.aws.ivschat.CreateChatTokenRequest/capabilities
  :cognitect.aws.ivschat/ChatTokenCapabilities)

(s/def
  :cognitect.aws.ivschat.CreateChatTokenRequest/roomIdentifier
  :cognitect.aws.ivschat/RoomIdentifier)

(s/def
  :cognitect.aws.ivschat.CreateChatTokenRequest/sessionDurationInMinutes
  :cognitect.aws.ivschat/SessionDurationInMinutes)

(s/def :cognitect.aws.ivschat.CreateChatTokenRequest/userId :cognitect.aws.ivschat/UserID)

(s/def :cognitect.aws.ivschat.UpdateRoomRequest/identifier :cognitect.aws.ivschat/RoomIdentifier)

(s/def
  :cognitect.aws.ivschat.UpdateRoomRequest/maximumMessageLength
  :cognitect.aws.ivschat/RoomMaxMessageLength)

(s/def
  :cognitect.aws.ivschat.UpdateRoomRequest/maximumMessageRatePerSecond
  :cognitect.aws.ivschat/RoomMaxMessageRatePerSecond)

(s/def
  :cognitect.aws.ivschat.UpdateRoomRequest/messageReviewHandler
  :cognitect.aws.ivschat/MessageReviewHandler)

(s/def :cognitect.aws.ivschat.UpdateRoomRequest/name :cognitect.aws.ivschat/RoomName)

(s/def :cognitect.aws.ivschat.GetRoomRequest/identifier :cognitect.aws.ivschat/RoomIdentifier)

(s/def :cognitect.aws.ivschat.ListTagsForResourceResponse/tags :cognitect.aws.ivschat/Tags)

