;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.appmesh.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.appmesh/GrpcRouteMetadataMatchMethod
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.GrpcRouteMetadataMatchMethod/range
     :cognitect.aws.appmesh.GrpcRouteMetadataMatchMethod/exact
     :cognitect.aws.appmesh.GrpcRouteMetadataMatchMethod/prefix
     :cognitect.aws.appmesh.GrpcRouteMetadataMatchMethod/suffix
     :cognitect.aws.appmesh.GrpcRouteMetadataMatchMethod/regex]))

(s/def
  :cognitect.aws.appmesh/CertificateAuthorityArns
  (s/coll-of :cognitect.aws.appmesh/Arn :min-count 1 :max-count 3))

(s/def
  :cognitect.aws.appmesh/HttpRouteHeaders
  (s/coll-of :cognitect.aws.appmesh/HttpRouteHeader :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.appmesh/VirtualNodeStatus
  (s/keys :req-un [:cognitect.aws.appmesh.VirtualNodeStatus/status]))

(s/def
  :cognitect.aws.appmesh/MethodName
  (s/spec
    (s/and string? #(<= 1 (count %) 50))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 50) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.appmesh/UpdateMeshOutput
  (s/keys :req-un [:cognitect.aws.appmesh.UpdateMeshOutput/mesh]))

(s/def
  :cognitect.aws.appmesh/VirtualRouterRef
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.VirtualRouterRef/arn
     :cognitect.aws.appmesh.VirtualRouterRef/meshName
     :cognitect.aws.appmesh.VirtualRouterRef/virtualRouterName]))

(s/def
  :cognitect.aws.appmesh/HttpRetryPolicyEvent
  (s/spec
    (s/and string? #(<= 1 (count %) 25))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 25) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.appmesh/UpdateVirtualServiceInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.UpdateVirtualServiceInput/meshName
     :cognitect.aws.appmesh.UpdateVirtualServiceInput/spec
     :cognitect.aws.appmesh.UpdateVirtualServiceInput/virtualServiceName]
    :opt-un
    [:cognitect.aws.appmesh.UpdateVirtualServiceInput/clientToken]))

(s/def
  :cognitect.aws.appmesh/ListTagsForResourceInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListTagsForResourceInput/resourceArn]
    :opt-un
    [:cognitect.aws.appmesh.ListTagsForResourceInput/nextToken
     :cognitect.aws.appmesh.ListTagsForResourceInput/limit]))

(s/def
  :cognitect.aws.appmesh/ListTagsForResourceOutput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListTagsForResourceOutput/tags]
    :opt-un
    [:cognitect.aws.appmesh.ListTagsForResourceOutput/nextToken]))

(s/def
  :cognitect.aws.appmesh/AwsCloudMapName
  (s/spec
    #(re-matches
      (re-pattern
        "((?=^.{1,127}$)^([a-zA-Z0-9_][a-zA-Z0-9-_]{0,61}[a-zA-Z0-9_]|[a-zA-Z0-9])(.([a-zA-Z0-9_][a-zA-Z0-9-_]{0,61}[a-zA-Z0-9_]|[a-zA-Z0-9]))*$)|(^.$)")
      %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.appmesh/PortProtocol
  (s/spec string? :gen #(s/gen #{"http2" "http" "grpc" "tcp"})))

(s/def
  :cognitect.aws.appmesh/MaxRetries
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.appmesh/ServiceDiscovery
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.ServiceDiscovery/dns
     :cognitect.aws.appmesh.ServiceDiscovery/awsCloudMap]))

(s/def
  :cognitect.aws.appmesh/CreateVirtualRouterOutput
  (s/keys :req-un [:cognitect.aws.appmesh.CreateVirtualRouterOutput/virtualRouter]))

(s/def
  :cognitect.aws.appmesh/MeshStatus
  (s/keys :opt-un [:cognitect.aws.appmesh.MeshStatus/status]))

(s/def
  :cognitect.aws.appmesh/DescribeRouteOutput
  (s/keys :req-un [:cognitect.aws.appmesh.DescribeRouteOutput/route]))

(s/def
  :cognitect.aws.appmesh/RoutePriority
  (s/spec (s/and int? #(<= 0 % 1000)) :gen #(gen/choose 0 1000)))

(s/def
  :cognitect.aws.appmesh/GrpcRouteMetadataList
  (s/coll-of :cognitect.aws.appmesh/GrpcRouteMetadata :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.appmesh/TagRef
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.TagRef/key]
    :opt-un
    [:cognitect.aws.appmesh.TagRef/value]))

(s/def
  :cognitect.aws.appmesh/TlsValidationContextFileTrust
  (s/keys :req-un [:cognitect.aws.appmesh.TlsValidationContextFileTrust/certificateChain]))

(s/def
  :cognitect.aws.appmesh/DescribeVirtualRouterInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.DescribeVirtualRouterInput/meshName
     :cognitect.aws.appmesh.DescribeVirtualRouterInput/virtualRouterName]))

(s/def
  :cognitect.aws.appmesh/TcpRetryPolicyEvents
  (s/coll-of :cognitect.aws.appmesh/TcpRetryPolicyEvent :min-count 1 :max-count 1))

(s/def
  :cognitect.aws.appmesh/VirtualServiceProvider
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.VirtualServiceProvider/virtualNode
     :cognitect.aws.appmesh.VirtualServiceProvider/virtualRouter]))

(s/def :cognitect.aws.appmesh/TcpRoute (s/keys :req-un [:cognitect.aws.appmesh.TcpRoute/action]))

(s/def
  :cognitect.aws.appmesh/GrpcRouteMatch
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.GrpcRouteMatch/methodName
     :cognitect.aws.appmesh.GrpcRouteMatch/serviceName
     :cognitect.aws.appmesh.GrpcRouteMatch/metadata]))

(s/def :cognitect.aws.appmesh/RouteList (s/coll-of :cognitect.aws.appmesh/RouteRef))

(s/def
  :cognitect.aws.appmesh/BackendDefaults
  (s/keys :opt-un [:cognitect.aws.appmesh.BackendDefaults/clientPolicy]))

(s/def
  :cognitect.aws.appmesh/VirtualNodeRef
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.VirtualNodeRef/arn
     :cognitect.aws.appmesh.VirtualNodeRef/meshName
     :cognitect.aws.appmesh.VirtualNodeRef/virtualNodeName]))

(s/def
  :cognitect.aws.appmesh/AwsCloudMapServiceDiscovery
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.AwsCloudMapServiceDiscovery/namespaceName
     :cognitect.aws.appmesh.AwsCloudMapServiceDiscovery/serviceName]
    :opt-un
    [:cognitect.aws.appmesh.AwsCloudMapServiceDiscovery/attributes]))

(s/def
  :cognitect.aws.appmesh/CreateRouteOutput
  (s/keys :req-un [:cognitect.aws.appmesh.CreateRouteOutput/route]))

(s/def
  :cognitect.aws.appmesh/HealthCheckIntervalMillis
  (s/spec (s/and int? #(<= 5000 % 300000)) :gen #(gen/choose 5000 300000)))

(s/def
  :cognitect.aws.appmesh/VirtualRouterListeners
  (s/coll-of :cognitect.aws.appmesh/VirtualRouterListener :min-count 1 :max-count 1))

(s/def
  :cognitect.aws.appmesh/VirtualRouterSpec
  (s/keys :opt-un [:cognitect.aws.appmesh.VirtualRouterSpec/listeners]))

(s/def
  :cognitect.aws.appmesh/DescribeVirtualNodeOutput
  (s/keys :req-un [:cognitect.aws.appmesh.DescribeVirtualNodeOutput/virtualNode]))

(s/def
  :cognitect.aws.appmesh/HealthCheckTimeoutMillis
  (s/spec (s/and int? #(<= 2000 % 60000)) :gen #(gen/choose 2000 60000)))

(s/def
  :cognitect.aws.appmesh/MatchRange
  (s/keys :req-un [:cognitect.aws.appmesh.MatchRange/end :cognitect.aws.appmesh.MatchRange/start]))

(s/def
  :cognitect.aws.appmesh/ListVirtualServicesLimit
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.appmesh/VirtualServiceSpec
  (s/keys :opt-un [:cognitect.aws.appmesh.VirtualServiceSpec/provider]))

(s/def
  :cognitect.aws.appmesh/TagList
  (s/coll-of :cognitect.aws.appmesh/TagRef :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.appmesh/GrpcRetryPolicyEvent
  (s/spec
    string?
    :gen
    #(s/gen #{"internal" "resource-exhausted" "deadline-exceeded" "cancelled" "unavailable"})))

(s/def
  :cognitect.aws.appmesh/VirtualServiceList
  (s/coll-of :cognitect.aws.appmesh/VirtualServiceRef))

(s/def
  :cognitect.aws.appmesh/ListenerTlsFileCertificate
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListenerTlsFileCertificate/certificateChain
     :cognitect.aws.appmesh.ListenerTlsFileCertificate/privateKey]))

(s/def
  :cognitect.aws.appmesh/CreateVirtualNodeInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.CreateVirtualNodeInput/meshName
     :cognitect.aws.appmesh.CreateVirtualNodeInput/spec
     :cognitect.aws.appmesh.CreateVirtualNodeInput/virtualNodeName]
    :opt-un
    [:cognitect.aws.appmesh.CreateVirtualNodeInput/clientToken
     :cognitect.aws.appmesh.CreateVirtualNodeInput/tags]))

(s/def :cognitect.aws.appmesh/AccessLog (s/keys :opt-un [:cognitect.aws.appmesh.AccessLog/file]))

(s/def
  :cognitect.aws.appmesh/DeleteMeshInput
  (s/keys :req-un [:cognitect.aws.appmesh.DeleteMeshInput/meshName]))

(s/def
  :cognitect.aws.appmesh/MeshRef
  (s/keys :req-un [:cognitect.aws.appmesh.MeshRef/arn :cognitect.aws.appmesh.MeshRef/meshName]))

(s/def
  :cognitect.aws.appmesh/UpdateRouteInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.UpdateRouteInput/meshName
     :cognitect.aws.appmesh.UpdateRouteInput/routeName
     :cognitect.aws.appmesh.UpdateRouteInput/spec
     :cognitect.aws.appmesh.UpdateRouteInput/virtualRouterName]
    :opt-un
    [:cognitect.aws.appmesh.UpdateRouteInput/clientToken]))

(s/def
  :cognitect.aws.appmesh/Listener
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.Listener/portMapping]
    :opt-un
    [:cognitect.aws.appmesh.Listener/tls :cognitect.aws.appmesh.Listener/healthCheck]))

(s/def
  :cognitect.aws.appmesh/VirtualServiceStatus
  (s/keys :req-un [:cognitect.aws.appmesh.VirtualServiceStatus/status]))

(s/def
  :cognitect.aws.appmesh/HttpMethod
  (s/spec
    string?
    :gen
    #(s/gen #{"DELETE" "OPTIONS" "PATCH" "TRACE" "HEAD" "POST" "CONNECT" "GET" "PUT"})))

(s/def
  :cognitect.aws.appmesh/UpdateVirtualRouterOutput
  (s/keys :req-un [:cognitect.aws.appmesh.UpdateVirtualRouterOutput/virtualRouter]))

(s/def :cognitect.aws.appmesh/DurationUnit (s/spec string? :gen #(s/gen #{"s" "ms"})))

(s/def
  :cognitect.aws.appmesh/GrpcRouteAction
  (s/keys :req-un [:cognitect.aws.appmesh.GrpcRouteAction/weightedTargets]))

(s/def
  :cognitect.aws.appmesh/ListVirtualServicesOutput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListVirtualServicesOutput/virtualServices]
    :opt-un
    [:cognitect.aws.appmesh.ListVirtualServicesOutput/nextToken]))

(s/def
  :cognitect.aws.appmesh/DeleteVirtualServiceInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.DeleteVirtualServiceInput/meshName
     :cognitect.aws.appmesh.DeleteVirtualServiceInput/virtualServiceName]))

(s/def
  :cognitect.aws.appmesh/HealthCheckThreshold
  (s/spec (s/and int? #(<= 2 % 10)) :gen #(gen/choose 2 10)))

(s/def
  :cognitect.aws.appmesh/ListMeshesOutput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListMeshesOutput/meshes]
    :opt-un
    [:cognitect.aws.appmesh.ListMeshesOutput/nextToken]))

(s/def
  :cognitect.aws.appmesh/TcpRouteAction
  (s/keys :req-un [:cognitect.aws.appmesh.TcpRouteAction/weightedTargets]))

(s/def
  :cognitect.aws.appmesh/UpdateVirtualNodeOutput
  (s/keys :req-un [:cognitect.aws.appmesh.UpdateVirtualNodeOutput/virtualNode]))

(s/def
  :cognitect.aws.appmesh/TlsValidationContextAcmTrust
  (s/keys :req-un [:cognitect.aws.appmesh.TlsValidationContextAcmTrust/certificateAuthorityArns]))

(s/def
  :cognitect.aws.appmesh/HttpRouteAction
  (s/keys :req-un [:cognitect.aws.appmesh.HttpRouteAction/weightedTargets]))

(s/def
  :cognitect.aws.appmesh/CreateVirtualServiceOutput
  (s/keys :req-un [:cognitect.aws.appmesh.CreateVirtualServiceOutput/virtualService]))

(s/def :cognitect.aws.appmesh/Boolean boolean?)

(s/def
  :cognitect.aws.appmesh/TlsValidationContextTrust
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.TlsValidationContextTrust/acm
     :cognitect.aws.appmesh.TlsValidationContextTrust/file]))

(s/def
  :cognitect.aws.appmesh/TagResourceInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.TagResourceInput/resourceArn
     :cognitect.aws.appmesh.TagResourceInput/tags]))

(s/def
  :cognitect.aws.appmesh/VirtualRouterData
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.VirtualRouterData/meshName
     :cognitect.aws.appmesh.VirtualRouterData/metadata
     :cognitect.aws.appmesh.VirtualRouterData/spec
     :cognitect.aws.appmesh.VirtualRouterData/status
     :cognitect.aws.appmesh.VirtualRouterData/virtualRouterName]))

(s/def
  :cognitect.aws.appmesh/GrpcRoute
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.GrpcRoute/action :cognitect.aws.appmesh.GrpcRoute/match]
    :opt-un
    [:cognitect.aws.appmesh.GrpcRoute/retryPolicy]))

(s/def
  :cognitect.aws.appmesh/PortMapping
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.PortMapping/port :cognitect.aws.appmesh.PortMapping/protocol]))

(s/def
  :cognitect.aws.appmesh/ListMeshesInput
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.ListMeshesInput/nextToken
     :cognitect.aws.appmesh.ListMeshesInput/limit]))

(s/def
  :cognitect.aws.appmesh/ListenerTlsMode
  (s/spec string? :gen #(s/gen #{"DISABLED" "PERMISSIVE" "STRICT"})))

(s/def
  :cognitect.aws.appmesh/PercentInt
  (s/spec (s/and int? #(<= 0 % 100)) :gen #(gen/choose 0 100)))

(s/def :cognitect.aws.appmesh/TagResourceOutput (s/keys))

(s/def
  :cognitect.aws.appmesh/DeleteVirtualRouterInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.DeleteVirtualRouterInput/meshName
     :cognitect.aws.appmesh.DeleteVirtualRouterInput/virtualRouterName]))

(s/def :cognitect.aws.appmesh/Hostname string?)

(s/def
  :cognitect.aws.appmesh/MeshSpec
  (s/keys :opt-un [:cognitect.aws.appmesh.MeshSpec/egressFilter]))

(s/def
  :cognitect.aws.appmesh/HttpRoute
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.HttpRoute/action :cognitect.aws.appmesh.HttpRoute/match]
    :opt-un
    [:cognitect.aws.appmesh.HttpRoute/retryPolicy]))

(s/def
  :cognitect.aws.appmesh/ListVirtualServicesInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListVirtualServicesInput/meshName]
    :opt-un
    [:cognitect.aws.appmesh.ListVirtualServicesInput/nextToken
     :cognitect.aws.appmesh.ListVirtualServicesInput/limit]))

(s/def
  :cognitect.aws.appmesh/HttpRetryPolicy
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.HttpRetryPolicy/maxRetries
     :cognitect.aws.appmesh.HttpRetryPolicy/perRetryTimeout]
    :opt-un
    [:cognitect.aws.appmesh.HttpRetryPolicy/tcpRetryEvents
     :cognitect.aws.appmesh.HttpRetryPolicy/httpRetryEvents]))

(s/def
  :cognitect.aws.appmesh/DeleteVirtualServiceOutput
  (s/keys :req-un [:cognitect.aws.appmesh.DeleteVirtualServiceOutput/virtualService]))

(s/def :cognitect.aws.appmesh/Backends (s/coll-of :cognitect.aws.appmesh/Backend))

(s/def
  :cognitect.aws.appmesh/CreateMeshOutput
  (s/keys :req-un [:cognitect.aws.appmesh.CreateMeshOutput/mesh]))

(s/def
  :cognitect.aws.appmesh/ListVirtualRoutersInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListVirtualRoutersInput/meshName]
    :opt-un
    [:cognitect.aws.appmesh.ListVirtualRoutersInput/nextToken
     :cognitect.aws.appmesh.ListVirtualRoutersInput/limit]))

(s/def
  :cognitect.aws.appmesh/TagValue
  (s/spec
    (s/and string? #(<= 0 (count %) 256))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 0 256) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.appmesh/ClientPolicy
  (s/keys :opt-un [:cognitect.aws.appmesh.ClientPolicy/tls]))

(s/def
  :cognitect.aws.appmesh/UpdateVirtualServiceOutput
  (s/keys :req-un [:cognitect.aws.appmesh.UpdateVirtualServiceOutput/virtualService]))

(s/def
  :cognitect.aws.appmesh/HttpRetryPolicyEvents
  (s/coll-of :cognitect.aws.appmesh/HttpRetryPolicyEvent :min-count 1 :max-count 25))

(s/def
  :cognitect.aws.appmesh/HeaderName
  (s/spec
    (s/and string? #(<= 1 (count %) 50))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 50) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.appmesh/DescribeRouteInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.DescribeRouteInput/meshName
     :cognitect.aws.appmesh.DescribeRouteInput/routeName
     :cognitect.aws.appmesh.DescribeRouteInput/virtualRouterName]))

(s/def
  :cognitect.aws.appmesh/HttpRouteMatch
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.HttpRouteMatch/prefix]
    :opt-un
    [:cognitect.aws.appmesh.HttpRouteMatch/method
     :cognitect.aws.appmesh.HttpRouteMatch/scheme
     :cognitect.aws.appmesh.HttpRouteMatch/headers]))

(s/def
  :cognitect.aws.appmesh/CreateVirtualRouterInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.CreateVirtualRouterInput/meshName
     :cognitect.aws.appmesh.CreateVirtualRouterInput/spec
     :cognitect.aws.appmesh.CreateVirtualRouterInput/virtualRouterName]
    :opt-un
    [:cognitect.aws.appmesh.CreateVirtualRouterInput/clientToken
     :cognitect.aws.appmesh.CreateVirtualRouterInput/tags]))

(s/def
  :cognitect.aws.appmesh/CreateRouteInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.CreateRouteInput/meshName
     :cognitect.aws.appmesh.CreateRouteInput/routeName
     :cognitect.aws.appmesh.CreateRouteInput/spec
     :cognitect.aws.appmesh.CreateRouteInput/virtualRouterName]
    :opt-un
    [:cognitect.aws.appmesh.CreateRouteInput/clientToken
     :cognitect.aws.appmesh.CreateRouteInput/tags]))

(s/def
  :cognitect.aws.appmesh/UpdateMeshInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.UpdateMeshInput/meshName]
    :opt-un
    [:cognitect.aws.appmesh.UpdateMeshInput/clientToken
     :cognitect.aws.appmesh.UpdateMeshInput/spec]))

(s/def
  :cognitect.aws.appmesh/Backend
  (s/keys :opt-un [:cognitect.aws.appmesh.Backend/virtualService]))

(s/def
  :cognitect.aws.appmesh/VirtualServiceBackend
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.VirtualServiceBackend/virtualServiceName]
    :opt-un
    [:cognitect.aws.appmesh.VirtualServiceBackend/clientPolicy]))

(s/def
  :cognitect.aws.appmesh/ListenerTls
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListenerTls/certificate :cognitect.aws.appmesh.ListenerTls/mode]))

(s/def
  :cognitect.aws.appmesh/RouteRef
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.RouteRef/arn
     :cognitect.aws.appmesh.RouteRef/meshName
     :cognitect.aws.appmesh.RouteRef/routeName
     :cognitect.aws.appmesh.RouteRef/virtualRouterName]))

(s/def
  :cognitect.aws.appmesh/DeleteMeshOutput
  (s/keys :req-un [:cognitect.aws.appmesh.DeleteMeshOutput/mesh]))

(s/def
  :cognitect.aws.appmesh/EgressFilter
  (s/keys :req-un [:cognitect.aws.appmesh.EgressFilter/type]))

(s/def
  :cognitect.aws.appmesh/HeaderMatch
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.appmesh/DescribeVirtualServiceInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.DescribeVirtualServiceInput/meshName
     :cognitect.aws.appmesh.DescribeVirtualServiceInput/virtualServiceName]))

(s/def
  :cognitect.aws.appmesh/ListVirtualNodesOutput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListVirtualNodesOutput/virtualNodes]
    :opt-un
    [:cognitect.aws.appmesh.ListVirtualNodesOutput/nextToken]))

(s/def
  :cognitect.aws.appmesh/ListenerTlsAcmCertificate
  (s/keys :req-un [:cognitect.aws.appmesh.ListenerTlsAcmCertificate/certificateArn]))

(s/def
  :cognitect.aws.appmesh/GrpcRetryPolicyEvents
  (s/coll-of :cognitect.aws.appmesh/GrpcRetryPolicyEvent :min-count 1 :max-count 5))

(s/def
  :cognitect.aws.appmesh/TlsValidationContext
  (s/keys :req-un [:cognitect.aws.appmesh.TlsValidationContext/trust]))

(s/def
  :cognitect.aws.appmesh/MeshData
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.MeshData/meshName
     :cognitect.aws.appmesh.MeshData/metadata
     :cognitect.aws.appmesh.MeshData/spec
     :cognitect.aws.appmesh.MeshData/status]))

(s/def
  :cognitect.aws.appmesh/VirtualServiceRef
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.VirtualServiceRef/arn
     :cognitect.aws.appmesh.VirtualServiceRef/meshName
     :cognitect.aws.appmesh.VirtualServiceRef/virtualServiceName]))

(s/def
  :cognitect.aws.appmesh/AwsCloudMapInstanceAttributeKey
  (s/spec #(re-matches (re-pattern "^[a-zA-Z0-9!-~]+$") %) :gen #(gen/string)))

(s/def
  :cognitect.aws.appmesh/DeleteVirtualRouterOutput
  (s/keys :req-un [:cognitect.aws.appmesh.DeleteVirtualRouterOutput/virtualRouter]))

(s/def
  :cognitect.aws.appmesh/AwsCloudMapInstanceAttribute
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.AwsCloudMapInstanceAttribute/key
     :cognitect.aws.appmesh.AwsCloudMapInstanceAttribute/value]))

(s/def
  :cognitect.aws.appmesh/DurationValue
  (s/spec (s/and int? #(<= 0 %)) :gen #(gen/choose 0 Long/MAX_VALUE)))

(s/def
  :cognitect.aws.appmesh/UntagResourceInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.UntagResourceInput/resourceArn
     :cognitect.aws.appmesh.UntagResourceInput/tagKeys]))

(s/def
  :cognitect.aws.appmesh/VirtualServiceStatusCode
  (s/spec string? :gen #(s/gen #{"INACTIVE" "ACTIVE" "DELETED"})))

(s/def
  :cognitect.aws.appmesh/WeightedTargets
  (s/coll-of :cognitect.aws.appmesh/WeightedTarget :min-count 1 :max-count 10))

(s/def
  :cognitect.aws.appmesh/HealthCheckPolicy
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.HealthCheckPolicy/healthyThreshold
     :cognitect.aws.appmesh.HealthCheckPolicy/intervalMillis
     :cognitect.aws.appmesh.HealthCheckPolicy/protocol
     :cognitect.aws.appmesh.HealthCheckPolicy/timeoutMillis
     :cognitect.aws.appmesh.HealthCheckPolicy/unhealthyThreshold]
    :opt-un
    [:cognitect.aws.appmesh.HealthCheckPolicy/path :cognitect.aws.appmesh.HealthCheckPolicy/port]))

(s/def
  :cognitect.aws.appmesh/GrpcRouteMetadata
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.GrpcRouteMetadata/name]
    :opt-un
    [:cognitect.aws.appmesh.GrpcRouteMetadata/invert
     :cognitect.aws.appmesh.GrpcRouteMetadata/match]))

(s/def
  :cognitect.aws.appmesh/DeleteRouteInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.DeleteRouteInput/meshName
     :cognitect.aws.appmesh.DeleteRouteInput/routeName
     :cognitect.aws.appmesh.DeleteRouteInput/virtualRouterName]))

(s/def
  :cognitect.aws.appmesh/DescribeVirtualRouterOutput
  (s/keys :req-un [:cognitect.aws.appmesh.DescribeVirtualRouterOutput/virtualRouter]))

(s/def :cognitect.aws.appmesh/PortSet (s/coll-of :cognitect.aws.appmesh/PortNumber))

(s/def
  :cognitect.aws.appmesh/RouteStatusCode
  (s/spec string? :gen #(s/gen #{"INACTIVE" "ACTIVE" "DELETED"})))

(s/def
  :cognitect.aws.appmesh/VirtualRouterServiceProvider
  (s/keys :req-un [:cognitect.aws.appmesh.VirtualRouterServiceProvider/virtualRouterName]))

(s/def
  :cognitect.aws.appmesh/DescribeMeshOutput
  (s/keys :req-un [:cognitect.aws.appmesh.DescribeMeshOutput/mesh]))

(s/def
  :cognitect.aws.appmesh/DeleteRouteOutput
  (s/keys :req-un [:cognitect.aws.appmesh.DeleteRouteOutput/route]))

(s/def
  :cognitect.aws.appmesh/ListVirtualRoutersOutput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListVirtualRoutersOutput/virtualRouters]
    :opt-un
    [:cognitect.aws.appmesh.ListVirtualRoutersOutput/nextToken]))

(s/def :cognitect.aws.appmesh/HttpScheme (s/spec string? :gen #(s/gen #{"https" "http"})))

(s/def :cognitect.aws.appmesh/Long (s/spec int? :gen #(gen/choose Long/MIN_VALUE Long/MAX_VALUE)))

(s/def
  :cognitect.aws.appmesh/ListRoutesLimit
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def :cognitect.aws.appmesh/Arn string?)

(s/def
  :cognitect.aws.appmesh/DescribeVirtualServiceOutput
  (s/keys :req-un [:cognitect.aws.appmesh.DescribeVirtualServiceOutput/virtualService]))

(s/def
  :cognitect.aws.appmesh/HttpRouteHeader
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.HttpRouteHeader/name]
    :opt-un
    [:cognitect.aws.appmesh.HttpRouteHeader/invert :cognitect.aws.appmesh.HttpRouteHeader/match]))

(s/def
  :cognitect.aws.appmesh/UpdateVirtualNodeInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.UpdateVirtualNodeInput/meshName
     :cognitect.aws.appmesh.UpdateVirtualNodeInput/spec
     :cognitect.aws.appmesh.UpdateVirtualNodeInput/virtualNodeName]
    :opt-un
    [:cognitect.aws.appmesh.UpdateVirtualNodeInput/clientToken]))

(s/def
  :cognitect.aws.appmesh/VirtualServiceData
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.VirtualServiceData/meshName
     :cognitect.aws.appmesh.VirtualServiceData/metadata
     :cognitect.aws.appmesh.VirtualServiceData/spec
     :cognitect.aws.appmesh.VirtualServiceData/status
     :cognitect.aws.appmesh.VirtualServiceData/virtualServiceName]))

(s/def
  :cognitect.aws.appmesh/EgressFilterType
  (s/spec string? :gen #(s/gen #{"ALLOW_ALL" "DROP_ALL"})))

(s/def :cognitect.aws.appmesh/TagsLimit (s/spec (s/and int? #(<= 1 % 50)) :gen #(gen/choose 1 50)))

(s/def
  :cognitect.aws.appmesh/DeleteVirtualNodeOutput
  (s/keys :req-un [:cognitect.aws.appmesh.DeleteVirtualNodeOutput/virtualNode]))

(s/def :cognitect.aws.appmesh/UntagResourceOutput (s/keys))

(s/def
  :cognitect.aws.appmesh/VirtualNodeData
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.VirtualNodeData/meshName
     :cognitect.aws.appmesh.VirtualNodeData/metadata
     :cognitect.aws.appmesh.VirtualNodeData/spec
     :cognitect.aws.appmesh.VirtualNodeData/status
     :cognitect.aws.appmesh.VirtualNodeData/virtualNodeName]))

(s/def
  :cognitect.aws.appmesh/TagKey
  (s/spec
    (s/and string? #(<= 1 (count %) 128))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 128) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.appmesh/DescribeVirtualNodeInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.DescribeVirtualNodeInput/meshName
     :cognitect.aws.appmesh.DescribeVirtualNodeInput/virtualNodeName]))

(s/def
  :cognitect.aws.appmesh/VirtualRouterStatusCode
  (s/spec string? :gen #(s/gen #{"INACTIVE" "ACTIVE" "DELETED"})))

(s/def
  :cognitect.aws.appmesh/Duration
  (s/keys :opt-un [:cognitect.aws.appmesh.Duration/value :cognitect.aws.appmesh.Duration/unit]))

(s/def
  :cognitect.aws.appmesh/ListVirtualNodesInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListVirtualNodesInput/meshName]
    :opt-un
    [:cognitect.aws.appmesh.ListVirtualNodesInput/nextToken
     :cognitect.aws.appmesh.ListVirtualNodesInput/limit]))

(s/def
  :cognitect.aws.appmesh/VirtualRouterStatus
  (s/keys :req-un [:cognitect.aws.appmesh.VirtualRouterStatus/status]))

(s/def
  :cognitect.aws.appmesh/FileAccessLog
  (s/keys :req-un [:cognitect.aws.appmesh.FileAccessLog/path]))

(s/def :cognitect.aws.appmesh/Timestamp inst?)

(s/def
  :cognitect.aws.appmesh/HeaderMatchMethod
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.HeaderMatchMethod/range
     :cognitect.aws.appmesh.HeaderMatchMethod/exact
     :cognitect.aws.appmesh.HeaderMatchMethod/prefix
     :cognitect.aws.appmesh.HeaderMatchMethod/suffix
     :cognitect.aws.appmesh.HeaderMatchMethod/regex]))

(s/def
  :cognitect.aws.appmesh/DnsServiceDiscovery
  (s/keys :req-un [:cognitect.aws.appmesh.DnsServiceDiscovery/hostname]))

(s/def
  :cognitect.aws.appmesh/MeshStatusCode
  (s/spec string? :gen #(s/gen #{"INACTIVE" "ACTIVE" "DELETED"})))

(s/def
  :cognitect.aws.appmesh/AwsCloudMapInstanceAttributes
  (s/coll-of :cognitect.aws.appmesh/AwsCloudMapInstanceAttribute))

(s/def
  :cognitect.aws.appmesh/CreateVirtualServiceInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.CreateVirtualServiceInput/meshName
     :cognitect.aws.appmesh.CreateVirtualServiceInput/spec
     :cognitect.aws.appmesh.CreateVirtualServiceInput/virtualServiceName]
    :opt-un
    [:cognitect.aws.appmesh.CreateVirtualServiceInput/clientToken
     :cognitect.aws.appmesh.CreateVirtualServiceInput/tags]))

(s/def
  :cognitect.aws.appmesh/GrpcRetryPolicy
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.GrpcRetryPolicy/maxRetries
     :cognitect.aws.appmesh.GrpcRetryPolicy/perRetryTimeout]
    :opt-un
    [:cognitect.aws.appmesh.GrpcRetryPolicy/tcpRetryEvents
     :cognitect.aws.appmesh.GrpcRetryPolicy/grpcRetryEvents
     :cognitect.aws.appmesh.GrpcRetryPolicy/httpRetryEvents]))

(s/def :cognitect.aws.appmesh/MeshList (s/coll-of :cognitect.aws.appmesh/MeshRef))

(s/def
  :cognitect.aws.appmesh/VirtualRouterListener
  (s/keys :req-un [:cognitect.aws.appmesh.VirtualRouterListener/portMapping]))

(s/def
  :cognitect.aws.appmesh/ListVirtualRoutersLimit
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.appmesh/VirtualNodeServiceProvider
  (s/keys :req-un [:cognitect.aws.appmesh.VirtualNodeServiceProvider/virtualNodeName]))

(s/def
  :cognitect.aws.appmesh/Listeners
  (s/coll-of :cognitect.aws.appmesh/Listener :min-count 0 :max-count 1))

(s/def
  :cognitect.aws.appmesh/CreateMeshInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.CreateMeshInput/meshName]
    :opt-un
    [:cognitect.aws.appmesh.CreateMeshInput/clientToken
     :cognitect.aws.appmesh.CreateMeshInput/spec
     :cognitect.aws.appmesh.CreateMeshInput/tags]))

(s/def :cognitect.aws.appmesh/VirtualRouterList (s/coll-of :cognitect.aws.appmesh/VirtualRouterRef))

(s/def
  :cognitect.aws.appmesh/UpdateVirtualRouterInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.UpdateVirtualRouterInput/meshName
     :cognitect.aws.appmesh.UpdateVirtualRouterInput/spec
     :cognitect.aws.appmesh.UpdateVirtualRouterInput/virtualRouterName]
    :opt-un
    [:cognitect.aws.appmesh.UpdateVirtualRouterInput/clientToken]))

(s/def
  :cognitect.aws.appmesh/ResourceMetadata
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ResourceMetadata/arn
     :cognitect.aws.appmesh.ResourceMetadata/createdAt
     :cognitect.aws.appmesh.ResourceMetadata/lastUpdatedAt
     :cognitect.aws.appmesh.ResourceMetadata/uid
     :cognitect.aws.appmesh.ResourceMetadata/version]))

(s/def
  :cognitect.aws.appmesh/UpdateRouteOutput
  (s/keys :req-un [:cognitect.aws.appmesh.UpdateRouteOutput/route]))

(s/def :cognitect.aws.appmesh/Logging (s/keys :opt-un [:cognitect.aws.appmesh.Logging/accessLog]))

(s/def
  :cognitect.aws.appmesh/ListRoutesOutput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListRoutesOutput/routes]
    :opt-un
    [:cognitect.aws.appmesh.ListRoutesOutput/nextToken]))

(s/def
  :cognitect.aws.appmesh/DeleteVirtualNodeInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.DeleteVirtualNodeInput/meshName
     :cognitect.aws.appmesh.DeleteVirtualNodeInput/virtualNodeName]))

(s/def
  :cognitect.aws.appmesh/ListRoutesInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListRoutesInput/meshName
     :cognitect.aws.appmesh.ListRoutesInput/virtualRouterName]
    :opt-un
    [:cognitect.aws.appmesh.ListRoutesInput/nextToken
     :cognitect.aws.appmesh.ListRoutesInput/limit]))

(s/def
  :cognitect.aws.appmesh/ListVirtualNodesLimit
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.appmesh/ResourceName
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.appmesh/FilePath
  (s/spec
    (s/and string? #(<= 1 (count %) 255))
    :gen
    (fn []
      (gen/fmap #(apply str %) (gen/bind (gen/choose 1 255) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.appmesh/CreateVirtualNodeOutput
  (s/keys :req-un [:cognitect.aws.appmesh.CreateVirtualNodeOutput/virtualNode]))

(s/def
  :cognitect.aws.appmesh/VirtualNodeSpec
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.VirtualNodeSpec/logging
     :cognitect.aws.appmesh.VirtualNodeSpec/serviceDiscovery
     :cognitect.aws.appmesh.VirtualNodeSpec/backendDefaults
     :cognitect.aws.appmesh.VirtualNodeSpec/listeners
     :cognitect.aws.appmesh.VirtualNodeSpec/backends]))

(s/def
  :cognitect.aws.appmesh/VirtualNodeStatusCode
  (s/spec string? :gen #(s/gen #{"INACTIVE" "ACTIVE" "DELETED"})))

(s/def
  :cognitect.aws.appmesh/ClientPolicyTls
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ClientPolicyTls/validation]
    :opt-un
    [:cognitect.aws.appmesh.ClientPolicyTls/enforce :cognitect.aws.appmesh.ClientPolicyTls/ports]))

(s/def
  :cognitect.aws.appmesh/WeightedTarget
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.WeightedTarget/virtualNode
     :cognitect.aws.appmesh.WeightedTarget/weight]))

(s/def :cognitect.aws.appmesh/String string?)

(s/def
  :cognitect.aws.appmesh/DescribeMeshInput
  (s/keys :req-un [:cognitect.aws.appmesh.DescribeMeshInput/meshName]))

(s/def :cognitect.aws.appmesh/VirtualNodeList (s/coll-of :cognitect.aws.appmesh/VirtualNodeRef))

(s/def
  :cognitect.aws.appmesh/RouteData
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.RouteData/meshName
     :cognitect.aws.appmesh.RouteData/metadata
     :cognitect.aws.appmesh.RouteData/routeName
     :cognitect.aws.appmesh.RouteData/spec
     :cognitect.aws.appmesh.RouteData/status
     :cognitect.aws.appmesh.RouteData/virtualRouterName]))

(s/def
  :cognitect.aws.appmesh/ListenerTlsCertificate
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.ListenerTlsCertificate/acm
     :cognitect.aws.appmesh.ListenerTlsCertificate/file]))

(s/def
  :cognitect.aws.appmesh/TagKeyList
  (s/coll-of :cognitect.aws.appmesh/TagKey :min-count 0 :max-count 50))

(s/def
  :cognitect.aws.appmesh/RouteStatus
  (s/keys :req-un [:cognitect.aws.appmesh.RouteStatus/status]))

(s/def
  :cognitect.aws.appmesh/ListMeshesLimit
  (s/spec (s/and int? #(<= 1 % 100)) :gen #(gen/choose 1 100)))

(s/def
  :cognitect.aws.appmesh/AwsCloudMapInstanceAttributeValue
  (s/spec
    #(re-matches (re-pattern "^([a-zA-Z0-9!-~][ ta-zA-Z0-9!-~]*){0,1}[a-zA-Z0-9!-~]{0,1}$") %)
    :gen
    #(gen/string)))

(s/def
  :cognitect.aws.appmesh/TcpRetryPolicyEvent
  (s/spec string? :gen #(s/gen #{"connection-error"})))

(s/def :cognitect.aws.appmesh/ServiceName string?)

(s/def
  :cognitect.aws.appmesh/PortNumber
  (s/spec (s/and int? #(<= 1 % 65535)) :gen #(gen/choose 1 65535)))

(s/def
  :cognitect.aws.appmesh/RouteSpec
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.RouteSpec/http2Route
     :cognitect.aws.appmesh.RouteSpec/priority
     :cognitect.aws.appmesh.RouteSpec/tcpRoute
     :cognitect.aws.appmesh.RouteSpec/httpRoute
     :cognitect.aws.appmesh.RouteSpec/grpcRoute]))

(s/def :cognitect.aws.appmesh.GrpcRouteMetadataMatchMethod/exact :cognitect.aws.appmesh/HeaderMatch)

(s/def
  :cognitect.aws.appmesh.GrpcRouteMetadataMatchMethod/prefix
  :cognitect.aws.appmesh/HeaderMatch)

(s/def :cognitect.aws.appmesh.GrpcRouteMetadataMatchMethod/range :cognitect.aws.appmesh/MatchRange)

(s/def :cognitect.aws.appmesh.GrpcRouteMetadataMatchMethod/regex :cognitect.aws.appmesh/HeaderMatch)

(s/def
  :cognitect.aws.appmesh.GrpcRouteMetadataMatchMethod/suffix
  :cognitect.aws.appmesh/HeaderMatch)

(s/def :cognitect.aws.appmesh.VirtualNodeStatus/status :cognitect.aws.appmesh/VirtualNodeStatusCode)

(s/def :cognitect.aws.appmesh.UpdateMeshOutput/mesh :cognitect.aws.appmesh/MeshData)

(s/def :cognitect.aws.appmesh.VirtualRouterRef/arn :cognitect.aws.appmesh/Arn)

(s/def :cognitect.aws.appmesh.VirtualRouterRef/meshName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.VirtualRouterRef/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.UpdateVirtualServiceInput/clientToken :cognitect.aws.appmesh/String)

(s/def
  :cognitect.aws.appmesh.UpdateVirtualServiceInput/meshName
  :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.UpdateVirtualServiceInput/spec
  :cognitect.aws.appmesh/VirtualServiceSpec)

(s/def
  :cognitect.aws.appmesh.UpdateVirtualServiceInput/virtualServiceName
  :cognitect.aws.appmesh/ServiceName)

(s/def :cognitect.aws.appmesh.ListTagsForResourceInput/limit :cognitect.aws.appmesh/TagsLimit)

(s/def :cognitect.aws.appmesh.ListTagsForResourceInput/nextToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.ListTagsForResourceInput/resourceArn :cognitect.aws.appmesh/Arn)

(s/def :cognitect.aws.appmesh.ListTagsForResourceOutput/nextToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.ListTagsForResourceOutput/tags :cognitect.aws.appmesh/TagList)

(s/def
  :cognitect.aws.appmesh.ServiceDiscovery/awsCloudMap
  :cognitect.aws.appmesh/AwsCloudMapServiceDiscovery)

(s/def :cognitect.aws.appmesh.ServiceDiscovery/dns :cognitect.aws.appmesh/DnsServiceDiscovery)

(s/def
  :cognitect.aws.appmesh.CreateVirtualRouterOutput/virtualRouter
  :cognitect.aws.appmesh/VirtualRouterData)

(s/def :cognitect.aws.appmesh.MeshStatus/status :cognitect.aws.appmesh/MeshStatusCode)

(s/def :cognitect.aws.appmesh.DescribeRouteOutput/route :cognitect.aws.appmesh/RouteData)

(s/def :cognitect.aws.appmesh.TagRef/key :cognitect.aws.appmesh/TagKey)

(s/def :cognitect.aws.appmesh.TagRef/value :cognitect.aws.appmesh/TagValue)

(s/def
  :cognitect.aws.appmesh.TlsValidationContextFileTrust/certificateChain
  :cognitect.aws.appmesh/FilePath)

(s/def
  :cognitect.aws.appmesh.DescribeVirtualRouterInput/meshName
  :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DescribeVirtualRouterInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.VirtualServiceProvider/virtualNode
  :cognitect.aws.appmesh/VirtualNodeServiceProvider)

(s/def
  :cognitect.aws.appmesh.VirtualServiceProvider/virtualRouter
  :cognitect.aws.appmesh/VirtualRouterServiceProvider)

(s/def :cognitect.aws.appmesh.TcpRoute/action :cognitect.aws.appmesh/TcpRouteAction)

(s/def :cognitect.aws.appmesh.GrpcRouteMatch/metadata :cognitect.aws.appmesh/GrpcRouteMetadataList)

(s/def :cognitect.aws.appmesh.GrpcRouteMatch/methodName :cognitect.aws.appmesh/MethodName)

(s/def :cognitect.aws.appmesh.GrpcRouteMatch/serviceName :cognitect.aws.appmesh/ServiceName)

(s/def :cognitect.aws.appmesh.BackendDefaults/clientPolicy :cognitect.aws.appmesh/ClientPolicy)

(s/def :cognitect.aws.appmesh.VirtualNodeRef/arn :cognitect.aws.appmesh/Arn)

(s/def :cognitect.aws.appmesh.VirtualNodeRef/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.VirtualNodeRef/virtualNodeName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.AwsCloudMapServiceDiscovery/attributes
  :cognitect.aws.appmesh/AwsCloudMapInstanceAttributes)

(s/def
  :cognitect.aws.appmesh.AwsCloudMapServiceDiscovery/namespaceName
  :cognitect.aws.appmesh/AwsCloudMapName)

(s/def
  :cognitect.aws.appmesh.AwsCloudMapServiceDiscovery/serviceName
  :cognitect.aws.appmesh/AwsCloudMapName)

(s/def :cognitect.aws.appmesh.CreateRouteOutput/route :cognitect.aws.appmesh/RouteData)

(s/def
  :cognitect.aws.appmesh.VirtualRouterSpec/listeners
  :cognitect.aws.appmesh/VirtualRouterListeners)

(s/def
  :cognitect.aws.appmesh.DescribeVirtualNodeOutput/virtualNode
  :cognitect.aws.appmesh/VirtualNodeData)

(s/def :cognitect.aws.appmesh.MatchRange/end :cognitect.aws.appmesh/Long)

(s/def :cognitect.aws.appmesh.MatchRange/start :cognitect.aws.appmesh/Long)

(s/def
  :cognitect.aws.appmesh.VirtualServiceSpec/provider
  :cognitect.aws.appmesh/VirtualServiceProvider)

(s/def
  :cognitect.aws.appmesh.ListenerTlsFileCertificate/certificateChain
  :cognitect.aws.appmesh/FilePath)

(s/def :cognitect.aws.appmesh.ListenerTlsFileCertificate/privateKey :cognitect.aws.appmesh/FilePath)

(s/def :cognitect.aws.appmesh.CreateVirtualNodeInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.CreateVirtualNodeInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.CreateVirtualNodeInput/spec :cognitect.aws.appmesh/VirtualNodeSpec)

(s/def :cognitect.aws.appmesh.CreateVirtualNodeInput/tags :cognitect.aws.appmesh/TagList)

(s/def
  :cognitect.aws.appmesh.CreateVirtualNodeInput/virtualNodeName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.AccessLog/file :cognitect.aws.appmesh/FileAccessLog)

(s/def :cognitect.aws.appmesh.DeleteMeshInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.MeshRef/arn :cognitect.aws.appmesh/Arn)

(s/def :cognitect.aws.appmesh.MeshRef/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.UpdateRouteInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.UpdateRouteInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.UpdateRouteInput/routeName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.UpdateRouteInput/spec :cognitect.aws.appmesh/RouteSpec)

(s/def
  :cognitect.aws.appmesh.UpdateRouteInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.Listener/healthCheck :cognitect.aws.appmesh/HealthCheckPolicy)

(s/def :cognitect.aws.appmesh.Listener/portMapping :cognitect.aws.appmesh/PortMapping)

(s/def :cognitect.aws.appmesh.Listener/tls :cognitect.aws.appmesh/ListenerTls)

(s/def
  :cognitect.aws.appmesh.VirtualServiceStatus/status
  :cognitect.aws.appmesh/VirtualServiceStatusCode)

(s/def
  :cognitect.aws.appmesh.UpdateVirtualRouterOutput/virtualRouter
  :cognitect.aws.appmesh/VirtualRouterData)

(s/def
  :cognitect.aws.appmesh.GrpcRouteAction/weightedTargets
  :cognitect.aws.appmesh/WeightedTargets)

(s/def :cognitect.aws.appmesh.ListVirtualServicesOutput/nextToken :cognitect.aws.appmesh/String)

(s/def
  :cognitect.aws.appmesh.ListVirtualServicesOutput/virtualServices
  :cognitect.aws.appmesh/VirtualServiceList)

(s/def
  :cognitect.aws.appmesh.DeleteVirtualServiceInput/meshName
  :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DeleteVirtualServiceInput/virtualServiceName
  :cognitect.aws.appmesh/ServiceName)

(s/def :cognitect.aws.appmesh.ListMeshesOutput/meshes :cognitect.aws.appmesh/MeshList)

(s/def :cognitect.aws.appmesh.ListMeshesOutput/nextToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.TcpRouteAction/weightedTargets :cognitect.aws.appmesh/WeightedTargets)

(s/def
  :cognitect.aws.appmesh.UpdateVirtualNodeOutput/virtualNode
  :cognitect.aws.appmesh/VirtualNodeData)

(s/def
  :cognitect.aws.appmesh.TlsValidationContextAcmTrust/certificateAuthorityArns
  :cognitect.aws.appmesh/CertificateAuthorityArns)

(s/def
  :cognitect.aws.appmesh.HttpRouteAction/weightedTargets
  :cognitect.aws.appmesh/WeightedTargets)

(s/def
  :cognitect.aws.appmesh.CreateVirtualServiceOutput/virtualService
  :cognitect.aws.appmesh/VirtualServiceData)

(s/def
  :cognitect.aws.appmesh.TlsValidationContextTrust/acm
  :cognitect.aws.appmesh/TlsValidationContextAcmTrust)

(s/def
  :cognitect.aws.appmesh.TlsValidationContextTrust/file
  :cognitect.aws.appmesh/TlsValidationContextFileTrust)

(s/def :cognitect.aws.appmesh.TagResourceInput/resourceArn :cognitect.aws.appmesh/Arn)

(s/def :cognitect.aws.appmesh.TagResourceInput/tags :cognitect.aws.appmesh/TagList)

(s/def :cognitect.aws.appmesh.VirtualRouterData/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.VirtualRouterData/metadata :cognitect.aws.appmesh/ResourceMetadata)

(s/def :cognitect.aws.appmesh.VirtualRouterData/spec :cognitect.aws.appmesh/VirtualRouterSpec)

(s/def :cognitect.aws.appmesh.VirtualRouterData/status :cognitect.aws.appmesh/VirtualRouterStatus)

(s/def
  :cognitect.aws.appmesh.VirtualRouterData/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.GrpcRoute/action :cognitect.aws.appmesh/GrpcRouteAction)

(s/def :cognitect.aws.appmesh.GrpcRoute/match :cognitect.aws.appmesh/GrpcRouteMatch)

(s/def :cognitect.aws.appmesh.GrpcRoute/retryPolicy :cognitect.aws.appmesh/GrpcRetryPolicy)

(s/def :cognitect.aws.appmesh.PortMapping/port :cognitect.aws.appmesh/PortNumber)

(s/def :cognitect.aws.appmesh.PortMapping/protocol :cognitect.aws.appmesh/PortProtocol)

(s/def :cognitect.aws.appmesh.ListMeshesInput/limit :cognitect.aws.appmesh/ListMeshesLimit)

(s/def :cognitect.aws.appmesh.ListMeshesInput/nextToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.DeleteVirtualRouterInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DeleteVirtualRouterInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.MeshSpec/egressFilter :cognitect.aws.appmesh/EgressFilter)

(s/def :cognitect.aws.appmesh.HttpRoute/action :cognitect.aws.appmesh/HttpRouteAction)

(s/def :cognitect.aws.appmesh.HttpRoute/match :cognitect.aws.appmesh/HttpRouteMatch)

(s/def :cognitect.aws.appmesh.HttpRoute/retryPolicy :cognitect.aws.appmesh/HttpRetryPolicy)

(s/def
  :cognitect.aws.appmesh.ListVirtualServicesInput/limit
  :cognitect.aws.appmesh/ListVirtualServicesLimit)

(s/def :cognitect.aws.appmesh.ListVirtualServicesInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.ListVirtualServicesInput/nextToken :cognitect.aws.appmesh/String)

(s/def
  :cognitect.aws.appmesh.HttpRetryPolicy/httpRetryEvents
  :cognitect.aws.appmesh/HttpRetryPolicyEvents)

(s/def :cognitect.aws.appmesh.HttpRetryPolicy/maxRetries :cognitect.aws.appmesh/MaxRetries)

(s/def :cognitect.aws.appmesh.HttpRetryPolicy/perRetryTimeout :cognitect.aws.appmesh/Duration)

(s/def
  :cognitect.aws.appmesh.HttpRetryPolicy/tcpRetryEvents
  :cognitect.aws.appmesh/TcpRetryPolicyEvents)

(s/def
  :cognitect.aws.appmesh.DeleteVirtualServiceOutput/virtualService
  :cognitect.aws.appmesh/VirtualServiceData)

(s/def :cognitect.aws.appmesh.CreateMeshOutput/mesh :cognitect.aws.appmesh/MeshData)

(s/def
  :cognitect.aws.appmesh.ListVirtualRoutersInput/limit
  :cognitect.aws.appmesh/ListVirtualRoutersLimit)

(s/def :cognitect.aws.appmesh.ListVirtualRoutersInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.ListVirtualRoutersInput/nextToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.ClientPolicy/tls :cognitect.aws.appmesh/ClientPolicyTls)

(s/def
  :cognitect.aws.appmesh.UpdateVirtualServiceOutput/virtualService
  :cognitect.aws.appmesh/VirtualServiceData)

(s/def :cognitect.aws.appmesh.DescribeRouteInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.DescribeRouteInput/routeName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DescribeRouteInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.HttpRouteMatch/headers :cognitect.aws.appmesh/HttpRouteHeaders)

(s/def :cognitect.aws.appmesh.HttpRouteMatch/method :cognitect.aws.appmesh/HttpMethod)

(s/def :cognitect.aws.appmesh.HttpRouteMatch/prefix :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.HttpRouteMatch/scheme :cognitect.aws.appmesh/HttpScheme)

(s/def :cognitect.aws.appmesh.CreateVirtualRouterInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.CreateVirtualRouterInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.CreateVirtualRouterInput/spec
  :cognitect.aws.appmesh/VirtualRouterSpec)

(s/def :cognitect.aws.appmesh.CreateVirtualRouterInput/tags :cognitect.aws.appmesh/TagList)

(s/def
  :cognitect.aws.appmesh.CreateVirtualRouterInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.CreateRouteInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.CreateRouteInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.CreateRouteInput/routeName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.CreateRouteInput/spec :cognitect.aws.appmesh/RouteSpec)

(s/def :cognitect.aws.appmesh.CreateRouteInput/tags :cognitect.aws.appmesh/TagList)

(s/def
  :cognitect.aws.appmesh.CreateRouteInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.UpdateMeshInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.UpdateMeshInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.UpdateMeshInput/spec :cognitect.aws.appmesh/MeshSpec)

(s/def :cognitect.aws.appmesh.Backend/virtualService :cognitect.aws.appmesh/VirtualServiceBackend)

(s/def
  :cognitect.aws.appmesh.VirtualServiceBackend/clientPolicy
  :cognitect.aws.appmesh/ClientPolicy)

(s/def
  :cognitect.aws.appmesh.VirtualServiceBackend/virtualServiceName
  :cognitect.aws.appmesh/ServiceName)

(s/def :cognitect.aws.appmesh.ListenerTls/certificate :cognitect.aws.appmesh/ListenerTlsCertificate)

(s/def :cognitect.aws.appmesh.ListenerTls/mode :cognitect.aws.appmesh/ListenerTlsMode)

(s/def :cognitect.aws.appmesh.RouteRef/arn :cognitect.aws.appmesh/Arn)

(s/def :cognitect.aws.appmesh.RouteRef/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.RouteRef/routeName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.RouteRef/virtualRouterName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.DeleteMeshOutput/mesh :cognitect.aws.appmesh/MeshData)

(s/def :cognitect.aws.appmesh.EgressFilter/type :cognitect.aws.appmesh/EgressFilterType)

(s/def
  :cognitect.aws.appmesh.DescribeVirtualServiceInput/meshName
  :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DescribeVirtualServiceInput/virtualServiceName
  :cognitect.aws.appmesh/ServiceName)

(s/def :cognitect.aws.appmesh.ListVirtualNodesOutput/nextToken :cognitect.aws.appmesh/String)

(s/def
  :cognitect.aws.appmesh.ListVirtualNodesOutput/virtualNodes
  :cognitect.aws.appmesh/VirtualNodeList)

(s/def :cognitect.aws.appmesh.ListenerTlsAcmCertificate/certificateArn :cognitect.aws.appmesh/Arn)

(s/def
  :cognitect.aws.appmesh.TlsValidationContext/trust
  :cognitect.aws.appmesh/TlsValidationContextTrust)

(s/def :cognitect.aws.appmesh.MeshData/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.MeshData/metadata :cognitect.aws.appmesh/ResourceMetadata)

(s/def :cognitect.aws.appmesh.MeshData/spec :cognitect.aws.appmesh/MeshSpec)

(s/def :cognitect.aws.appmesh.MeshData/status :cognitect.aws.appmesh/MeshStatus)

(s/def :cognitect.aws.appmesh.VirtualServiceRef/arn :cognitect.aws.appmesh/Arn)

(s/def :cognitect.aws.appmesh.VirtualServiceRef/meshName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.VirtualServiceRef/virtualServiceName
  :cognitect.aws.appmesh/ServiceName)

(s/def
  :cognitect.aws.appmesh.DeleteVirtualRouterOutput/virtualRouter
  :cognitect.aws.appmesh/VirtualRouterData)

(s/def
  :cognitect.aws.appmesh.AwsCloudMapInstanceAttribute/key
  :cognitect.aws.appmesh/AwsCloudMapInstanceAttributeKey)

(s/def
  :cognitect.aws.appmesh.AwsCloudMapInstanceAttribute/value
  :cognitect.aws.appmesh/AwsCloudMapInstanceAttributeValue)

(s/def :cognitect.aws.appmesh.UntagResourceInput/resourceArn :cognitect.aws.appmesh/Arn)

(s/def :cognitect.aws.appmesh.UntagResourceInput/tagKeys :cognitect.aws.appmesh/TagKeyList)

(s/def
  :cognitect.aws.appmesh.HealthCheckPolicy/healthyThreshold
  :cognitect.aws.appmesh/HealthCheckThreshold)

(s/def
  :cognitect.aws.appmesh.HealthCheckPolicy/intervalMillis
  :cognitect.aws.appmesh/HealthCheckIntervalMillis)

(s/def :cognitect.aws.appmesh.HealthCheckPolicy/path :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.HealthCheckPolicy/port :cognitect.aws.appmesh/PortNumber)

(s/def :cognitect.aws.appmesh.HealthCheckPolicy/protocol :cognitect.aws.appmesh/PortProtocol)

(s/def
  :cognitect.aws.appmesh.HealthCheckPolicy/timeoutMillis
  :cognitect.aws.appmesh/HealthCheckTimeoutMillis)

(s/def
  :cognitect.aws.appmesh.HealthCheckPolicy/unhealthyThreshold
  :cognitect.aws.appmesh/HealthCheckThreshold)

(s/def :cognitect.aws.appmesh.GrpcRouteMetadata/invert :cognitect.aws.appmesh/Boolean)

(s/def
  :cognitect.aws.appmesh.GrpcRouteMetadata/match
  :cognitect.aws.appmesh/GrpcRouteMetadataMatchMethod)

(s/def :cognitect.aws.appmesh.GrpcRouteMetadata/name :cognitect.aws.appmesh/HeaderName)

(s/def :cognitect.aws.appmesh.DeleteRouteInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.DeleteRouteInput/routeName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DeleteRouteInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DescribeVirtualRouterOutput/virtualRouter
  :cognitect.aws.appmesh/VirtualRouterData)

(s/def
  :cognitect.aws.appmesh.VirtualRouterServiceProvider/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.DescribeMeshOutput/mesh :cognitect.aws.appmesh/MeshData)

(s/def :cognitect.aws.appmesh.DeleteRouteOutput/route :cognitect.aws.appmesh/RouteData)

(s/def :cognitect.aws.appmesh.ListVirtualRoutersOutput/nextToken :cognitect.aws.appmesh/String)

(s/def
  :cognitect.aws.appmesh.ListVirtualRoutersOutput/virtualRouters
  :cognitect.aws.appmesh/VirtualRouterList)

(s/def
  :cognitect.aws.appmesh.DescribeVirtualServiceOutput/virtualService
  :cognitect.aws.appmesh/VirtualServiceData)

(s/def :cognitect.aws.appmesh.HttpRouteHeader/invert :cognitect.aws.appmesh/Boolean)

(s/def :cognitect.aws.appmesh.HttpRouteHeader/match :cognitect.aws.appmesh/HeaderMatchMethod)

(s/def :cognitect.aws.appmesh.HttpRouteHeader/name :cognitect.aws.appmesh/HeaderName)

(s/def :cognitect.aws.appmesh.UpdateVirtualNodeInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.UpdateVirtualNodeInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.UpdateVirtualNodeInput/spec :cognitect.aws.appmesh/VirtualNodeSpec)

(s/def
  :cognitect.aws.appmesh.UpdateVirtualNodeInput/virtualNodeName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.VirtualServiceData/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.VirtualServiceData/metadata :cognitect.aws.appmesh/ResourceMetadata)

(s/def :cognitect.aws.appmesh.VirtualServiceData/spec :cognitect.aws.appmesh/VirtualServiceSpec)

(s/def :cognitect.aws.appmesh.VirtualServiceData/status :cognitect.aws.appmesh/VirtualServiceStatus)

(s/def
  :cognitect.aws.appmesh.VirtualServiceData/virtualServiceName
  :cognitect.aws.appmesh/ServiceName)

(s/def
  :cognitect.aws.appmesh.DeleteVirtualNodeOutput/virtualNode
  :cognitect.aws.appmesh/VirtualNodeData)

(s/def :cognitect.aws.appmesh.VirtualNodeData/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.VirtualNodeData/metadata :cognitect.aws.appmesh/ResourceMetadata)

(s/def :cognitect.aws.appmesh.VirtualNodeData/spec :cognitect.aws.appmesh/VirtualNodeSpec)

(s/def :cognitect.aws.appmesh.VirtualNodeData/status :cognitect.aws.appmesh/VirtualNodeStatus)

(s/def :cognitect.aws.appmesh.VirtualNodeData/virtualNodeName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.DescribeVirtualNodeInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DescribeVirtualNodeInput/virtualNodeName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.Duration/unit :cognitect.aws.appmesh/DurationUnit)

(s/def :cognitect.aws.appmesh.Duration/value :cognitect.aws.appmesh/DurationValue)

(s/def
  :cognitect.aws.appmesh.ListVirtualNodesInput/limit
  :cognitect.aws.appmesh/ListVirtualNodesLimit)

(s/def :cognitect.aws.appmesh.ListVirtualNodesInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.ListVirtualNodesInput/nextToken :cognitect.aws.appmesh/String)

(s/def
  :cognitect.aws.appmesh.VirtualRouterStatus/status
  :cognitect.aws.appmesh/VirtualRouterStatusCode)

(s/def :cognitect.aws.appmesh.FileAccessLog/path :cognitect.aws.appmesh/FilePath)

(s/def :cognitect.aws.appmesh.HeaderMatchMethod/exact :cognitect.aws.appmesh/HeaderMatch)

(s/def :cognitect.aws.appmesh.HeaderMatchMethod/prefix :cognitect.aws.appmesh/HeaderMatch)

(s/def :cognitect.aws.appmesh.HeaderMatchMethod/range :cognitect.aws.appmesh/MatchRange)

(s/def :cognitect.aws.appmesh.HeaderMatchMethod/regex :cognitect.aws.appmesh/HeaderMatch)

(s/def :cognitect.aws.appmesh.HeaderMatchMethod/suffix :cognitect.aws.appmesh/HeaderMatch)

(s/def :cognitect.aws.appmesh.DnsServiceDiscovery/hostname :cognitect.aws.appmesh/Hostname)

(s/def :cognitect.aws.appmesh.CreateVirtualServiceInput/clientToken :cognitect.aws.appmesh/String)

(s/def
  :cognitect.aws.appmesh.CreateVirtualServiceInput/meshName
  :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.CreateVirtualServiceInput/spec
  :cognitect.aws.appmesh/VirtualServiceSpec)

(s/def :cognitect.aws.appmesh.CreateVirtualServiceInput/tags :cognitect.aws.appmesh/TagList)

(s/def
  :cognitect.aws.appmesh.CreateVirtualServiceInput/virtualServiceName
  :cognitect.aws.appmesh/ServiceName)

(s/def
  :cognitect.aws.appmesh.GrpcRetryPolicy/grpcRetryEvents
  :cognitect.aws.appmesh/GrpcRetryPolicyEvents)

(s/def
  :cognitect.aws.appmesh.GrpcRetryPolicy/httpRetryEvents
  :cognitect.aws.appmesh/HttpRetryPolicyEvents)

(s/def :cognitect.aws.appmesh.GrpcRetryPolicy/maxRetries :cognitect.aws.appmesh/MaxRetries)

(s/def :cognitect.aws.appmesh.GrpcRetryPolicy/perRetryTimeout :cognitect.aws.appmesh/Duration)

(s/def
  :cognitect.aws.appmesh.GrpcRetryPolicy/tcpRetryEvents
  :cognitect.aws.appmesh/TcpRetryPolicyEvents)

(s/def :cognitect.aws.appmesh.VirtualRouterListener/portMapping :cognitect.aws.appmesh/PortMapping)

(s/def
  :cognitect.aws.appmesh.VirtualNodeServiceProvider/virtualNodeName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.CreateMeshInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.CreateMeshInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.CreateMeshInput/spec :cognitect.aws.appmesh/MeshSpec)

(s/def :cognitect.aws.appmesh.CreateMeshInput/tags :cognitect.aws.appmesh/TagList)

(s/def :cognitect.aws.appmesh.UpdateVirtualRouterInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.UpdateVirtualRouterInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.UpdateVirtualRouterInput/spec
  :cognitect.aws.appmesh/VirtualRouterSpec)

(s/def
  :cognitect.aws.appmesh.UpdateVirtualRouterInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.ResourceMetadata/arn :cognitect.aws.appmesh/Arn)

(s/def :cognitect.aws.appmesh.ResourceMetadata/createdAt :cognitect.aws.appmesh/Timestamp)

(s/def :cognitect.aws.appmesh.ResourceMetadata/lastUpdatedAt :cognitect.aws.appmesh/Timestamp)

(s/def :cognitect.aws.appmesh.ResourceMetadata/uid :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.ResourceMetadata/version :cognitect.aws.appmesh/Long)

(s/def :cognitect.aws.appmesh.UpdateRouteOutput/route :cognitect.aws.appmesh/RouteData)

(s/def :cognitect.aws.appmesh.Logging/accessLog :cognitect.aws.appmesh/AccessLog)

(s/def :cognitect.aws.appmesh.ListRoutesOutput/nextToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.ListRoutesOutput/routes :cognitect.aws.appmesh/RouteList)

(s/def :cognitect.aws.appmesh.DeleteVirtualNodeInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DeleteVirtualNodeInput/virtualNodeName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.ListRoutesInput/limit :cognitect.aws.appmesh/ListRoutesLimit)

(s/def :cognitect.aws.appmesh.ListRoutesInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.ListRoutesInput/nextToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.ListRoutesInput/virtualRouterName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.CreateVirtualNodeOutput/virtualNode
  :cognitect.aws.appmesh/VirtualNodeData)

(s/def
  :cognitect.aws.appmesh.VirtualNodeSpec/backendDefaults
  :cognitect.aws.appmesh/BackendDefaults)

(s/def :cognitect.aws.appmesh.VirtualNodeSpec/backends :cognitect.aws.appmesh/Backends)

(s/def :cognitect.aws.appmesh.VirtualNodeSpec/listeners :cognitect.aws.appmesh/Listeners)

(s/def :cognitect.aws.appmesh.VirtualNodeSpec/logging :cognitect.aws.appmesh/Logging)

(s/def
  :cognitect.aws.appmesh.VirtualNodeSpec/serviceDiscovery
  :cognitect.aws.appmesh/ServiceDiscovery)

(s/def :cognitect.aws.appmesh.ClientPolicyTls/enforce :cognitect.aws.appmesh/Boolean)

(s/def :cognitect.aws.appmesh.ClientPolicyTls/ports :cognitect.aws.appmesh/PortSet)

(s/def
  :cognitect.aws.appmesh.ClientPolicyTls/validation
  :cognitect.aws.appmesh/TlsValidationContext)

(s/def :cognitect.aws.appmesh.WeightedTarget/virtualNode :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.WeightedTarget/weight :cognitect.aws.appmesh/PercentInt)

(s/def :cognitect.aws.appmesh.DescribeMeshInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.RouteData/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.RouteData/metadata :cognitect.aws.appmesh/ResourceMetadata)

(s/def :cognitect.aws.appmesh.RouteData/routeName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.RouteData/spec :cognitect.aws.appmesh/RouteSpec)

(s/def :cognitect.aws.appmesh.RouteData/status :cognitect.aws.appmesh/RouteStatus)

(s/def :cognitect.aws.appmesh.RouteData/virtualRouterName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.ListenerTlsCertificate/acm
  :cognitect.aws.appmesh/ListenerTlsAcmCertificate)

(s/def
  :cognitect.aws.appmesh.ListenerTlsCertificate/file
  :cognitect.aws.appmesh/ListenerTlsFileCertificate)

(s/def :cognitect.aws.appmesh.RouteStatus/status :cognitect.aws.appmesh/RouteStatusCode)

(s/def :cognitect.aws.appmesh.RouteSpec/grpcRoute :cognitect.aws.appmesh/GrpcRoute)

(s/def :cognitect.aws.appmesh.RouteSpec/http2Route :cognitect.aws.appmesh/HttpRoute)

(s/def :cognitect.aws.appmesh.RouteSpec/httpRoute :cognitect.aws.appmesh/HttpRoute)

(s/def :cognitect.aws.appmesh.RouteSpec/priority :cognitect.aws.appmesh/RoutePriority)

(s/def :cognitect.aws.appmesh.RouteSpec/tcpRoute :cognitect.aws.appmesh/TcpRoute)

