;; Copyright (c) Cognitect, Inc.
;; All rights reserved.

(ns cognitect.aws.appmesh.specs
  (:require [clojure.spec.alpha :as s] [clojure.spec.gen.alpha :as gen]))

(s/def :cognitect.aws/client map?)

(s/def :core.async/channel any?)

(s/def
  :cognitect.aws.appmesh/VirtualNodeStatus
  (s/keys :opt-un [:cognitect.aws.appmesh.VirtualNodeStatus/status]))

(s/def
  :cognitect.aws.appmesh/VirtualRouterRef
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.VirtualRouterRef/arn
     :cognitect.aws.appmesh.VirtualRouterRef/meshName
     :cognitect.aws.appmesh.VirtualRouterRef/virtualRouterName]))

(s/def :cognitect.aws.appmesh/PortProtocol #{"http" "tcp"})

(s/def
  :cognitect.aws.appmesh/ServiceDiscovery
  (s/keys :opt-un [:cognitect.aws.appmesh.ServiceDiscovery/dns]))

(s/def
  :cognitect.aws.appmesh/CreateVirtualRouterOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.CreateVirtualRouterOutput/virtualRouter]))

(s/def
  :cognitect.aws.appmesh/MeshStatus
  (s/keys :opt-un [:cognitect.aws.appmesh.MeshStatus/status]))

(s/def
  :cognitect.aws.appmesh/DescribeRouteOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.DescribeRouteOutput/route]))

(s/def
  :cognitect.aws.appmesh/DurationMillis
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.appmesh/DescribeVirtualRouterInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.DescribeVirtualRouterInput/meshName
     :cognitect.aws.appmesh.DescribeVirtualRouterInput/virtualRouterName]))

(s/def :cognitect.aws.appmesh/RouteList (s/coll-of :cognitect.aws.appmesh/RouteRef))

(s/def
  :cognitect.aws.appmesh/VirtualNodeRef
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.VirtualNodeRef/arn
     :cognitect.aws.appmesh.VirtualNodeRef/meshName
     :cognitect.aws.appmesh.VirtualNodeRef/virtualNodeName]))

(s/def
  :cognitect.aws.appmesh/CreateRouteOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.CreateRouteOutput/route]))

(s/def
  :cognitect.aws.appmesh/VirtualRouterSpec
  (s/keys :opt-un [:cognitect.aws.appmesh.VirtualRouterSpec/serviceNames]))

(s/def
  :cognitect.aws.appmesh/DescribeVirtualNodeOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.DescribeVirtualNodeOutput/virtualNode]))

(s/def
  :cognitect.aws.appmesh/CreateVirtualNodeInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.CreateVirtualNodeInput/meshName
     :cognitect.aws.appmesh.CreateVirtualNodeInput/spec
     :cognitect.aws.appmesh.CreateVirtualNodeInput/virtualNodeName]
    :opt-un
    [:cognitect.aws.appmesh.CreateVirtualNodeInput/clientToken]))

(s/def
  :cognitect.aws.appmesh/DeleteMeshInput
  (s/keys :req-un [:cognitect.aws.appmesh.DeleteMeshInput/meshName]))

(s/def
  :cognitect.aws.appmesh/MeshRef
  (s/keys :opt-un [:cognitect.aws.appmesh.MeshRef/arn :cognitect.aws.appmesh.MeshRef/meshName]))

(s/def
  :cognitect.aws.appmesh/UpdateRouteInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.UpdateRouteInput/meshName
     :cognitect.aws.appmesh.UpdateRouteInput/routeName
     :cognitect.aws.appmesh.UpdateRouteInput/spec
     :cognitect.aws.appmesh.UpdateRouteInput/virtualRouterName]
    :opt-un
    [:cognitect.aws.appmesh.UpdateRouteInput/clientToken]))

(s/def
  :cognitect.aws.appmesh/Listener
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.Listener/healthCheck :cognitect.aws.appmesh.Listener/portMapping]))

(s/def
  :cognitect.aws.appmesh/NonNegativeInt
  (s/with-gen (s/and int? #(<= 0 %)) #(gen/choose (or 0 Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.appmesh/UpdateVirtualRouterOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.UpdateVirtualRouterOutput/virtualRouter]))

(s/def
  :cognitect.aws.appmesh/ListMeshesOutput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListMeshesOutput/meshes]
    :opt-un
    [:cognitect.aws.appmesh.ListMeshesOutput/nextToken]))

(s/def
  :cognitect.aws.appmesh/UpdateVirtualNodeOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.UpdateVirtualNodeOutput/virtualNode]))

(s/def
  :cognitect.aws.appmesh/HttpRouteAction
  (s/keys :opt-un [:cognitect.aws.appmesh.HttpRouteAction/weightedTargets]))

(s/def
  :cognitect.aws.appmesh/VirtualRouterData
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.VirtualRouterData/meshName
     :cognitect.aws.appmesh.VirtualRouterData/virtualRouterName]
    :opt-un
    [:cognitect.aws.appmesh.VirtualRouterData/spec
     :cognitect.aws.appmesh.VirtualRouterData/status
     :cognitect.aws.appmesh.VirtualRouterData/metadata]))

(s/def
  :cognitect.aws.appmesh/PortMapping
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.PortMapping/protocol :cognitect.aws.appmesh.PortMapping/port]))

(s/def
  :cognitect.aws.appmesh/ListMeshesInput
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.ListMeshesInput/nextToken
     :cognitect.aws.appmesh.ListMeshesInput/limit]))

(s/def
  :cognitect.aws.appmesh/PercentInt
  (s/with-gen
    (s/and int? #(<= 0 % 100))
    #(gen/choose (or 0 Long/MIN_VALUE) (or 100 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.appmesh/DeleteVirtualRouterInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.DeleteVirtualRouterInput/meshName
     :cognitect.aws.appmesh.DeleteVirtualRouterInput/virtualRouterName]))

(s/def
  :cognitect.aws.appmesh/HttpRoute
  (s/keys :opt-un [:cognitect.aws.appmesh.HttpRoute/action :cognitect.aws.appmesh.HttpRoute/match]))

(s/def :cognitect.aws.appmesh/Backends (s/coll-of :cognitect.aws.appmesh/ServiceName))

(s/def
  :cognitect.aws.appmesh/CreateMeshOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.CreateMeshOutput/mesh]))

(s/def
  :cognitect.aws.appmesh/ListVirtualRoutersInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListVirtualRoutersInput/meshName]
    :opt-un
    [:cognitect.aws.appmesh.ListVirtualRoutersInput/nextToken
     :cognitect.aws.appmesh.ListVirtualRoutersInput/limit]))

(s/def
  :cognitect.aws.appmesh/DescribeRouteInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.DescribeRouteInput/meshName
     :cognitect.aws.appmesh.DescribeRouteInput/routeName
     :cognitect.aws.appmesh.DescribeRouteInput/virtualRouterName]))

(s/def
  :cognitect.aws.appmesh/HttpRouteMatch
  (s/keys :opt-un [:cognitect.aws.appmesh.HttpRouteMatch/prefix]))

(s/def
  :cognitect.aws.appmesh/CreateVirtualRouterInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.CreateVirtualRouterInput/meshName
     :cognitect.aws.appmesh.CreateVirtualRouterInput/spec
     :cognitect.aws.appmesh.CreateVirtualRouterInput/virtualRouterName]
    :opt-un
    [:cognitect.aws.appmesh.CreateVirtualRouterInput/clientToken]))

(s/def
  :cognitect.aws.appmesh/CreateRouteInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.CreateRouteInput/meshName
     :cognitect.aws.appmesh.CreateRouteInput/routeName
     :cognitect.aws.appmesh.CreateRouteInput/spec
     :cognitect.aws.appmesh.CreateRouteInput/virtualRouterName]
    :opt-un
    [:cognitect.aws.appmesh.CreateRouteInput/clientToken]))

(s/def
  :cognitect.aws.appmesh/RouteRef
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.RouteRef/routeName
     :cognitect.aws.appmesh.RouteRef/arn
     :cognitect.aws.appmesh.RouteRef/meshName
     :cognitect.aws.appmesh.RouteRef/virtualRouterName]))

(s/def
  :cognitect.aws.appmesh/DeleteMeshOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.DeleteMeshOutput/mesh]))

(s/def
  :cognitect.aws.appmesh/ListVirtualNodesOutput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListVirtualNodesOutput/virtualNodes]
    :opt-un
    [:cognitect.aws.appmesh.ListVirtualNodesOutput/nextToken]))

(s/def
  :cognitect.aws.appmesh/MeshData
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.MeshData/meshName :cognitect.aws.appmesh.MeshData/metadata]
    :opt-un
    [:cognitect.aws.appmesh.MeshData/status]))

(s/def
  :cognitect.aws.appmesh/DeleteVirtualRouterOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.DeleteVirtualRouterOutput/virtualRouter]))

(s/def :cognitect.aws.appmesh/WeightedTargets (s/coll-of :cognitect.aws.appmesh/WeightedTarget))

(s/def
  :cognitect.aws.appmesh/HealthCheckPolicy
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.HealthCheckPolicy/protocol
     :cognitect.aws.appmesh.HealthCheckPolicy/healthyThreshold
     :cognitect.aws.appmesh.HealthCheckPolicy/intervalMillis
     :cognitect.aws.appmesh.HealthCheckPolicy/path
     :cognitect.aws.appmesh.HealthCheckPolicy/unhealthyThreshold
     :cognitect.aws.appmesh.HealthCheckPolicy/timeoutMillis
     :cognitect.aws.appmesh.HealthCheckPolicy/port]))

(s/def
  :cognitect.aws.appmesh/DeleteRouteInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.DeleteRouteInput/meshName
     :cognitect.aws.appmesh.DeleteRouteInput/routeName
     :cognitect.aws.appmesh.DeleteRouteInput/virtualRouterName]))

(s/def
  :cognitect.aws.appmesh/DescribeVirtualRouterOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.DescribeVirtualRouterOutput/virtualRouter]))

(s/def :cognitect.aws.appmesh/RouteStatusCode #{"INACTIVE" "ACTIVE" "DELETED"})

(s/def
  :cognitect.aws.appmesh/DescribeMeshOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.DescribeMeshOutput/mesh]))

(s/def
  :cognitect.aws.appmesh/DeleteRouteOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.DeleteRouteOutput/route]))

(s/def
  :cognitect.aws.appmesh/ListVirtualRoutersOutput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListVirtualRoutersOutput/virtualRouters]
    :opt-un
    [:cognitect.aws.appmesh.ListVirtualRoutersOutput/nextToken]))

(s/def
  :cognitect.aws.appmesh/Long
  (s/with-gen int? #(gen/choose (or nil Long/MIN_VALUE) (or nil Long/MAX_VALUE))))

(s/def
  :cognitect.aws.appmesh/ListRoutesLimit
  (s/with-gen
    (s/and int? #(<= 1 % 100))
    #(gen/choose (or 1 Long/MIN_VALUE) (or 100 Long/MAX_VALUE))))

(s/def :cognitect.aws.appmesh/Arn string?)

(s/def
  :cognitect.aws.appmesh/UpdateVirtualNodeInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.UpdateVirtualNodeInput/meshName
     :cognitect.aws.appmesh.UpdateVirtualNodeInput/spec
     :cognitect.aws.appmesh.UpdateVirtualNodeInput/virtualNodeName]
    :opt-un
    [:cognitect.aws.appmesh.UpdateVirtualNodeInput/clientToken]))

(s/def
  :cognitect.aws.appmesh/DeleteVirtualNodeOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.DeleteVirtualNodeOutput/virtualNode]))

(s/def
  :cognitect.aws.appmesh/VirtualNodeData
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.VirtualNodeData/meshName
     :cognitect.aws.appmesh.VirtualNodeData/virtualNodeName]
    :opt-un
    [:cognitect.aws.appmesh.VirtualNodeData/spec
     :cognitect.aws.appmesh.VirtualNodeData/status
     :cognitect.aws.appmesh.VirtualNodeData/metadata]))

(s/def
  :cognitect.aws.appmesh/DescribeVirtualNodeInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.DescribeVirtualNodeInput/meshName
     :cognitect.aws.appmesh.DescribeVirtualNodeInput/virtualNodeName]))

(s/def :cognitect.aws.appmesh/VirtualRouterStatusCode #{"INACTIVE" "ACTIVE" "DELETED"})

(s/def
  :cognitect.aws.appmesh/ListVirtualNodesInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListVirtualNodesInput/meshName]
    :opt-un
    [:cognitect.aws.appmesh.ListVirtualNodesInput/nextToken
     :cognitect.aws.appmesh.ListVirtualNodesInput/limit]))

(s/def
  :cognitect.aws.appmesh/VirtualRouterStatus
  (s/keys :opt-un [:cognitect.aws.appmesh.VirtualRouterStatus/status]))

(s/def :cognitect.aws.appmesh/Timestamp inst?)

(s/def
  :cognitect.aws.appmesh/DnsServiceDiscovery
  (s/keys :opt-un [:cognitect.aws.appmesh.DnsServiceDiscovery/serviceName]))

(s/def :cognitect.aws.appmesh/MeshStatusCode #{"INACTIVE" "ACTIVE" "DELETED"})

(s/def :cognitect.aws.appmesh/MeshList (s/coll-of :cognitect.aws.appmesh/MeshRef))

(s/def
  :cognitect.aws.appmesh/ListVirtualRoutersLimit
  (s/with-gen
    (s/and int? #(<= 1 % 100))
    #(gen/choose (or 1 Long/MIN_VALUE) (or 100 Long/MAX_VALUE))))

(s/def :cognitect.aws.appmesh/Listeners (s/coll-of :cognitect.aws.appmesh/Listener))

(s/def
  :cognitect.aws.appmesh/CreateMeshInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.CreateMeshInput/meshName]
    :opt-un
    [:cognitect.aws.appmesh.CreateMeshInput/clientToken]))

(s/def :cognitect.aws.appmesh/VirtualRouterList (s/coll-of :cognitect.aws.appmesh/VirtualRouterRef))

(s/def
  :cognitect.aws.appmesh/UpdateVirtualRouterInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.UpdateVirtualRouterInput/meshName
     :cognitect.aws.appmesh.UpdateVirtualRouterInput/spec
     :cognitect.aws.appmesh.UpdateVirtualRouterInput/virtualRouterName]
    :opt-un
    [:cognitect.aws.appmesh.UpdateVirtualRouterInput/clientToken]))

(s/def
  :cognitect.aws.appmesh/ResourceMetadata
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.ResourceMetadata/arn
     :cognitect.aws.appmesh.ResourceMetadata/createdAt
     :cognitect.aws.appmesh.ResourceMetadata/uid
     :cognitect.aws.appmesh.ResourceMetadata/lastUpdatedAt
     :cognitect.aws.appmesh.ResourceMetadata/version]))

(s/def
  :cognitect.aws.appmesh/UpdateRouteOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.UpdateRouteOutput/route]))

(s/def
  :cognitect.aws.appmesh/ListRoutesOutput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListRoutesOutput/routes]
    :opt-un
    [:cognitect.aws.appmesh.ListRoutesOutput/nextToken]))

(s/def
  :cognitect.aws.appmesh/DeleteVirtualNodeInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.DeleteVirtualNodeInput/meshName
     :cognitect.aws.appmesh.DeleteVirtualNodeInput/virtualNodeName]))

(s/def
  :cognitect.aws.appmesh/ListRoutesInput
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.ListRoutesInput/meshName
     :cognitect.aws.appmesh.ListRoutesInput/virtualRouterName]
    :opt-un
    [:cognitect.aws.appmesh.ListRoutesInput/nextToken
     :cognitect.aws.appmesh.ListRoutesInput/limit]))

(s/def
  :cognitect.aws.appmesh/ListVirtualNodesLimit
  (s/with-gen
    (s/and int? #(<= 1 % 100))
    #(gen/choose (or 1 Long/MIN_VALUE) (or 100 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.appmesh/ResourceName
  (s/with-gen
    (s/and string? #(<= 1 (count %) 255))
    (fn []
      (gen/fmap
        #(apply str %)
        (gen/bind (gen/choose (or 1 0) (or 255 100)) #(gen/vector (gen/char-alpha) %))))))

(s/def
  :cognitect.aws.appmesh/ServiceNames
  (s/coll-of :cognitect.aws.appmesh/ServiceName :max-count 10))

(s/def
  :cognitect.aws.appmesh/CreateVirtualNodeOutput
  (s/keys :opt-un [:cognitect.aws.appmesh.CreateVirtualNodeOutput/virtualNode]))

(s/def
  :cognitect.aws.appmesh/VirtualNodeSpec
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.VirtualNodeSpec/serviceDiscovery
     :cognitect.aws.appmesh.VirtualNodeSpec/listeners
     :cognitect.aws.appmesh.VirtualNodeSpec/backends]))

(s/def :cognitect.aws.appmesh/VirtualNodeStatusCode #{"INACTIVE" "ACTIVE" "DELETED"})

(s/def
  :cognitect.aws.appmesh/WeightedTarget
  (s/keys
    :opt-un
    [:cognitect.aws.appmesh.WeightedTarget/virtualNode
     :cognitect.aws.appmesh.WeightedTarget/weight]))

(s/def :cognitect.aws.appmesh/String string?)

(s/def
  :cognitect.aws.appmesh/DescribeMeshInput
  (s/keys :req-un [:cognitect.aws.appmesh.DescribeMeshInput/meshName]))

(s/def :cognitect.aws.appmesh/VirtualNodeList (s/coll-of :cognitect.aws.appmesh/VirtualNodeRef))

(s/def
  :cognitect.aws.appmesh/RouteData
  (s/keys
    :req-un
    [:cognitect.aws.appmesh.RouteData/meshName
     :cognitect.aws.appmesh.RouteData/routeName
     :cognitect.aws.appmesh.RouteData/virtualRouterName]
    :opt-un
    [:cognitect.aws.appmesh.RouteData/spec
     :cognitect.aws.appmesh.RouteData/status
     :cognitect.aws.appmesh.RouteData/metadata]))

(s/def
  :cognitect.aws.appmesh/RouteStatus
  (s/keys :opt-un [:cognitect.aws.appmesh.RouteStatus/status]))

(s/def
  :cognitect.aws.appmesh/ListMeshesLimit
  (s/with-gen
    (s/and int? #(<= 1 % 100))
    #(gen/choose (or 1 Long/MIN_VALUE) (or 100 Long/MAX_VALUE))))

(s/def :cognitect.aws.appmesh/ServiceName string?)

(s/def
  :cognitect.aws.appmesh/PortNumber
  (s/with-gen
    (s/and int? #(<= 1 % 65535))
    #(gen/choose (or 1 Long/MIN_VALUE) (or 65535 Long/MAX_VALUE))))

(s/def
  :cognitect.aws.appmesh/RouteSpec
  (s/keys :opt-un [:cognitect.aws.appmesh.RouteSpec/httpRoute]))

(s/def :cognitect.aws.appmesh.VirtualNodeStatus/status :cognitect.aws.appmesh/VirtualNodeStatusCode)

(s/def :cognitect.aws.appmesh.VirtualRouterRef/arn :cognitect.aws.appmesh/Arn)

(s/def :cognitect.aws.appmesh.VirtualRouterRef/meshName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.VirtualRouterRef/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.ServiceDiscovery/dns :cognitect.aws.appmesh/DnsServiceDiscovery)

(s/def
  :cognitect.aws.appmesh.CreateVirtualRouterOutput/virtualRouter
  :cognitect.aws.appmesh/VirtualRouterData)

(s/def :cognitect.aws.appmesh.MeshStatus/status :cognitect.aws.appmesh/MeshStatusCode)

(s/def :cognitect.aws.appmesh.DescribeRouteOutput/route :cognitect.aws.appmesh/RouteData)

(s/def
  :cognitect.aws.appmesh.DescribeVirtualRouterInput/meshName
  :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DescribeVirtualRouterInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.VirtualNodeRef/arn :cognitect.aws.appmesh/Arn)

(s/def :cognitect.aws.appmesh.VirtualNodeRef/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.VirtualNodeRef/virtualNodeName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.CreateRouteOutput/route :cognitect.aws.appmesh/RouteData)

(s/def :cognitect.aws.appmesh.VirtualRouterSpec/serviceNames :cognitect.aws.appmesh/ServiceNames)

(s/def
  :cognitect.aws.appmesh.DescribeVirtualNodeOutput/virtualNode
  :cognitect.aws.appmesh/VirtualNodeData)

(s/def :cognitect.aws.appmesh.CreateVirtualNodeInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.CreateVirtualNodeInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.CreateVirtualNodeInput/spec :cognitect.aws.appmesh/VirtualNodeSpec)

(s/def
  :cognitect.aws.appmesh.CreateVirtualNodeInput/virtualNodeName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.DeleteMeshInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.MeshRef/arn :cognitect.aws.appmesh/Arn)

(s/def :cognitect.aws.appmesh.MeshRef/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.UpdateRouteInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.UpdateRouteInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.UpdateRouteInput/routeName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.UpdateRouteInput/spec :cognitect.aws.appmesh/RouteSpec)

(s/def
  :cognitect.aws.appmesh.UpdateRouteInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.Listener/healthCheck :cognitect.aws.appmesh/HealthCheckPolicy)

(s/def :cognitect.aws.appmesh.Listener/portMapping :cognitect.aws.appmesh/PortMapping)

(s/def
  :cognitect.aws.appmesh.UpdateVirtualRouterOutput/virtualRouter
  :cognitect.aws.appmesh/VirtualRouterData)

(s/def :cognitect.aws.appmesh.ListMeshesOutput/meshes :cognitect.aws.appmesh/MeshList)

(s/def :cognitect.aws.appmesh.ListMeshesOutput/nextToken :cognitect.aws.appmesh/String)

(s/def
  :cognitect.aws.appmesh.UpdateVirtualNodeOutput/virtualNode
  :cognitect.aws.appmesh/VirtualNodeData)

(s/def
  :cognitect.aws.appmesh.HttpRouteAction/weightedTargets
  :cognitect.aws.appmesh/WeightedTargets)

(s/def :cognitect.aws.appmesh.VirtualRouterData/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.VirtualRouterData/metadata :cognitect.aws.appmesh/ResourceMetadata)

(s/def :cognitect.aws.appmesh.VirtualRouterData/spec :cognitect.aws.appmesh/VirtualRouterSpec)

(s/def :cognitect.aws.appmesh.VirtualRouterData/status :cognitect.aws.appmesh/VirtualRouterStatus)

(s/def
  :cognitect.aws.appmesh.VirtualRouterData/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.PortMapping/port :cognitect.aws.appmesh/PortNumber)

(s/def :cognitect.aws.appmesh.PortMapping/protocol :cognitect.aws.appmesh/PortProtocol)

(s/def :cognitect.aws.appmesh.ListMeshesInput/limit :cognitect.aws.appmesh/ListMeshesLimit)

(s/def :cognitect.aws.appmesh.ListMeshesInput/nextToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.DeleteVirtualRouterInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DeleteVirtualRouterInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.HttpRoute/action :cognitect.aws.appmesh/HttpRouteAction)

(s/def :cognitect.aws.appmesh.HttpRoute/match :cognitect.aws.appmesh/HttpRouteMatch)

(s/def :cognitect.aws.appmesh.CreateMeshOutput/mesh :cognitect.aws.appmesh/MeshData)

(s/def
  :cognitect.aws.appmesh.ListVirtualRoutersInput/limit
  :cognitect.aws.appmesh/ListVirtualRoutersLimit)

(s/def :cognitect.aws.appmesh.ListVirtualRoutersInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.ListVirtualRoutersInput/nextToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.DescribeRouteInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.DescribeRouteInput/routeName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DescribeRouteInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.HttpRouteMatch/prefix :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.CreateVirtualRouterInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.CreateVirtualRouterInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.CreateVirtualRouterInput/spec
  :cognitect.aws.appmesh/VirtualRouterSpec)

(s/def
  :cognitect.aws.appmesh.CreateVirtualRouterInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.CreateRouteInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.CreateRouteInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.CreateRouteInput/routeName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.CreateRouteInput/spec :cognitect.aws.appmesh/RouteSpec)

(s/def
  :cognitect.aws.appmesh.CreateRouteInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.RouteRef/arn :cognitect.aws.appmesh/Arn)

(s/def :cognitect.aws.appmesh.RouteRef/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.RouteRef/routeName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.RouteRef/virtualRouterName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.DeleteMeshOutput/mesh :cognitect.aws.appmesh/MeshData)

(s/def :cognitect.aws.appmesh.ListVirtualNodesOutput/nextToken :cognitect.aws.appmesh/String)

(s/def
  :cognitect.aws.appmesh.ListVirtualNodesOutput/virtualNodes
  :cognitect.aws.appmesh/VirtualNodeList)

(s/def :cognitect.aws.appmesh.MeshData/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.MeshData/metadata :cognitect.aws.appmesh/ResourceMetadata)

(s/def :cognitect.aws.appmesh.MeshData/status :cognitect.aws.appmesh/MeshStatus)

(s/def
  :cognitect.aws.appmesh.DeleteVirtualRouterOutput/virtualRouter
  :cognitect.aws.appmesh/VirtualRouterData)

(s/def
  :cognitect.aws.appmesh.HealthCheckPolicy/healthyThreshold
  :cognitect.aws.appmesh/NonNegativeInt)

(s/def
  :cognitect.aws.appmesh.HealthCheckPolicy/intervalMillis
  :cognitect.aws.appmesh/DurationMillis)

(s/def :cognitect.aws.appmesh.HealthCheckPolicy/path :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.HealthCheckPolicy/port :cognitect.aws.appmesh/PortNumber)

(s/def :cognitect.aws.appmesh.HealthCheckPolicy/protocol :cognitect.aws.appmesh/PortProtocol)

(s/def :cognitect.aws.appmesh.HealthCheckPolicy/timeoutMillis :cognitect.aws.appmesh/DurationMillis)

(s/def
  :cognitect.aws.appmesh.HealthCheckPolicy/unhealthyThreshold
  :cognitect.aws.appmesh/NonNegativeInt)

(s/def :cognitect.aws.appmesh.DeleteRouteInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.DeleteRouteInput/routeName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DeleteRouteInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DescribeVirtualRouterOutput/virtualRouter
  :cognitect.aws.appmesh/VirtualRouterData)

(s/def :cognitect.aws.appmesh.DescribeMeshOutput/mesh :cognitect.aws.appmesh/MeshData)

(s/def :cognitect.aws.appmesh.DeleteRouteOutput/route :cognitect.aws.appmesh/RouteData)

(s/def :cognitect.aws.appmesh.ListVirtualRoutersOutput/nextToken :cognitect.aws.appmesh/String)

(s/def
  :cognitect.aws.appmesh.ListVirtualRoutersOutput/virtualRouters
  :cognitect.aws.appmesh/VirtualRouterList)

(s/def :cognitect.aws.appmesh.UpdateVirtualNodeInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.UpdateVirtualNodeInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.UpdateVirtualNodeInput/spec :cognitect.aws.appmesh/VirtualNodeSpec)

(s/def
  :cognitect.aws.appmesh.UpdateVirtualNodeInput/virtualNodeName
  :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DeleteVirtualNodeOutput/virtualNode
  :cognitect.aws.appmesh/VirtualNodeData)

(s/def :cognitect.aws.appmesh.VirtualNodeData/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.VirtualNodeData/metadata :cognitect.aws.appmesh/ResourceMetadata)

(s/def :cognitect.aws.appmesh.VirtualNodeData/spec :cognitect.aws.appmesh/VirtualNodeSpec)

(s/def :cognitect.aws.appmesh.VirtualNodeData/status :cognitect.aws.appmesh/VirtualNodeStatus)

(s/def :cognitect.aws.appmesh.VirtualNodeData/virtualNodeName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.DescribeVirtualNodeInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DescribeVirtualNodeInput/virtualNodeName
  :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.ListVirtualNodesInput/limit
  :cognitect.aws.appmesh/ListVirtualNodesLimit)

(s/def :cognitect.aws.appmesh.ListVirtualNodesInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.ListVirtualNodesInput/nextToken :cognitect.aws.appmesh/String)

(s/def
  :cognitect.aws.appmesh.VirtualRouterStatus/status
  :cognitect.aws.appmesh/VirtualRouterStatusCode)

(s/def :cognitect.aws.appmesh.DnsServiceDiscovery/serviceName :cognitect.aws.appmesh/ServiceName)

(s/def :cognitect.aws.appmesh.CreateMeshInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.CreateMeshInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.UpdateVirtualRouterInput/clientToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.UpdateVirtualRouterInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.UpdateVirtualRouterInput/spec
  :cognitect.aws.appmesh/VirtualRouterSpec)

(s/def
  :cognitect.aws.appmesh.UpdateVirtualRouterInput/virtualRouterName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.ResourceMetadata/arn :cognitect.aws.appmesh/Arn)

(s/def :cognitect.aws.appmesh.ResourceMetadata/createdAt :cognitect.aws.appmesh/Timestamp)

(s/def :cognitect.aws.appmesh.ResourceMetadata/lastUpdatedAt :cognitect.aws.appmesh/Timestamp)

(s/def :cognitect.aws.appmesh.ResourceMetadata/uid :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.ResourceMetadata/version :cognitect.aws.appmesh/Long)

(s/def :cognitect.aws.appmesh.UpdateRouteOutput/route :cognitect.aws.appmesh/RouteData)

(s/def :cognitect.aws.appmesh.ListRoutesOutput/nextToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.ListRoutesOutput/routes :cognitect.aws.appmesh/RouteList)

(s/def :cognitect.aws.appmesh.DeleteVirtualNodeInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.DeleteVirtualNodeInput/virtualNodeName
  :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.ListRoutesInput/limit :cognitect.aws.appmesh/ListRoutesLimit)

(s/def :cognitect.aws.appmesh.ListRoutesInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.ListRoutesInput/nextToken :cognitect.aws.appmesh/String)

(s/def :cognitect.aws.appmesh.ListRoutesInput/virtualRouterName :cognitect.aws.appmesh/ResourceName)

(s/def
  :cognitect.aws.appmesh.CreateVirtualNodeOutput/virtualNode
  :cognitect.aws.appmesh/VirtualNodeData)

(s/def :cognitect.aws.appmesh.VirtualNodeSpec/backends :cognitect.aws.appmesh/Backends)

(s/def :cognitect.aws.appmesh.VirtualNodeSpec/listeners :cognitect.aws.appmesh/Listeners)

(s/def
  :cognitect.aws.appmesh.VirtualNodeSpec/serviceDiscovery
  :cognitect.aws.appmesh/ServiceDiscovery)

(s/def :cognitect.aws.appmesh.WeightedTarget/virtualNode :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.WeightedTarget/weight :cognitect.aws.appmesh/PercentInt)

(s/def :cognitect.aws.appmesh.DescribeMeshInput/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.RouteData/meshName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.RouteData/metadata :cognitect.aws.appmesh/ResourceMetadata)

(s/def :cognitect.aws.appmesh.RouteData/routeName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.RouteData/spec :cognitect.aws.appmesh/RouteSpec)

(s/def :cognitect.aws.appmesh.RouteData/status :cognitect.aws.appmesh/RouteStatus)

(s/def :cognitect.aws.appmesh.RouteData/virtualRouterName :cognitect.aws.appmesh/ResourceName)

(s/def :cognitect.aws.appmesh.RouteStatus/status :cognitect.aws.appmesh/RouteStatusCode)

(s/def :cognitect.aws.appmesh.RouteSpec/httpRoute :cognitect.aws.appmesh/HttpRoute)

