/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common.http;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/cognifide/gradle/common/http/PreemptiveAuthInterceptor;", "Lorg/apache/http/HttpRequestInterceptor;", "()V", "process", "", "request", "Lorg/apache/http/HttpRequest;", "context", "Lorg/apache/http/protocol/HttpContext;", "common-plugin"})
public final class PreemptiveAuthInterceptor
implements HttpRequestInterceptor {
    public void process(@NotNull HttpRequest request, @NotNull HttpContext context) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getAttribute("http.auth.target-scope");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.http.auth.AuthState");
        }
        AuthState authState = (AuthState)object;
        if (authState.getAuthScheme() == null) {
            Object object2 = context.getAttribute("http.auth.credentials-provider");
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.apache.http.client.CredentialsProvider");
            }
            CredentialsProvider credsProvider = (CredentialsProvider)object2;
            Object object3 = context.getAttribute("http.target_host");
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.apache.http.HttpHost");
            }
            HttpHost targetHost = (HttpHost)object3;
            Credentials credentials = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
            if (credentials == null) {
                throw (Throwable)new HttpException("No credentials for preemptive authentication");
            }
            Credentials creds = credentials;
            authState.update((AuthScheme)new BasicScheme(), creds);
        }
    }
}

