/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common.file.watcher;

import com.cognifide.gradle.common.file.watcher.Event;
import com.cognifide.gradle.common.file.watcher.EventType;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tH\u0016J\u0012\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/cognifide/gradle/common/file/watcher/DelegatingFileAlterationListener;", "Lorg/apache/commons/io/monitor/FileAlterationListener;", "notify", "Lkotlin/Function1;", "Lcom/cognifide/gradle/common/file/watcher/Event;", "", "(Lkotlin/jvm/functions/Function1;)V", "onDirectoryChange", "directory", "Ljava/io/File;", "onDirectoryCreate", "onDirectoryDelete", "onFileChange", "file", "onFileCreate", "onFileDelete", "onStart", "observer", "Lorg/apache/commons/io/monitor/FileAlterationObserver;", "onStop", "common-plugin"})
public final class DelegatingFileAlterationListener
implements FileAlterationListener {
    private final Function1<Event, Unit> notify;

    public void onFileCreate(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.notify.invoke((Object)new Event(file2, EventType.FILE_CREATED));
    }

    public void onFileChange(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.notify.invoke((Object)new Event(file2, EventType.FILE_CHANGED));
    }

    public void onFileDelete(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.notify.invoke((Object)new Event(file2, EventType.FILE_DELETED));
    }

    public void onDirectoryCreate(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.notify.invoke((Object)new Event(directory, EventType.DIR_CREATED));
    }

    public void onDirectoryDelete(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.notify.invoke((Object)new Event(directory, EventType.DIR_DELETED));
    }

    public void onDirectoryChange(@Nullable File directory) {
    }

    public void onStart(@Nullable FileAlterationObserver observer) {
    }

    public void onStop(@Nullable FileAlterationObserver observer) {
    }

    public DelegatingFileAlterationListener(@NotNull Function1<? super Event, Unit> notify2) {
        Intrinsics.checkNotNullParameter(notify2, (String)"notify");
        this.notify = notify2;
    }
}

